/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.forwarding.ForwardingChannel;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class ForwardingConfiguration {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$forwarding$ForwardingConfiguration == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfiguration = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfiguration")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfiguration));
    protected StartStopState state = new StartStopState(2);
    protected String addressToBind;
    protected String hostToConnect;
    protected String name;
    protected int portToBind;
    protected int portToConnect;
    protected ForwardingConfigurationMonitor monitor = new ForwardingConfigurationMonitor();
    protected EventListenerList listenerList = new EventListenerList();
    private List activeForwardings = new Vector();
    static /* synthetic */ Class class$com$sshtools$j2ssh$forwarding$ForwardingConfiguration;
    static /* synthetic */ Class class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener;

    public ForwardingConfiguration(String string, String string2, int n, String string3, int n2) {
        this.addressToBind = string2;
        this.portToBind = n;
        this.name = string;
        this.hostToConnect = string3;
        this.portToConnect = n2;
    }

    protected ForwardingConfiguration(String string, int n) {
        this(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(":").append(String.valueOf(n)))), string, n, "[Specified by connecting computer]", -1);
    }

    public void addForwardingConfigurationListener(ForwardingConfigurationListener forwardingConfigurationListener) {
        this.listenerList.add(class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener, forwardingConfigurationListener);
    }

    public void removeForwardingConfigurationListener(ForwardingConfigurationListener forwardingConfigurationListener) {
        this.listenerList.remove(class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener, forwardingConfigurationListener);
    }

    public List getActiveForwardingChannels() {
        return this.activeForwardings;
    }

    public String getAddressToBind() {
        return this.addressToBind;
    }

    public String getHostToConnect() {
        return this.hostToConnect;
    }

    public String getName() {
        return this.name;
    }

    public int getPortToBind() {
        return this.portToBind;
    }

    public int getPortToConnect() {
        return this.portToConnect;
    }

    public StartStopState getState() {
        return this.state;
    }

    public void start() throws IOException {
        this.state.setValue(1);
    }

    public void stop() {
        this.state.setValue(2);
    }

    public ForwardingChannel createForwardingChannel(String string, String string2, int n, String string3, int n2) throws ForwardingConfigurationException {
        if (this.state.getValue() == 2) {
            throw new ForwardingConfigurationException("The forwarding has been stopped");
        }
        if (!(string.equals("direct-tcpip") || string.equals("forwarded-tcpip") || string.equals("x11"))) {
            throw new ForwardingConfigurationException("The channel type must either be ForwardingChannel.LOCAL_FORWARDING_CHANNEL_TYPE or ForwardingChannel.REMOTE_FORWARDING_CHANNEL_TYPE");
        }
        ForwardingChannel forwardingChannel = new ForwardingChannel(string, this, string3, n2);
        forwardingChannel.addEventListener(this.monitor);
        return forwardingChannel;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ForwardingConfigurationMonitor
    implements ChannelEventListener {
        public void onChannelOpen(Channel channel) {
            ForwardingConfigurationListener[] forwardingConfigurationListenerArray;
            if (log.isDebugEnabled()) {
                forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])channel;
                log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Opening forwarding channel from ").append(forwardingConfigurationListenerArray.getRemoteSocketAddress().getHostName()).append(":").append(String.valueOf(forwardingConfigurationListenerArray.getRemoteSocketAddress().getPort())))));
            }
            ForwardingConfiguration.this.activeForwardings.add(channel);
            forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener);
            for (int i = forwardingConfigurationListenerArray.length - 1; i >= 0; --i) {
                forwardingConfigurationListenerArray[i].opened((ForwardingChannel)channel);
            }
        }

        public void onChannelEOF(Channel channel) {
            try {
                channel.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onChannelClose(Channel channel) {
            ForwardingConfigurationListener[] forwardingConfigurationListenerArray;
            if (log.isDebugEnabled()) {
                forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])channel;
                log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Closing forwarding channel from ").append(forwardingConfigurationListenerArray.getRemoteSocketAddress().getHostName()).append(":").append(String.valueOf(forwardingConfigurationListenerArray.getRemoteSocketAddress().getPort())))));
            }
            ForwardingConfiguration.this.activeForwardings.remove(channel);
            forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener);
            for (int i = forwardingConfigurationListenerArray.length - 1; i >= 0; --i) {
                forwardingConfigurationListenerArray[i].closed((ForwardingChannel)channel);
            }
        }

        public void onDataReceived(Channel channel, int n) {
            ForwardingConfigurationListener[] forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener);
            for (int i = forwardingConfigurationListenerArray.length - 1; i >= 0; --i) {
                forwardingConfigurationListenerArray[i].dataReceived((ForwardingChannel)channel, n);
            }
        }

        public void onDataSent(Channel channel, int n) {
            ForwardingConfigurationListener[] forwardingConfigurationListenerArray = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener = ForwardingConfiguration.class$("com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingConfigurationListener);
            for (int i = forwardingConfigurationListenerArray.length - 1; i >= 0; --i) {
                forwardingConfigurationListenerArray[i].dataSent((ForwardingChannel)channel, n);
            }
        }
    }
}

