/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.forwarding.ForwardingChannel;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public abstract class ForwardingListener
extends ForwardingConfiguration
implements Runnable {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$forwarding$ForwardingListener == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingListener = ForwardingListener.class$("com.sshtools.j2ssh.forwarding.ForwardingListener")) : class$com$sshtools$j2ssh$forwarding$ForwardingListener));
    private ConnectionProtocol connection;
    private ServerSocket server;
    private Thread thread;
    private boolean listening;
    static /* synthetic */ Class class$com$sshtools$j2ssh$forwarding$ForwardingListener;

    public ForwardingListener(String string, ConnectionProtocol connectionProtocol, String string2, int n, String string3, int n2) {
        super(string, string2, n, string3, n2);
        log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Creating forwarding listener named '").append(string).append("'"))));
        this.connection = connectionProtocol;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Address to bind: ".concat(String.valueOf(String.valueOf(this.getAddressToBind()))));
            log.debug((Object)"Port to bind: ".concat(String.valueOf(String.valueOf(String.valueOf(this.getPortToBind())))));
            log.debug((Object)"Host to connect: ".concat(String.valueOf(String.valueOf(string3))));
            log.debug((Object)"Port to connect: ".concat(String.valueOf(String.valueOf(n2))));
        }
    }

    public ForwardingListener(ConnectionProtocol connectionProtocol, String string, int n) {
        this(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(":").append(String.valueOf(n)))), connectionProtocol, string, n, "[Specified by connecting computer]", -1);
    }

    public int getLocalPort() {
        return this.server == null ? -1 : this.server.getLocalPort();
    }

    public boolean isListening() {
        return this.listening;
    }

    public void run() {
        try {
            try {
                log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Starting forwarding listener thread for '").append(this.name).append("'"))));
                while (this.state.getValue() == 1) {
                    this.listening = true;
                    Socket socket = this.server.accept();
                    if (this.state.getValue() == 2 || socket == null) break;
                    log.info((Object)"Connection accepted, creating forwarding channel");
                    try {
                        ForwardingChannel forwardingChannel = this.createChannel(this.hostToConnect, this.portToConnect, socket);
                        forwardingChannel.bindSocket(socket);
                        if (this.connection.openChannel(forwardingChannel)) {
                            log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Forwarding channel for '").append(this.name).append("' is open"))));
                            continue;
                        }
                        log.warn((Object)"Failed to open forwarding chanel ".concat(String.valueOf(String.valueOf(this.name))));
                    }
                    catch (Exception exception) {
                        log.warn((Object)"Failed to open forwarding chanel ".concat(String.valueOf(String.valueOf(this.name))), (Throwable)exception);
                    }
                }
                Object var4_5 = null;
                this.stop();
            }
            catch (IOException iOException) {
                if (this.state.getValue() == 1) {
                    log.warn((Object)String.valueOf(String.valueOf(new StringBuffer("Local forwarding listener to ").append(this.hostToConnect).append(":").append(String.valueOf(this.portToConnect)).append(" has failed"))), (Throwable)iOException);
                }
                Object var4_6 = null;
                this.stop();
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.stop();
            throw throwable;
        }
    }

    public boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    public void start() throws IOException {
        super.start();
        try {
            this.server = new ServerSocket(this.getPortToBind(), 50, InetAddress.getByName(this.getAddressToBind()));
        }
        catch (IOException iOException) {
            log.warn((Object)String.valueOf(String.valueOf(new StringBuffer("Local forwarding listener to ").append(this.hostToConnect).append(":").append(String.valueOf(this.portToConnect)).append(" failed to open socket"))), (Throwable)iOException);
            super.stop();
            return;
        }
        this.thread = new SshThread(this, "Forwarding listener", true);
        this.thread = new SshThread(this, "Forwarding listener", true);
        this.thread.start();
    }

    public void stop() {
        super.stop();
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException iOException) {
            log.warn((Object)"Forwarding listener failed to stop", (Throwable)iOException);
        }
        this.thread = null;
        this.listening = false;
    }

    protected abstract ForwardingChannel createChannel(String var1, int var2, Socket var3) throws ForwardingConfigurationException;

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

