/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.session;

import com.sshtools.j2ssh.agent.AgentForwardingChannel;
import com.sshtools.j2ssh.agent.SshAgentClient;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ChannelInputStream;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.session.PseudoTerminal;
import com.sshtools.j2ssh.session.SignalListener;
import com.sshtools.j2ssh.subsystem.SubsystemClient;
import com.sshtools.j2ssh.transport.ServiceOperationException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.log4j.Logger;

public class SessionChannelClient
extends Channel {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$session$SessionChannelClient == null ? (class$com$sshtools$j2ssh$session$SessionChannelClient = SessionChannelClient.class$("com.sshtools.j2ssh.session.SessionChannelClient")) : class$com$sshtools$j2ssh$session$SessionChannelClient));
    private Integer exitCode = null;
    private ChannelInputStream stderr = null;
    private String sessionType = "Uninitialized";
    private SubsystemClient subsystem;
    private boolean localFlowControl = false;
    private SignalListener signalListener;
    static /* synthetic */ Class class$com$sshtools$j2ssh$session$SessionChannelClient;

    public byte[] getChannelOpenData() {
        return null;
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }

    public String getChannelType() {
        return "session";
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected int getMaximumWindowSpace() {
        return 32648;
    }

    protected int getMaximumPacketSize() {
        return 32648;
    }

    public void setSignalListener(SignalListener signalListener) {
        this.signalListener = signalListener;
    }

    public boolean setEnvironmentVariable(String string, String string2) throws ServiceOperationException, TransportProtocolException {
        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Requesting environment variable to be set [").append(string).append("=").append(string2).append("]"))));
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeString(string2);
            boolean bl = this.connection.sendChannelRequest(this, "env", true, byteArrayWriter.toByteArray());
            return bl;
        }
        catch (IOException iOException) {
            throw new ServiceOperationException("Could not set environment variable; error writing request data");
        }
    }

    public boolean requestAgentForwarding() throws IOException {
        log.info((Object)"Requesting agent forwarding for the session");
        boolean bl = this.connection.sendChannelRequest(this, "auth-agent-req", true, null);
        if (bl) {
            this.connection.addChannelFactory("auth-agent", new ChannelFactory(){

                public Channel createChannel(String string, byte[] byArray) throws InvalidChannelException {
                    try {
                        AgentForwardingChannel agentForwardingChannel = new AgentForwardingChannel(false);
                        Socket socket = SshAgentClient.connectAgentSocket(System.getProperty("sshtools.agent"), 5);
                        agentForwardingChannel.bindSocket(socket);
                        AgentForwardingChannel agentForwardingChannel2 = agentForwardingChannel;
                        return agentForwardingChannel2;
                    }
                    catch (Exception exception) {
                        throw new InvalidChannelException(exception.getMessage());
                    }
                }
            });
        }
        return bl;
    }

    public boolean requestX11Forwarding(int n, String string) throws ServiceOperationException, TransportProtocolException {
        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Requesting X11 forwarding for display ").append(n).append(" using cookie ").append(string))));
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeBoolean(false);
            byteArrayWriter.writeString("MIT-MAGIC-COOKIE-1");
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeUINT32(new UnsignedInteger32(String.valueOf(n)));
            boolean bl = this.connection.sendChannelRequest(this, "x11-req", true, byteArrayWriter.toByteArray());
            return bl;
        }
        catch (IOException iOException) {
            throw new ServiceOperationException("Could not set environment variable; error writing request data");
        }
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void changeTerminalDimensions(PseudoTerminal pseudoTerminal) throws ServiceOperationException, TransportProtocolException {
        log.debug((Object)"Changing terminal dimensions");
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeInt(pseudoTerminal.getColumns());
            byteArrayWriter.writeInt(pseudoTerminal.getRows());
            byteArrayWriter.writeInt(pseudoTerminal.getWidth());
            byteArrayWriter.writeInt(pseudoTerminal.getHeight());
            this.connection.sendChannelRequest(this, "window-change", false, byteArrayWriter.toByteArray());
        }
        catch (IOException iOException) {
            throw new ServiceOperationException("Failed to change terminal dimensions; error writing request data");
        }
    }

    public boolean executeCommand(String string) throws ServiceOperationException, TransportProtocolException {
        log.info((Object)"Requesting command execution");
        log.debug((Object)"Command is ".concat(String.valueOf(String.valueOf(string))));
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            if (this.connection.sendChannelRequest(this, "exec", true, byteArrayWriter.toByteArray())) {
                if (this.sessionType.equals("Uninitialized")) {
                    this.sessionType = "exec ".concat(String.valueOf(String.valueOf(string)));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            throw new ServiceOperationException("Failed to request command execution; error writing request data");
        }
    }

    public boolean requestPseudoTerminal(PseudoTerminal pseudoTerminal) throws ServiceOperationException, TransportProtocolException {
        log.info((Object)"Requesting pseudo terminal");
        log.debug((Object)"Terminal Type is ".concat(String.valueOf(String.valueOf(pseudoTerminal.getTerm()))));
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(pseudoTerminal.getTerm());
            byteArrayWriter.writeInt(pseudoTerminal.getColumns());
            byteArrayWriter.writeInt(pseudoTerminal.getRows());
            byteArrayWriter.writeInt(pseudoTerminal.getWidth());
            byteArrayWriter.writeInt(pseudoTerminal.getHeight());
            byteArrayWriter.writeString(pseudoTerminal.getEncodedTerminalModes());
            boolean bl = this.connection.sendChannelRequest(this, "pty-req", true, byteArrayWriter.toByteArray());
            return bl;
        }
        catch (IOException iOException) {
            throw new ServiceOperationException("Failed to write channel request data to ByteArrayWriter");
        }
    }

    public boolean startShell() throws IOException {
        log.debug((Object)"Requesting users shell");
        if (this.connection.sendChannelRequest(this, "shell", true, null)) {
            if (this.sessionType.equals("Uninitialized")) {
                this.sessionType = "shell";
            }
            return true;
        }
        return false;
    }

    public boolean startSubsystem(String string) throws ServiceOperationException, TransportProtocolException {
        log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Starting ").append(string).append(" subsystem"))));
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(string);
            if (this.connection.sendChannelRequest(this, "subsystem", true, byteArrayWriter.toByteArray())) {
                if (this.sessionType.equals("Uninitialized")) {
                    this.sessionType = string;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            throw new ServiceOperationException(String.valueOf(String.valueOf(new StringBuffer("Failed to start the ").append(string).append(" subsystem; could not write request data"))));
        }
    }

    public boolean startSubsystem(SubsystemClient subsystemClient) throws IOException {
        boolean bl = this.startSubsystem(subsystemClient.getName());
        if (bl) {
            this.subsystem = subsystemClient;
            subsystemClient.setSessionChannel(this);
            subsystemClient.start();
        }
        return bl;
    }

    public boolean isLocalFlowControlEnabled() {
        return this.localFlowControl;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(String string) {
        this.sessionType = string;
    }

    public SubsystemClient getSubsystem() {
        return this.subsystem;
    }

    protected void onChannelClose() throws ServiceOperationException {
        Integer n = this.getExitCode();
        if (n != null) {
            log.debug((Object)"Exit code ".concat(String.valueOf(String.valueOf(n.toString()))));
        }
    }

    protected void onChannelEOF() throws ServiceOperationException {
    }

    protected void onChannelOpen() throws InvalidChannelException {
        this.stderr = new ChannelInputStream(this.incoming, new Integer(1));
    }

    public InputStream getStderrInputStream() throws ServiceOperationException {
        if (this.stderr == null) {
            throw new ServiceOperationException("The session must be started first!");
        }
        return this.stderr;
    }

    protected void onChannelRequest(String string, boolean bl, byte[] byArray) throws IOException {
        log.debug((Object)"Channel Request received: ".concat(String.valueOf(String.valueOf(string))));
        if (string.equals("exit-status")) {
            this.exitCode = new Integer((int)ByteArrayReader.readInt(byArray, 0));
            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Exit code of ").append(this.exitCode.toString()).append(" received"))));
        } else if (string.equals("exit-signal")) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string2 = byteArrayReader.readString();
            boolean bl2 = byteArrayReader.read() != 0;
            String string3 = byteArrayReader.readString();
            String string4 = byteArrayReader.readString();
            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Exit signal ").append(string2).append(" received"))));
            log.debug((Object)"Signal message: ".concat(String.valueOf(String.valueOf(string3))));
            log.debug((Object)"Core dumped: ".concat(String.valueOf(String.valueOf(String.valueOf(bl2)))));
            if (this.signalListener != null) {
                this.signalListener.onExitSignal(string2, bl2, string3);
            }
        } else if (string.equals("xon-xoff")) {
            if (byArray.length >= 1) {
                this.localFlowControl = byArray[0] != 0;
            }
        } else if (string.equals("signal")) {
            String string5 = ByteArrayReader.readString(byArray, 0);
            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Signal ").append(string5).append(" received"))));
            if (this.signalListener != null) {
                this.signalListener.onSignal(string5);
            }
        } else if (bl) {
            this.connection.sendChannelRequestFailure(this);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

