/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.session;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.agent.SshAgentForwardingListener;
import com.sshtools.j2ssh.configuration.AllowedSubsystem;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelOutputStream;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.platform.NativeProcessProvider;
import com.sshtools.j2ssh.session.PseudoTerminalWrapper;
import com.sshtools.j2ssh.subsystem.SubsystemServer;
import com.sshtools.j2ssh.transport.ServiceOperationException;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SessionChannelServer
extends Channel {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$session$SessionChannelServer == null ? (class$com$sshtools$j2ssh$session$SessionChannelServer = SessionChannelServer.class$("com.sshtools.j2ssh.session.SessionChannelServer")) : class$com$sshtools$j2ssh$session$SessionChannelServer));
    public static final String SESSION_CHANNEL_TYPE = "session";
    private static Map allowedSubsystems = new HashMap();
    private Map environment = new HashMap();
    private NativeProcessProvider processInstance;
    private SubsystemServer subsystemInstance;
    private Thread thread;
    private IOStreamConnector ios;
    private ChannelOutputStream stderrOut;
    private InputStream stderrIn;
    private ProcessMonitorThread processMonitor;
    private PseudoTerminalWrapper pty;
    private SshAgentForwardingListener agent;
    static /* synthetic */ Class class$com$sshtools$j2ssh$session$SessionChannelServer;

    public SessionChannelServer() throws ConfigurationException {
        allowedSubsystems.putAll(ConfigurationLoader.getServerConfiguration().getSubsystems());
    }

    private void bindStderrInputStream(InputStream inputStream) {
        this.stderrIn = inputStream;
        this.ios = new IOStreamConnector(inputStream, this.stderrOut);
    }

    protected void onChangeTerminalDimensions(int n, int n2, int n3, int n4) {
    }

    protected void onChannelClose() throws ServiceOperationException {
        if (this.agent != null) {
            this.agent.removeReference(this);
        }
        if (this.processInstance != null && this.processInstance.stillActive()) {
            this.processInstance.kill();
        }
        if (this.subsystemInstance != null) {
            this.subsystemInstance.stop();
        }
        if (this.processMonitor != null) {
            StartStopState startStopState = this.processMonitor.getState();
            try {
                startStopState.waitForState(2);
            }
            catch (InterruptedException interruptedException) {
                throw new ServiceOperationException("The process monitor was interrupted");
            }
        }
    }

    protected void onChannelEOF() throws ServiceOperationException {
    }

    protected void onChannelExtData(byte[] byArray) throws ServiceOperationException {
    }

    protected void onChannelOpen() throws InvalidChannelException {
        this.stderrOut = new ChannelOutputStream(this, new Integer(1));
    }

    protected boolean onExecuteCommand(String string) throws IOException {
        log.debug((Object)"Executing command ".concat(String.valueOf(String.valueOf(string))));
        if (this.processInstance == null) {
            this.processInstance = NativeProcessProvider.newInstance();
        }
        if (this.processInstance == null) {
            log.debug((Object)"Failed to create process");
            return false;
        }
        boolean bl = this.processInstance.createProcess(string, this.environment);
        if (bl) {
            if (this.pty != null) {
                this.pty.bindMasterOutputStream(this.getOutputStream());
                this.pty.bindMasterInputStream(this.getInputStream());
                this.pty.bindSlaveInputStream(this.processInstance.getInputStream());
                this.pty.bindSlaveOutputStream(this.processInstance.getOutputStream());
                this.pty.initialize();
                this.bindInputStream(this.pty.getMasterInputStream());
                this.bindStderrInputStream(this.processInstance.getStderrInputStream());
            } else {
                this.bindInputStream(this.processInstance.getInputStream());
                this.bindOutputStream(this.processInstance.getOutputStream());
                this.bindStderrInputStream(this.processInstance.getStderrInputStream());
            }
        }
        return bl;
    }

    protected boolean onRequestPseudoTerminal(String string, int n, int n2, int n3, int n4, String string2) {
        this.processInstance = NativeProcessProvider.newInstance();
        if (this.processInstance.supportsPseudoTerminal(string)) {
            return this.processInstance.allocatePseudoTerminal(string, n, n2, n3, n4, string2);
        }
        this.pty = new PseudoTerminalWrapper(string, n, n2, n3, n4, string2);
        return true;
    }

    protected void onSetEnvironmentVariable(String string, String string2) {
        this.environment.put(string, string2);
    }

    protected boolean onStartShell() throws IOException {
        String string = ConfigurationLoader.getServerConfiguration().getTerminalProvider();
        if (this.processInstance == null) {
            this.processInstance = NativeProcessProvider.newInstance();
        }
        if (string != null && !string.trim().equals("")) {
            int n = string.indexOf("%DEFAULT_TERMINAL%");
            if (n > -1) {
                string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(n > 0 ? string.substring(0, n) : ""))).append(this.processInstance.getDefaultTerminalProvider()).append(n + 18 < string.length() ? string.substring(n + 18) : "")));
            }
        } else {
            string = this.processInstance.getDefaultTerminalProvider();
        }
        return this.onExecuteCommand(string);
    }

    protected boolean onStartSubsystem(String string) {
        boolean bl = false;
        try {
            if (!allowedSubsystems.containsKey(string)) {
                log.error((Object)String.valueOf(String.valueOf(string)).concat(" Subsystem is not available"));
                boolean bl2 = false;
                return bl2;
            }
            AllowedSubsystem allowedSubsystem = (AllowedSubsystem)allowedSubsystems.get(string);
            if (allowedSubsystem.getType().equals("class")) {
                Class<?> clazz = Class.forName(allowedSubsystem.getProvider());
                this.subsystemInstance = (SubsystemServer)clazz.newInstance();
                this.bindInputStream(this.subsystemInstance.getInputStream());
                this.bindOutputStream(this.subsystemInstance.getOutputStream());
                boolean bl3 = true;
                return bl3;
            }
            String string2 = allowedSubsystem.getProvider();
            File file = new File(string2);
            if (!file.exists() && !(file = new File(string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(ConfigurationLoader.getHomeDirectory()))).append("bin").append(File.separator).append(string2))))).exists()) {
                log.error((Object)"Failed to locate subsystem provider ".concat(String.valueOf(String.valueOf(allowedSubsystem.getProvider()))));
                boolean bl4 = false;
                return bl4;
            }
            boolean bl5 = this.onExecuteCommand(string2);
            return bl5;
        }
        catch (Exception exception) {
            log.error((Object)"Failed to start subsystem ".concat(String.valueOf(String.valueOf(string))), (Throwable)exception);
            return false;
        }
    }

    public byte[] getChannelOpenData() {
        return null;
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected int getMaximumWindowSpace() {
        return 32648;
    }

    protected int getMaximumPacketSize() {
        return 32648;
    }

    public String getChannelType() {
        return SESSION_CHANNEL_TYPE;
    }

    protected void onChannelRequest(String string, boolean bl, byte[] byArray) throws IOException {
        block32: {
            int n;
            int n2;
            String string2;
            Object object;
            log.debug((Object)"Channel Request received: ".concat(String.valueOf(String.valueOf(string))));
            boolean bl2 = false;
            if (string.equals("shell")) {
                bl2 = this.onStartShell();
                if (bl2) {
                    if (bl) {
                        this.connection.sendChannelRequestSuccess(this);
                    }
                    this.processInstance.start();
                    this.processMonitor = new ProcessMonitorThread(this.processInstance);
                } else if (bl) {
                    this.connection.sendChannelRequestFailure(this);
                }
            }
            if (string.equals("env")) {
                object = new ByteArrayReader(byArray);
                string2 = ((ByteArrayReader)object).readString();
                String string3 = ((ByteArrayReader)object).readString();
                this.onSetEnvironmentVariable(string2, string3);
                if (bl) {
                    this.connection.sendChannelRequestSuccess(this);
                }
            }
            if (string.equals("exec")) {
                object = new ByteArrayReader(byArray);
                string2 = ((ByteArrayReader)object).readString();
                bl2 = this.onExecuteCommand(string2);
                if (bl2) {
                    if (bl) {
                        this.connection.sendChannelRequestSuccess(this);
                    }
                    this.processInstance.start();
                    this.processMonitor = new ProcessMonitorThread(this.processInstance);
                } else if (bl) {
                    this.connection.sendChannelRequestFailure(this);
                }
            }
            if (string.equals("subsystem")) {
                object = new ByteArrayReader(byArray);
                string2 = ((ByteArrayReader)object).readString();
                bl2 = this.onStartSubsystem(string2);
                if (bl2) {
                    if (bl) {
                        this.connection.sendChannelRequestSuccess(this);
                    }
                    if (this.processInstance != null) {
                        this.processInstance.start();
                        this.processMonitor = new ProcessMonitorThread(this.processInstance);
                    } else if (this.subsystemInstance != null) {
                        this.subsystemInstance.start();
                        this.processMonitor = new ProcessMonitorThread(this.subsystemInstance);
                    }
                } else if (bl) {
                    this.connection.sendChannelRequestFailure(this);
                }
            }
            if (string.equals("pty-req")) {
                object = new ByteArrayReader(byArray);
                string2 = ((ByteArrayReader)object).readString();
                int n3 = (int)((ByteArrayReader)object).readInt();
                n2 = (int)((ByteArrayReader)object).readInt();
                n = (int)((ByteArrayReader)object).readInt();
                int n4 = (int)((ByteArrayReader)object).readInt();
                String string4 = ((ByteArrayReader)object).readString();
                bl2 = this.onRequestPseudoTerminal(string2, n3, n2, n, n4, string4);
                if (bl && bl2) {
                    this.connection.sendChannelRequestSuccess(this);
                } else if (bl) {
                    this.connection.sendChannelRequestFailure(this);
                }
            }
            if (string.equals("window-change")) {
                object = new ByteArrayReader(byArray);
                int n5 = (int)((ByteArrayReader)object).readInt();
                int n6 = (int)((ByteArrayReader)object).readInt();
                n2 = (int)((ByteArrayReader)object).readInt();
                n = (int)((ByteArrayReader)object).readInt();
                this.onChangeTerminalDimensions(n5, n6, n2, n);
                if (bl && bl2) {
                    this.connection.sendChannelRequestSuccess(this);
                } else if (bl) {
                    this.connection.sendChannelRequestFailure(this);
                }
            }
            if (string.equals("auth-agent-req")) {
                try {
                    object = SshThread.getCurrentThread();
                    this.agent = SshAgentForwardingListener.getInstance(((SshThread)object).getSessionIdString(), this.connection);
                    this.agent.addReference(this);
                    this.environment.put("SSH_AGENT_AUTH", this.agent.getConfiguration());
                    ((SshThread)object).setProperty("sshtools.agent", this.agent.getConfiguration());
                    if (bl) {
                        this.connection.sendChannelRequestSuccess(this);
                    }
                }
                catch (Exception exception) {
                    if (!bl) break block32;
                    this.connection.sendChannelRequestFailure(this);
                }
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ProcessMonitorThread
    extends Thread {
        private NativeProcessProvider process;
        private SubsystemServer subsystem;
        private StartStopState state;

        public ProcessMonitorThread(NativeProcessProvider nativeProcessProvider) {
            this.process = nativeProcessProvider;
            this.state = new StartStopState(1);
            this.start();
        }

        public ProcessMonitorThread(SubsystemServer subsystemServer) {
            this.state = subsystemServer.getState();
        }

        public StartStopState getState() {
            return this.state;
        }

        public void run() {
            try {
                log.info((Object)"Monitor waiting for process exit code");
                int n = this.process.waitForExitCode();
                if (n == 9999999) {
                    log.error((Object)"Process monitor failed to retrieve exit code");
                } else {
                    log.debug((Object)"Process exit code is ".concat(String.valueOf(String.valueOf(String.valueOf(n)))));
                    this.process.getInputStream().close();
                    this.process.getOutputStream().close();
                    this.process.getStderrInputStream().close();
                    ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
                    byteArrayWriter.writeInt(n);
                    SessionChannelServer.this.connection.sendChannelRequest(SessionChannelServer.this, "exit-status", false, byteArrayWriter.toByteArray());
                    this.state.setValue(2);
                    SessionChannelServer.this.close();
                }
            }
            catch (IOException iOException) {
                log.error((Object)"Failed to kill process", (Throwable)iOException);
            }
        }
    }
}

