/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpMessageStore;
import com.sshtools.j2ssh.sftp.SshFxpAttrs;
import com.sshtools.j2ssh.sftp.SshFxpClose;
import com.sshtools.j2ssh.sftp.SshFxpData;
import com.sshtools.j2ssh.sftp.SshFxpFSetStat;
import com.sshtools.j2ssh.sftp.SshFxpFStat;
import com.sshtools.j2ssh.sftp.SshFxpHandle;
import com.sshtools.j2ssh.sftp.SshFxpInit;
import com.sshtools.j2ssh.sftp.SshFxpMkdir;
import com.sshtools.j2ssh.sftp.SshFxpName;
import com.sshtools.j2ssh.sftp.SshFxpOpen;
import com.sshtools.j2ssh.sftp.SshFxpOpenDir;
import com.sshtools.j2ssh.sftp.SshFxpRead;
import com.sshtools.j2ssh.sftp.SshFxpReadDir;
import com.sshtools.j2ssh.sftp.SshFxpReadlink;
import com.sshtools.j2ssh.sftp.SshFxpRealPath;
import com.sshtools.j2ssh.sftp.SshFxpRemove;
import com.sshtools.j2ssh.sftp.SshFxpRename;
import com.sshtools.j2ssh.sftp.SshFxpRmdir;
import com.sshtools.j2ssh.sftp.SshFxpSetStat;
import com.sshtools.j2ssh.sftp.SshFxpStat;
import com.sshtools.j2ssh.sftp.SshFxpStatus;
import com.sshtools.j2ssh.sftp.SshFxpSymlink;
import com.sshtools.j2ssh.sftp.SshFxpVersion;
import com.sshtools.j2ssh.sftp.SshFxpWrite;
import com.sshtools.j2ssh.subsystem.SubsystemClient;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SftpSubsystemClient
extends SubsystemClient {
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int OPEN_APPEND = 4;
    public static final int OPEN_CREATE = 8;
    public static final int OPEN_TRUNCATE = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$sftp$SftpSubsystemClient == null ? (class$com$sshtools$j2ssh$sftp$SftpSubsystemClient = SftpSubsystemClient.class$("com.sshtools.j2ssh.sftp.SftpSubsystemClient")) : class$com$sshtools$j2ssh$sftp$SftpSubsystemClient));
    private List handles = new Vector();
    private UnsignedInteger32 nextRequestId = new UnsignedInteger32(1L);
    private int version = 3;
    private SftpMessageStore messageStore;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SftpSubsystemClient;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpAttrs;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpData;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpHandle;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpName;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpStatus;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpVersion;

    public SftpSubsystemClient() {
        super("sftp", new SftpMessageStore());
        this.messageStore = (SftpMessageStore)((SubsystemClient)this).messageStore;
        this.registerMessages();
    }

    public String getName() {
        return "sftp";
    }

    protected long availableWindowSpace() {
        return this.session.getRemoteWindow().getWindowSpace();
    }

    protected long maximumPacketSize() {
        return this.session.getRemotePacketSize();
    }

    protected void closeHandle(byte[] byArray) throws IOException {
        if (!this.isValidHandle(byArray)) {
            throw new IOException("The handle is invalid!");
        }
        this.handles.remove(byArray);
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpClose sshFxpClose = new SshFxpClose(unsignedInteger32, byArray);
        this.sendMessage(sshFxpClose);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public void closeFile(SftpFile sftpFile) throws IOException {
        this.closeHandle(sftpFile.getHandle());
    }

    protected boolean isValidHandle(byte[] byArray) {
        return this.handles.contains(byArray);
    }

    public int listChildren(SftpFile sftpFile, List list) throws IOException {
        if (sftpFile.isDirectory()) {
            if (!this.isValidHandle(sftpFile.getHandle()) && !this.isValidHandle((sftpFile = this.openDirectory(sftpFile.getAbsolutePath())).getHandle())) {
                throw new IOException("Failed to open directory");
            }
        } else {
            throw new IOException("Cannot list children for this file object");
        }
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpReadDir sshFxpReadDir = new SshFxpReadDir(unsignedInteger32, sftpFile.getHandle());
        this.sendMessage(sshFxpReadDir);
        SubsystemMessage subsystemMessage = this.messageStore.getMessage(unsignedInteger32);
        if (subsystemMessage instanceof SshFxpName) {
            SshFxpName sshFxpName = (SshFxpName)subsystemMessage;
            SftpFile[] sftpFileArray = sshFxpName.getFiles();
            for (int i = 0; i < sftpFileArray.length; ++i) {
                SftpFile sftpFile2 = new SftpFile(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(sftpFile.getAbsolutePath()))).append("/").append(sftpFileArray[i].getFilename()))), sftpFileArray[i].getAttributes());
                sftpFile2.setSFTPSubsystem(this);
                list.add(sftpFile2);
            }
            return sftpFileArray.length;
        }
        if (subsystemMessage instanceof SshFxpStatus) {
            SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
            if (sshFxpStatus.getErrorCode().intValue() == 1) {
                return -1;
            }
            throw new IOException(sshFxpStatus.getErrorMessage());
        }
        throw new IOException("Unexpected server response ".concat(String.valueOf(String.valueOf(subsystemMessage.getMessageName()))));
    }

    public void makeDirectory(String string) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpMkdir sshFxpMkdir = new SshFxpMkdir(unsignedInteger32, string, new FileAttributes());
        this.sendMessage(sshFxpMkdir);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public void recurseMakeDirectory(String string) throws IOException {
        if (string.trim().length() > 0) {
            try {
                SftpFile sftpFile = this.openDirectory(string);
                sftpFile.close();
            }
            catch (IOException iOException) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
                String string2 = "";
                while (stringTokenizer.hasMoreElements()) {
                    string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(stringTokenizer.nextElement())));
                    try {
                        SftpFile sftpFile = this.openDirectory(string2);
                        sftpFile.close();
                    }
                    catch (IOException iOException2) {
                        log.info((Object)"Creating ".concat(String.valueOf(String.valueOf(string2))));
                        this.makeDirectory(string2);
                    }
                }
            }
        }
    }

    protected boolean onStart() throws IOException {
        return this.initialize();
    }

    public SftpFile openDirectory(String string) throws IOException {
        String string2 = this.getAbsolutePath(string);
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SubsystemMessage subsystemMessage = new SshFxpOpenDir(unsignedInteger32, string2);
        this.sendMessage(subsystemMessage);
        byte[] byArray = this.getHandleResponse(unsignedInteger32);
        unsignedInteger32 = this.nextRequestId();
        subsystemMessage = new SshFxpStat(unsignedInteger32, string2);
        this.sendMessage(subsystemMessage);
        SubsystemMessage subsystemMessage2 = this.messageStore.getMessage(unsignedInteger32);
        if (subsystemMessage2 instanceof SshFxpAttrs) {
            SftpFile sftpFile = new SftpFile(string2, ((SshFxpAttrs)subsystemMessage2).getAttributes());
            sftpFile.setHandle(byArray);
            sftpFile.setSFTPSubsystem(this);
            return sftpFile;
        }
        if (subsystemMessage2 instanceof SshFxpStatus) {
            throw new IOException(((SshFxpStatus)subsystemMessage2).getErrorMessage());
        }
        throw new IOException("Unexpected server response ".concat(String.valueOf(String.valueOf(subsystemMessage2.getMessageName()))));
    }

    public String getDefaultDirectory() throws IOException {
        return this.getAbsolutePath("");
    }

    public String getAbsolutePath(String string) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpRealPath sshFxpRealPath = new SshFxpRealPath(unsignedInteger32, string);
        this.sendMessage(sshFxpRealPath);
        SubsystemMessage subsystemMessage = this.messageStore.getMessage(unsignedInteger32);
        if (subsystemMessage instanceof SshFxpName) {
            SftpFile[] sftpFileArray = ((SshFxpName)subsystemMessage).getFiles();
            if (sftpFileArray.length != 1) {
                throw new IOException("Server responded to SSH_FXP_REALPATH with too many files!");
            }
            return sftpFileArray[0].getAbsolutePath();
        }
        if (subsystemMessage instanceof SshFxpStatus) {
            throw new IOException(((SshFxpStatus)subsystemMessage).getErrorMessage());
        }
        throw new IOException("Unexpected server response ".concat(String.valueOf(String.valueOf(subsystemMessage.getMessageName()))));
    }

    public String getAbsolutePath(SftpFile sftpFile) throws IOException {
        return this.getAbsolutePath(sftpFile.getFilename());
    }

    public SftpFile openFile(String string, int n) throws IOException {
        return this.openFile(string, n, null);
    }

    public SftpFile openFile(String string, int n, FileAttributes fileAttributes) throws IOException {
        if (fileAttributes == null) {
            fileAttributes = new FileAttributes();
        }
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpOpen sshFxpOpen = new SshFxpOpen(unsignedInteger32, string, new UnsignedInteger32(n), fileAttributes);
        this.sendMessage(sshFxpOpen);
        byte[] byArray = this.getHandleResponse(unsignedInteger32);
        SftpFile sftpFile = new SftpFile(string, null);
        sftpFile.setHandle(byArray);
        sftpFile.setSFTPSubsystem(this);
        return sftpFile;
    }

    public FileAttributes getAttributes(String string) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpStat sshFxpStat = new SshFxpStat(unsignedInteger32, string);
        this.sendMessage(sshFxpStat);
        SubsystemMessage subsystemMessage = this.messageStore.getMessage(unsignedInteger32);
        if (subsystemMessage instanceof SshFxpAttrs) {
            return ((SshFxpAttrs)subsystemMessage).getAttributes();
        }
        if (subsystemMessage instanceof SshFxpStatus) {
            throw new IOException(((SshFxpStatus)subsystemMessage).getErrorMessage());
        }
        throw new IOException("Unexpected server response ".concat(String.valueOf(String.valueOf(subsystemMessage.getMessageName()))));
    }

    public FileAttributes getAttributes(SftpFile sftpFile) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SubsystemMessage subsystemMessage = !this.isValidHandle(sftpFile.getHandle()) ? new SshFxpStat(unsignedInteger32, sftpFile.getAbsolutePath()) : new SshFxpFStat(unsignedInteger32, sftpFile.getHandle());
        this.sendMessage(subsystemMessage);
        SubsystemMessage subsystemMessage2 = this.messageStore.getMessage(unsignedInteger32);
        if (subsystemMessage2 instanceof SshFxpAttrs) {
            return ((SshFxpAttrs)subsystemMessage2).getAttributes();
        }
        if (subsystemMessage2 instanceof SshFxpStatus) {
            throw new IOException(((SshFxpStatus)subsystemMessage2).getErrorMessage());
        }
        throw new IOException("Unexpected server response ".concat(String.valueOf(String.valueOf(subsystemMessage2.getMessageName()))));
    }

    protected int readFile(byte[] byArray, UnsignedInteger64 unsignedInteger64, byte[] byArray2, int n, int n2) throws IOException {
        if (!this.handles.contains(byArray)) {
            throw new IOException("The file handle is invalid!");
        }
        if (byArray2.length - n < n2) {
            throw new IOException("Output array size is smaller than read length!");
        }
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpRead sshFxpRead = new SshFxpRead(unsignedInteger32, byArray, unsignedInteger64, new UnsignedInteger32(n2));
        this.sendMessage(sshFxpRead);
        SubsystemMessage subsystemMessage = this.messageStore.getMessage(unsignedInteger32);
        if (subsystemMessage instanceof SshFxpData) {
            byte[] byArray3 = ((SshFxpData)subsystemMessage).getData();
            System.arraycopy(byArray3, 0, byArray2, n, byArray3.length);
            return byArray3.length;
        }
        if (subsystemMessage instanceof SshFxpStatus) {
            SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
            if (sshFxpStatus.getErrorCode().intValue() == 1) {
                return -1;
            }
            throw new IOException(((SshFxpStatus)subsystemMessage).getErrorMessage());
        }
        throw new IOException("Unexpected server response ".concat(String.valueOf(String.valueOf(subsystemMessage.getMessageName()))));
    }

    public void removeDirectory(String string) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpRmdir sshFxpRmdir = new SshFxpRmdir(unsignedInteger32, string);
        this.sendMessage(sshFxpRmdir);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public void removeFile(String string) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpRemove sshFxpRemove = new SshFxpRemove(unsignedInteger32, string);
        this.sendMessage(sshFxpRemove);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public void renameFile(String string, String string2) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpRename sshFxpRename = new SshFxpRename(unsignedInteger32, string, string2);
        this.sendMessage(sshFxpRename);
        this.getOKRequestStatus(unsignedInteger32);
    }

    protected void writeFile(byte[] byArray, UnsignedInteger64 unsignedInteger64, byte[] byArray2, int n, int n2) throws IOException {
        if (!this.handles.contains(byArray)) {
            throw new IOException("The handle is not valid!");
        }
        if (byArray2.length - n < n2) {
            throw new IOException("Incorrect data array size!");
        }
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpWrite sshFxpWrite = new SshFxpWrite(unsignedInteger32, byArray, unsignedInteger64, byArray2, n, n2);
        this.sendMessage(sshFxpWrite);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public void createSymbolicLink(String string, String string2) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpSymlink sshFxpSymlink = new SshFxpSymlink(unsignedInteger32, string, string2);
        this.sendMessage(sshFxpSymlink);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public String getSymbolicLinkTarget(String string) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpReadlink sshFxpReadlink = new SshFxpReadlink(unsignedInteger32, string);
        this.sendMessage(sshFxpReadlink);
        SubsystemMessage subsystemMessage = this.messageStore.getMessage(unsignedInteger32);
        if (subsystemMessage instanceof SshFxpName) {
            SftpFile[] sftpFileArray = ((SshFxpName)subsystemMessage).getFiles();
            if (sftpFileArray.length != 1) {
                throw new IOException("Server responded to SSH_FXP_REALLINK with too many files!");
            }
            return sftpFileArray[0].getAbsolutePath();
        }
        if (subsystemMessage instanceof SshFxpStatus) {
            throw new IOException(((SshFxpStatus)subsystemMessage).getErrorMessage());
        }
        throw new IOException("Unexpected server response ".concat(String.valueOf(String.valueOf(subsystemMessage.getMessageName()))));
    }

    public void setAttributes(String string, FileAttributes fileAttributes) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpSetStat sshFxpSetStat = new SshFxpSetStat(unsignedInteger32, string, fileAttributes);
        this.sendMessage(sshFxpSetStat);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public void setAttributes(SftpFile sftpFile, FileAttributes fileAttributes) throws IOException {
        if (!this.isValidHandle(sftpFile.getHandle())) {
            throw new IOException("The handle is not an open file handle!");
        }
        UnsignedInteger32 unsignedInteger32 = this.nextRequestId();
        SshFxpFSetStat sshFxpFSetStat = new SshFxpFSetStat(unsignedInteger32, sftpFile.getHandle(), fileAttributes);
        this.sendMessage(sshFxpFSetStat);
        this.getOKRequestStatus(unsignedInteger32);
    }

    public void changePermissions(SftpFile sftpFile, String string) throws IOException {
        FileAttributes fileAttributes = sftpFile.getAttributes();
        fileAttributes.setPermissions(string);
        this.setAttributes(sftpFile, fileAttributes);
    }

    public void changePermissions(SftpFile sftpFile, int n) throws IOException {
        FileAttributes fileAttributes = sftpFile.getAttributes();
        fileAttributes.setPermissions(new UnsignedInteger32(n));
        this.setAttributes(sftpFile, fileAttributes);
    }

    public void changePermissions(String string, int n) throws IOException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(new UnsignedInteger32(n));
        this.setAttributes(string, fileAttributes);
    }

    public void changePermissions(String string, String string2) throws IOException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(string2);
        this.setAttributes(string, fileAttributes);
    }

    protected boolean initialize() throws IOException {
        log.info((Object)"Initializing SFTP protocol version ".concat(String.valueOf(String.valueOf(String.valueOf(this.version)))));
        boolean bl = false;
        SshFxpInit sshFxpInit = new SshFxpInit(new UnsignedInteger32(this.version), null);
        this.sendMessage(sshFxpInit);
        SubsystemMessage subsystemMessage = null;
        for (int i = 0; i < 30; ++i) {
            try {
                subsystemMessage = this.messageStore.nextMessage(1000);
                break;
            }
            catch (MessageNotAvailableException messageNotAvailableException) {
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                boolean bl2 = false;
                return bl2;
            }
            if (this.session.getState().getValue() == 2) continue;
            return false;
        }
        if (subsystemMessage instanceof SshFxpVersion) {
            bl = true;
            this.version = ((SshFxpVersion)subsystemMessage).getVersion().intValue();
            log.info((Object)"Server responded with version ".concat(String.valueOf(String.valueOf(String.valueOf(this.version)))));
        }
        return bl;
    }

    private byte[] getHandleResponse(UnsignedInteger32 unsignedInteger32) throws IOException {
        SubsystemMessage subsystemMessage = this.messageStore.getMessage(unsignedInteger32);
        if (subsystemMessage instanceof SshFxpHandle) {
            byte[] byArray = ((SshFxpHandle)subsystemMessage).getHandle();
            this.handles.add(byArray);
            return byArray;
        }
        if (subsystemMessage instanceof SshFxpStatus) {
            throw new IOException(((SshFxpStatus)subsystemMessage).getErrorMessage());
        }
        throw new IOException("Unexpected server response ".concat(String.valueOf(String.valueOf(subsystemMessage.getMessageName()))));
    }

    private void getOKRequestStatus(UnsignedInteger32 unsignedInteger32) throws IOException {
        SubsystemMessage subsystemMessage = this.messageStore.getMessage(unsignedInteger32);
        if (subsystemMessage instanceof SshFxpStatus) {
            SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
            if (sshFxpStatus.getErrorCode().intValue() != 0) {
                throw new IOException(((SshFxpStatus)subsystemMessage).getErrorMessage());
            }
        } else {
            throw new IOException("Unexpected server response ".concat(String.valueOf(String.valueOf(subsystemMessage.getMessageName()))));
        }
    }

    private UnsignedInteger32 nextRequestId() {
        this.nextRequestId = UnsignedInteger32.add(this.nextRequestId, 1);
        return this.nextRequestId;
    }

    private void registerMessages() {
        this.messageStore.registerMessage(2, class$com$sshtools$j2ssh$sftp$SshFxpVersion == null ? (class$com$sshtools$j2ssh$sftp$SshFxpVersion = SftpSubsystemClient.class$("com.sshtools.j2ssh.sftp.SshFxpVersion")) : class$com$sshtools$j2ssh$sftp$SshFxpVersion);
        this.messageStore.registerMessage(105, class$com$sshtools$j2ssh$sftp$SshFxpAttrs == null ? (class$com$sshtools$j2ssh$sftp$SshFxpAttrs = SftpSubsystemClient.class$("com.sshtools.j2ssh.sftp.SshFxpAttrs")) : class$com$sshtools$j2ssh$sftp$SshFxpAttrs);
        this.messageStore.registerMessage(103, class$com$sshtools$j2ssh$sftp$SshFxpData == null ? (class$com$sshtools$j2ssh$sftp$SshFxpData = SftpSubsystemClient.class$("com.sshtools.j2ssh.sftp.SshFxpData")) : class$com$sshtools$j2ssh$sftp$SshFxpData);
        this.messageStore.registerMessage(102, class$com$sshtools$j2ssh$sftp$SshFxpHandle == null ? (class$com$sshtools$j2ssh$sftp$SshFxpHandle = SftpSubsystemClient.class$("com.sshtools.j2ssh.sftp.SshFxpHandle")) : class$com$sshtools$j2ssh$sftp$SshFxpHandle);
        this.messageStore.registerMessage(101, class$com$sshtools$j2ssh$sftp$SshFxpStatus == null ? (class$com$sshtools$j2ssh$sftp$SshFxpStatus = SftpSubsystemClient.class$("com.sshtools.j2ssh.sftp.SshFxpStatus")) : class$com$sshtools$j2ssh$sftp$SshFxpStatus);
        this.messageStore.registerMessage(104, class$com$sshtools$j2ssh$sftp$SshFxpName == null ? (class$com$sshtools$j2ssh$sftp$SshFxpName = SftpSubsystemClient.class$("com.sshtools.j2ssh.sftp.SshFxpName")) : class$com$sshtools$j2ssh$sftp$SshFxpName);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

