/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.platform.InvalidHandleException;
import com.sshtools.j2ssh.platform.NativeFileSystemProvider;
import com.sshtools.j2ssh.platform.PermissionDeniedException;
import com.sshtools.j2ssh.platform.UnsupportedFileOperationException;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SshFxpAttrs;
import com.sshtools.j2ssh.sftp.SshFxpClose;
import com.sshtools.j2ssh.sftp.SshFxpData;
import com.sshtools.j2ssh.sftp.SshFxpFSetStat;
import com.sshtools.j2ssh.sftp.SshFxpFStat;
import com.sshtools.j2ssh.sftp.SshFxpHandle;
import com.sshtools.j2ssh.sftp.SshFxpInit;
import com.sshtools.j2ssh.sftp.SshFxpLStat;
import com.sshtools.j2ssh.sftp.SshFxpMkdir;
import com.sshtools.j2ssh.sftp.SshFxpName;
import com.sshtools.j2ssh.sftp.SshFxpOpen;
import com.sshtools.j2ssh.sftp.SshFxpOpenDir;
import com.sshtools.j2ssh.sftp.SshFxpRead;
import com.sshtools.j2ssh.sftp.SshFxpReadDir;
import com.sshtools.j2ssh.sftp.SshFxpReadlink;
import com.sshtools.j2ssh.sftp.SshFxpRealPath;
import com.sshtools.j2ssh.sftp.SshFxpRemove;
import com.sshtools.j2ssh.sftp.SshFxpRename;
import com.sshtools.j2ssh.sftp.SshFxpRmdir;
import com.sshtools.j2ssh.sftp.SshFxpSetStat;
import com.sshtools.j2ssh.sftp.SshFxpStat;
import com.sshtools.j2ssh.sftp.SshFxpStatus;
import com.sshtools.j2ssh.sftp.SshFxpSymlink;
import com.sshtools.j2ssh.sftp.SshFxpVersion;
import com.sshtools.j2ssh.sftp.SshFxpWrite;
import com.sshtools.j2ssh.sftp.VirtualFileSystem;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.subsystem.SubsystemServer;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SftpSubsystemServer
extends SubsystemServer {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$sftp$SftpSubsystemServer == null ? (class$com$sshtools$j2ssh$sftp$SftpSubsystemServer = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SftpSubsystemServer")) : class$com$sshtools$j2ssh$sftp$SftpSubsystemServer));
    private NativeFileSystemProvider nfs;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SftpSubsystemServer;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpClose;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpFSetStat;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpFStat;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpInit;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpLStat;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpMkdir;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpOpen;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpOpenDir;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpRead;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpReadDir;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpReadlink;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpRealPath;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpRemove;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpRename;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpRmdir;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpSetStat;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpStat;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpSymlink;
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$SshFxpWrite;

    public SftpSubsystemServer() {
        this.registerMessage(1, class$com$sshtools$j2ssh$sftp$SshFxpInit == null ? (class$com$sshtools$j2ssh$sftp$SshFxpInit = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpInit")) : class$com$sshtools$j2ssh$sftp$SshFxpInit);
        this.registerMessage(14, class$com$sshtools$j2ssh$sftp$SshFxpMkdir == null ? (class$com$sshtools$j2ssh$sftp$SshFxpMkdir = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpMkdir")) : class$com$sshtools$j2ssh$sftp$SshFxpMkdir);
        this.registerMessage(16, class$com$sshtools$j2ssh$sftp$SshFxpRealPath == null ? (class$com$sshtools$j2ssh$sftp$SshFxpRealPath = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpRealPath")) : class$com$sshtools$j2ssh$sftp$SshFxpRealPath);
        this.registerMessage(11, class$com$sshtools$j2ssh$sftp$SshFxpOpenDir == null ? (class$com$sshtools$j2ssh$sftp$SshFxpOpenDir = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpOpenDir")) : class$com$sshtools$j2ssh$sftp$SshFxpOpenDir);
        this.registerMessage(3, class$com$sshtools$j2ssh$sftp$SshFxpOpen == null ? (class$com$sshtools$j2ssh$sftp$SshFxpOpen = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpOpen")) : class$com$sshtools$j2ssh$sftp$SshFxpOpen);
        this.registerMessage(5, class$com$sshtools$j2ssh$sftp$SshFxpRead == null ? (class$com$sshtools$j2ssh$sftp$SshFxpRead = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpRead")) : class$com$sshtools$j2ssh$sftp$SshFxpRead);
        this.registerMessage(6, class$com$sshtools$j2ssh$sftp$SshFxpWrite == null ? (class$com$sshtools$j2ssh$sftp$SshFxpWrite = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpWrite")) : class$com$sshtools$j2ssh$sftp$SshFxpWrite);
        this.registerMessage(12, class$com$sshtools$j2ssh$sftp$SshFxpReadDir == null ? (class$com$sshtools$j2ssh$sftp$SshFxpReadDir = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpReadDir")) : class$com$sshtools$j2ssh$sftp$SshFxpReadDir);
        this.registerMessage(4, class$com$sshtools$j2ssh$sftp$SshFxpClose == null ? (class$com$sshtools$j2ssh$sftp$SshFxpClose = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpClose")) : class$com$sshtools$j2ssh$sftp$SshFxpClose);
        this.registerMessage(7, class$com$sshtools$j2ssh$sftp$SshFxpLStat == null ? (class$com$sshtools$j2ssh$sftp$SshFxpLStat = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpLStat")) : class$com$sshtools$j2ssh$sftp$SshFxpLStat);
        this.registerMessage(17, class$com$sshtools$j2ssh$sftp$SshFxpStat == null ? (class$com$sshtools$j2ssh$sftp$SshFxpStat = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpStat")) : class$com$sshtools$j2ssh$sftp$SshFxpStat);
        this.registerMessage(13, class$com$sshtools$j2ssh$sftp$SshFxpRemove == null ? (class$com$sshtools$j2ssh$sftp$SshFxpRemove = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpRemove")) : class$com$sshtools$j2ssh$sftp$SshFxpRemove);
        this.registerMessage(18, class$com$sshtools$j2ssh$sftp$SshFxpRename == null ? (class$com$sshtools$j2ssh$sftp$SshFxpRename = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpRename")) : class$com$sshtools$j2ssh$sftp$SshFxpRename);
        this.registerMessage(15, class$com$sshtools$j2ssh$sftp$SshFxpRmdir == null ? (class$com$sshtools$j2ssh$sftp$SshFxpRmdir = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpRmdir")) : class$com$sshtools$j2ssh$sftp$SshFxpRmdir);
        this.registerMessage(9, class$com$sshtools$j2ssh$sftp$SshFxpSetStat == null ? (class$com$sshtools$j2ssh$sftp$SshFxpSetStat = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpSetStat")) : class$com$sshtools$j2ssh$sftp$SshFxpSetStat);
        this.registerMessage(8, class$com$sshtools$j2ssh$sftp$SshFxpFStat == null ? (class$com$sshtools$j2ssh$sftp$SshFxpFStat = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpFStat")) : class$com$sshtools$j2ssh$sftp$SshFxpFStat);
        this.registerMessage(10, class$com$sshtools$j2ssh$sftp$SshFxpFSetStat == null ? (class$com$sshtools$j2ssh$sftp$SshFxpFSetStat = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpFSetStat")) : class$com$sshtools$j2ssh$sftp$SshFxpFSetStat);
        this.registerMessage(19, class$com$sshtools$j2ssh$sftp$SshFxpReadlink == null ? (class$com$sshtools$j2ssh$sftp$SshFxpReadlink = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpReadlink")) : class$com$sshtools$j2ssh$sftp$SshFxpReadlink);
        this.registerMessage(20, class$com$sshtools$j2ssh$sftp$SshFxpSymlink == null ? (class$com$sshtools$j2ssh$sftp$SshFxpSymlink = SftpSubsystemServer.class$("com.sshtools.j2ssh.sftp.SshFxpSymlink")) : class$com$sshtools$j2ssh$sftp$SshFxpSymlink);
    }

    protected void onMessageReceived(SubsystemMessage subsystemMessage) {
        switch (subsystemMessage.getMessageType()) {
            case 1: {
                this.onInitialize((SshFxpInit)subsystemMessage);
                break;
            }
            case 14: {
                this.onMakeDirectory((SshFxpMkdir)subsystemMessage);
                break;
            }
            case 16: {
                this.onRealPath((SshFxpRealPath)subsystemMessage);
                break;
            }
            case 11: {
                this.onOpenDirectory((SshFxpOpenDir)subsystemMessage);
                break;
            }
            case 3: {
                this.onOpenFile((SshFxpOpen)subsystemMessage);
                break;
            }
            case 5: {
                this.onReadFile((SshFxpRead)subsystemMessage);
                break;
            }
            case 6: {
                this.onWriteFile((SshFxpWrite)subsystemMessage);
                break;
            }
            case 12: {
                this.onReadDirectory((SshFxpReadDir)subsystemMessage);
                break;
            }
            case 7: {
                this.onLStat((SshFxpLStat)subsystemMessage);
                break;
            }
            case 17: {
                this.onStat((SshFxpStat)subsystemMessage);
                break;
            }
            case 8: {
                this.onFStat((SshFxpFStat)subsystemMessage);
                break;
            }
            case 4: {
                this.onCloseFile((SshFxpClose)subsystemMessage);
                break;
            }
            case 13: {
                this.onRemoveFile((SshFxpRemove)subsystemMessage);
                break;
            }
            case 18: {
                this.onRenameFile((SshFxpRename)subsystemMessage);
                break;
            }
            case 15: {
                this.onRemoveDirectory((SshFxpRmdir)subsystemMessage);
                break;
            }
            case 9: {
                this.onSetAttributes((SshFxpSetStat)subsystemMessage);
                break;
            }
            case 10: {
                this.onSetAttributes((SshFxpFSetStat)subsystemMessage);
                break;
            }
            case 19: {
                this.onReadlink((SshFxpReadlink)subsystemMessage);
                break;
            }
            case 20: {
                this.onSymlink((SshFxpSymlink)subsystemMessage);
                break;
            }
        }
    }

    private void onSetAttributes(SshFxpSetStat sshFxpSetStat) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.setFileAttributes(VirtualFileSystem.translateVFSPath(sshFxpSetStat.getPath()), sshFxpSetStat.getAttributes());
            sshFxpStatus = new SshFxpStatus(sshFxpSetStat.getId(), new UnsignedInteger32(0L), "The attributes were set", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSetStat.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSetStat.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSetStat.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage(sshFxpStatus);
    }

    private void onSetAttributes(SshFxpFSetStat sshFxpFSetStat) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.setFileAttributes(sshFxpFSetStat.getHandle(), sshFxpFSetStat.getAttributes());
            sshFxpStatus = new SshFxpStatus(sshFxpFSetStat.getId(), new UnsignedInteger32(0L), "The attributes were set", "");
        }
        catch (InvalidHandleException invalidHandleException) {
            sshFxpStatus = new SshFxpStatus(sshFxpFSetStat.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpFSetStat.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpFSetStat.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage(sshFxpStatus);
    }

    private void onReadlink(SshFxpReadlink sshFxpReadlink) {
        SubsystemMessage subsystemMessage;
        try {
            File file = this.nfs.readSymbolicLink(VirtualFileSystem.translateVFSPath(sshFxpReadlink.getPath()));
            SftpFile[] sftpFileArray = new SftpFile[]{new SftpFile(VirtualFileSystem.translateNFSPath(file.getCanonicalPath()), this.nfs.getFileAttributes(file.getCanonicalPath()))};
            subsystemMessage = new SshFxpName(sshFxpReadlink.getId(), sftpFileArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            subsystemMessage = new SshFxpStatus(sshFxpReadlink.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            subsystemMessage = new SshFxpStatus(sshFxpReadlink.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        catch (UnsupportedFileOperationException unsupportedFileOperationException) {
            subsystemMessage = new SshFxpStatus(sshFxpReadlink.getId(), new UnsignedInteger32(8L), unsupportedFileOperationException.getMessage(), "");
        }
        catch (IOException iOException) {
            subsystemMessage = new SshFxpStatus(sshFxpReadlink.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage(subsystemMessage);
    }

    private void onSymlink(SshFxpSymlink sshFxpSymlink) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.createSymbolicLink(VirtualFileSystem.translateVFSPath(sshFxpSymlink.getLinkPath()), VirtualFileSystem.translateVFSPath(sshFxpSymlink.getTargetPath()));
            sshFxpStatus = new SshFxpStatus(sshFxpSymlink.getId(), new UnsignedInteger32(0L), "The symbolic link was created", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSymlink.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSymlink.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSymlink.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (UnsupportedFileOperationException unsupportedFileOperationException) {
            sshFxpStatus = new SshFxpStatus(sshFxpSymlink.getId(), new UnsignedInteger32(8L), unsupportedFileOperationException.getMessage(), "");
        }
        this.sendMessage(sshFxpStatus);
    }

    private void onRemoveDirectory(SshFxpRmdir sshFxpRmdir) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.removeDirectory(VirtualFileSystem.translateVFSPath(sshFxpRmdir.getPath()));
            sshFxpStatus = new SshFxpStatus(sshFxpRmdir.getId(), new UnsignedInteger32(0L), "The directory was removed", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRmdir.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRmdir.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRmdir.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        this.sendMessage(sshFxpStatus);
    }

    private void onRenameFile(SshFxpRename sshFxpRename) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.renameFile(VirtualFileSystem.translateVFSPath(sshFxpRename.getOldPath()), VirtualFileSystem.translateVFSPath(sshFxpRename.getNewPath()));
            sshFxpStatus = new SshFxpStatus(sshFxpRename.getId(), new UnsignedInteger32(0L), "The file was removed", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRename.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRename.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRename.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        this.sendMessage(sshFxpStatus);
    }

    private void onRemoveFile(SshFxpRemove sshFxpRemove) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.removeFile(VirtualFileSystem.translateVFSPath(sshFxpRemove.getFilename()));
            sshFxpStatus = new SshFxpStatus(sshFxpRemove.getId(), new UnsignedInteger32(0L), "The file was removed", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRemove.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRemove.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpRemove.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        this.sendMessage(sshFxpStatus);
    }

    private void onOpenFile(SshFxpOpen sshFxpOpen) {
        SubsystemMessage subsystemMessage;
        try {
            subsystemMessage = new SshFxpHandle(sshFxpOpen.getId(), this.nfs.openFile(VirtualFileSystem.translateVFSPath(sshFxpOpen.getFilename()), sshFxpOpen.getPflags(), sshFxpOpen.getAttributes()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            subsystemMessage = new SshFxpStatus(sshFxpOpen.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            subsystemMessage = new SshFxpStatus(sshFxpOpen.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            subsystemMessage = new SshFxpStatus(sshFxpOpen.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        this.sendMessage(subsystemMessage);
    }

    private void onReadFile(SshFxpRead sshFxpRead) {
        SubsystemMessage subsystemMessage;
        try {
            subsystemMessage = new SshFxpData(sshFxpRead.getId(), this.nfs.readFile(sshFxpRead.getHandle(), sshFxpRead.getOffset(), sshFxpRead.getLength()));
        }
        catch (EOFException eOFException) {
            subsystemMessage = new SshFxpStatus(sshFxpRead.getId(), new UnsignedInteger32(1L), eOFException.getMessage(), "");
        }
        catch (InvalidHandleException invalidHandleException) {
            subsystemMessage = new SshFxpStatus(sshFxpRead.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (IOException iOException) {
            subsystemMessage = new SshFxpStatus(sshFxpRead.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage(subsystemMessage);
    }

    private void onWriteFile(SshFxpWrite sshFxpWrite) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.writeFile(sshFxpWrite.getHandle(), sshFxpWrite.getOffset(), sshFxpWrite.getData(), 0, sshFxpWrite.getData().length);
            sshFxpStatus = new SshFxpStatus(sshFxpWrite.getId(), new UnsignedInteger32(0L), "The write completed successfully", "");
        }
        catch (InvalidHandleException invalidHandleException) {
            sshFxpStatus = new SshFxpStatus(sshFxpWrite.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpWrite.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage(sshFxpStatus);
    }

    private void onCloseFile(SshFxpClose sshFxpClose) {
        SshFxpStatus sshFxpStatus;
        try {
            this.nfs.closeFile(sshFxpClose.getHandle());
            sshFxpStatus = new SshFxpStatus(sshFxpClose.getId(), new UnsignedInteger32(0L), "The operation completed", "");
        }
        catch (InvalidHandleException invalidHandleException) {
            sshFxpStatus = new SshFxpStatus(sshFxpClose.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpClose.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage(sshFxpStatus);
    }

    private void onFStat(SshFxpFStat sshFxpFStat) {
        SubsystemMessage subsystemMessage;
        try {
            SftpFile[] sftpFileArray = new SftpFile[1];
            subsystemMessage = new SshFxpAttrs(sshFxpFStat.getId(), this.nfs.getFileAttributes(sshFxpFStat.getHandle()));
        }
        catch (InvalidHandleException invalidHandleException) {
            subsystemMessage = new SshFxpStatus(sshFxpFStat.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (IOException iOException) {
            subsystemMessage = new SshFxpStatus(sshFxpFStat.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage(subsystemMessage);
    }

    private void onStat(SshFxpStat sshFxpStat) {
        SubsystemMessage subsystemMessage;
        try {
            File file = new File(VirtualFileSystem.translateVFSPath(sshFxpStat.getPath()));
            if (file.exists()) {
                SftpFile[] sftpFileArray = new SftpFile[1];
                subsystemMessage = new SshFxpAttrs(sshFxpStat.getId(), this.nfs.getFileAttributes(file.getCanonicalPath()));
            } else {
                subsystemMessage = new SshFxpStatus(sshFxpStat.getId(), new UnsignedInteger32(2L), String.valueOf(String.valueOf(sshFxpStat.getPath())).concat(" is not a valid file path"), "");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            subsystemMessage = new SshFxpStatus(sshFxpStat.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            subsystemMessage = new SshFxpStatus(sshFxpStat.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage(subsystemMessage);
    }

    private void onLStat(SshFxpLStat sshFxpLStat) {
        SubsystemMessage subsystemMessage;
        try {
            File file = new File(VirtualFileSystem.translateVFSPath(sshFxpLStat.getPath()));
            if (file.exists()) {
                SftpFile[] sftpFileArray = new SftpFile[1];
                subsystemMessage = new SshFxpAttrs(sshFxpLStat.getId(), this.nfs.getFileAttributes(file.getCanonicalPath()));
            } else {
                subsystemMessage = new SshFxpStatus(sshFxpLStat.getId(), new UnsignedInteger32(2L), String.valueOf(String.valueOf(sshFxpLStat.getPath())).concat(" is not a valid file path"), "");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            subsystemMessage = new SshFxpStatus(sshFxpLStat.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            subsystemMessage = new SshFxpStatus(sshFxpLStat.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage(subsystemMessage);
    }

    private void onReadDirectory(SshFxpReadDir sshFxpReadDir) {
        SubsystemMessage subsystemMessage;
        try {
            File[] fileArray = this.nfs.readDirectory(sshFxpReadDir.getHandle());
            SftpFile[] sftpFileArray = new SftpFile[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                sftpFileArray[i] = new SftpFile(fileArray[i].getName(), this.nfs.getFileAttributes(fileArray[i].getCanonicalPath()));
            }
            subsystemMessage = new SshFxpName(sshFxpReadDir.getId(), sftpFileArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            subsystemMessage = new SshFxpStatus(sshFxpReadDir.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (InvalidHandleException invalidHandleException) {
            subsystemMessage = new SshFxpStatus(sshFxpReadDir.getId(), new UnsignedInteger32(4L), invalidHandleException.getMessage(), "");
        }
        catch (EOFException eOFException) {
            subsystemMessage = new SshFxpStatus(sshFxpReadDir.getId(), new UnsignedInteger32(1L), eOFException.getMessage(), "");
        }
        catch (IOException iOException) {
            subsystemMessage = new SshFxpStatus(sshFxpReadDir.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage(subsystemMessage);
    }

    private void onOpenDirectory(SshFxpOpenDir sshFxpOpenDir) {
        SubsystemMessage subsystemMessage;
        try {
            String string = VirtualFileSystem.translateVFSPath(sshFxpOpenDir.getPath());
            subsystemMessage = new SshFxpHandle(sshFxpOpenDir.getId(), this.nfs.openDirectory(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            subsystemMessage = new SshFxpStatus(sshFxpOpenDir.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (IOException iOException) {
            subsystemMessage = new SshFxpStatus(sshFxpOpenDir.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            subsystemMessage = new SshFxpStatus(sshFxpOpenDir.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        this.sendMessage(subsystemMessage);
    }

    private void onRealPath(SshFxpRealPath sshFxpRealPath) {
        SubsystemMessage subsystemMessage;
        try {
            String string = VirtualFileSystem.translateVFSPath(sshFxpRealPath.getPath());
            string = VirtualFileSystem.translateNFSPath(string);
            if (string != null) {
                SftpFile[] sftpFileArray = new SftpFile[]{new SftpFile(string)};
                subsystemMessage = new SshFxpName(sshFxpRealPath.getId(), sftpFileArray);
            } else {
                subsystemMessage = new SshFxpStatus(sshFxpRealPath.getId(), new UnsignedInteger32(4L), String.valueOf(String.valueOf(sshFxpRealPath.getPath())).concat(" could not be translated into a system dependent path"), "");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            subsystemMessage = new SshFxpStatus(sshFxpRealPath.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        this.sendMessage(subsystemMessage);
    }

    private void onMakeDirectory(SshFxpMkdir sshFxpMkdir) {
        SshFxpStatus sshFxpStatus;
        try {
            String string = VirtualFileSystem.translateVFSPath(sshFxpMkdir.getPath());
            sshFxpStatus = this.nfs.makeDirectory(string) ? new SshFxpStatus(sshFxpMkdir.getId(), new UnsignedInteger32(0L), "The operation completed sucessfully", "") : new SshFxpStatus(sshFxpMkdir.getId(), new UnsignedInteger32(4L), "The operation failed", "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            sshFxpStatus = new SshFxpStatus(sshFxpMkdir.getId(), new UnsignedInteger32(2L), fileNotFoundException.getMessage(), "");
        }
        catch (PermissionDeniedException permissionDeniedException) {
            sshFxpStatus = new SshFxpStatus(sshFxpMkdir.getId(), new UnsignedInteger32(3L), permissionDeniedException.getMessage(), "");
        }
        catch (IOException iOException) {
            sshFxpStatus = new SshFxpStatus(sshFxpMkdir.getId(), new UnsignedInteger32(4L), iOException.getMessage(), "");
        }
        this.sendMessage(sshFxpStatus);
    }

    private void onInitialize(SshFxpInit sshFxpInit) {
        block0: {
            this.nfs = NativeFileSystemProvider.getInstance();
            if (sshFxpInit.getVersion().intValue() != 3) break block0;
            SshFxpVersion sshFxpVersion = new SshFxpVersion(new UnsignedInteger32(3L), null);
            this.sendMessage(sshFxpVersion);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

