/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.MessageRequestId;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

public class SshFxpWrite
extends SubsystemMessage
implements MessageRequestId {
    public static final int SSH_FXP_WRITE = 6;
    private UnsignedInteger32 id;
    private byte[] handle;
    private UnsignedInteger64 offset;
    private byte[] data;

    public SshFxpWrite() {
        super(6);
    }

    public SshFxpWrite(UnsignedInteger32 unsignedInteger32, byte[] byArray, UnsignedInteger64 unsignedInteger64, byte[] byArray2, int n, int n2) {
        super(6);
        this.id = unsignedInteger32;
        this.handle = byArray;
        this.offset = unsignedInteger64;
        this.data = new byte[n2];
        System.arraycopy(byArray2, n, this.data, 0, n2);
    }

    public UnsignedInteger32 getId() {
        return this.id;
    }

    public byte[] getHandle() {
        return this.handle;
    }

    public UnsignedInteger64 getOffset() {
        return this.offset;
    }

    public byte[] getData() {
        return this.data;
    }

    public void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException, IOException {
        this.id = byteArrayReader.readUINT32();
        this.handle = byteArrayReader.readBinaryString();
        this.offset = byteArrayReader.readUINT64();
        this.data = byteArrayReader.readBinaryString();
    }

    public String getMessageName() {
        return "SSH_FXP_WRITE";
    }

    public void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException, IOException {
        byteArrayWriter.writeUINT32(this.id);
        byteArrayWriter.writeBinaryString(this.handle);
        byteArrayWriter.writeUINT64(this.offset);
        byteArrayWriter.writeBinaryString(this.data);
    }
}

