/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.VFSMount;
import com.sshtools.j2ssh.configuration.VFSPermission;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.platform.InvalidHandleException;
import com.sshtools.j2ssh.platform.NativeAuthenticationProvider;
import com.sshtools.j2ssh.platform.NativeFileSystemProvider;
import com.sshtools.j2ssh.platform.PermissionDeniedException;
import com.sshtools.j2ssh.platform.UnsupportedFileOperationException;
import com.sshtools.j2ssh.sftp.FileAttributes;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class VirtualFileSystem
extends NativeFileSystemProvider {
    private static String USER_HOME = "/home/";
    private static Map vfsmounts;
    private static VFSMount vfsroot;
    private static Logger log;
    private Map openFiles = new HashMap();
    static /* synthetic */ Class class$com$sshtools$j2ssh$sftp$VirtualFileSystem;

    public VirtualFileSystem() throws IOException {
        if (!ConfigurationLoader.isPlatformConfigured()) {
            throw new IOException("No valid platform configuration available");
        }
    }

    private static String getVFSHomeDirectory() throws FileNotFoundException {
        return String.valueOf(String.valueOf(USER_HOME)).concat(String.valueOf(String.valueOf(SshThread.getCurrentThreadUser())));
    }

    private static String getNFSHomeDirectory() throws FileNotFoundException {
        NativeAuthenticationProvider nativeAuthenticationProvider = NativeAuthenticationProvider.getInstance();
        try {
            String string = nativeAuthenticationProvider.getHomeDirectory(SshThread.getCurrentThreadUser());
            return string;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
    }

    public static String translateNFSPath(String string) throws FileNotFoundException {
        String string2;
        string = string.replace('\\', '/');
        String string3 = VirtualFileSystem.getNFSHomeDirectory().replace('\\', '/');
        String string4 = VirtualFileSystem.getVFSHomeDirectory();
        if (string.startsWith(string3)) {
            string = VirtualFileSystem.translateCanonicalPath(string, string3);
            return string.replaceFirst(string3, string4);
        }
        Iterator iterator = vfsmounts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string5 = (String)entry.getKey();
            VFSMount vFSMount = (VFSMount)entry.getValue();
            string2 = vFSMount.getPath();
            if (!string.startsWith(string2)) continue;
            string = VirtualFileSystem.translateCanonicalPath(string, string2);
            return string.replaceFirst(string2, string5);
        }
        if (string.startsWith(vfsroot.getPath())) {
            string2 = (string = VirtualFileSystem.translateCanonicalPath(string, vfsroot.getPath())).replaceFirst(vfsroot.getPath(), "");
            return string2.startsWith("/") ? string2 : "/".concat(String.valueOf(String.valueOf(string2)));
        }
        throw new FileNotFoundException("The file could not be found");
    }

    private static VFSMount getMount(String string) throws IOException, FileNotFoundException {
        String string2 = VirtualFileSystem.getVFSHomeDirectory();
        if (string.startsWith("/")) {
            if (string.startsWith(string2)) {
                VFSMount vFSMount = new VFSMount(string2, VirtualFileSystem.getNFSHomeDirectory());
                vFSMount.setPermissions(new VFSPermission(SshThread.getCurrentThreadUser(), "rwx"));
                return vFSMount;
            }
            Iterator iterator = vfsmounts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                if (!string.startsWith(string3)) continue;
                return (VFSMount)entry.getValue();
            }
            if (vfsroot != null) {
                return vfsroot;
            }
            throw new FileNotFoundException("The path was not found");
        }
        VFSMount vFSMount = new VFSMount(string2, VirtualFileSystem.getNFSHomeDirectory());
        vFSMount.setPermissions(new VFSPermission(string2.substring(string2.lastIndexOf("/")), "rwx"));
        return vFSMount;
    }

    public static String translateVFSPath(String string) throws FileNotFoundException {
        string = string.replace('\\', '/').trim();
        String string2 = VirtualFileSystem.getNFSHomeDirectory().replace('\\', '/');
        String string3 = VirtualFileSystem.getVFSHomeDirectory();
        if (string.startsWith("/")) {
            String string4;
            if (string.startsWith(string3)) {
                if (string.length() > string3.length()) {
                    return VirtualFileSystem.translateCanonicalPath(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(string2.endsWith("/") ? "" : "/").append(string.substring(string3.length())))), string2);
                }
                return VirtualFileSystem.translateCanonicalPath(string2, string2);
            }
            Iterator iterator = vfsmounts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string5 = (String)entry.getKey();
                VFSMount vFSMount = (VFSMount)entry.getValue();
                string4 = vFSMount.getPath();
                if (!string.startsWith(string5)) continue;
                String string6 = String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf(string.substring(string5.length()))));
                return VirtualFileSystem.translateCanonicalPath(string6, string4);
            }
            if (vfsroot != null) {
                string4 = String.valueOf(String.valueOf(vfsroot.getPath())).concat(String.valueOf(String.valueOf(vfsroot.getPath().endsWith("/") ? string.substring(1) : string)));
                return VirtualFileSystem.translateCanonicalPath(string4, vfsroot.getPath());
            }
            throw new FileNotFoundException("The file could not be found");
        }
        String string7 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(string2.endsWith("/") ? "" : "/").append(string)));
        return VirtualFileSystem.translateCanonicalPath(string7, string2);
    }

    public static String translateCanonicalPath(String string, String string2) throws FileNotFoundException {
        try {
            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Translating path ").append(string).append(" against secure mount ").append(string2))));
            File file = new File(string);
            String string3 = file.getCanonicalPath().replace('\\', '/');
            File file2 = new File(string2);
            String string4 = file2.getCanonicalPath().replace('\\', '/');
            if (string3.startsWith(string4)) {
                String string5 = string3;
                return string5;
            }
            throw new FileNotFoundException("The path could not be found");
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("The path could not be found");
        }
    }

    public boolean makeDirectory(String string) throws IOException, FileNotFoundException, PermissionDeniedException {
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string, "rw");
        File file = new File(string);
        return file.mkdir();
    }

    public VFSPermission getVFSPermission(String string) throws IOException, FileNotFoundException {
        VFSMount vFSMount = VirtualFileSystem.getMount(VirtualFileSystem.translateNFSPath(string));
        if (vFSMount.getPermissions().containsKey(SshThread.getCurrentThreadUser())) {
            return (VFSPermission)vFSMount.getPermissions().get(SshThread.getCurrentThreadUser());
        }
        return (VFSPermission)vFSMount.getPermissions().get("default");
    }

    public FileAttributes getFileAttributes(byte[] byArray) throws InvalidHandleException, IOException {
        String string = new String(byArray);
        if (this.openFiles.containsKey(string)) {
            File file;
            Object v = this.openFiles.get(string);
            if (v instanceof OpenFile) {
                file = ((OpenFile)v).getFile();
            } else if (v instanceof OpenDirectory) {
                file = ((OpenDirectory)v).getFile();
            } else {
                throw new IOException("Unexpected open file handle");
            }
            VFSPermission vFSPermission = this.getVFSPermission(file.getAbsolutePath());
            if (vFSPermission == null) {
                throw new IOException("No default permissions set");
            }
            FileAttributes fileAttributes = new FileAttributes();
            fileAttributes.setSize(new UnsignedInteger64(String.valueOf(file.length())));
            fileAttributes.setTimes(new UnsignedInteger32(file.lastModified() / (long)1000), new UnsignedInteger32(file.lastModified() / (long)1000));
            boolean bl = true;
            try {
                if (System.getSecurityManager() != null) {
                    System.getSecurityManager().checkExec(file.getCanonicalPath());
                }
            }
            catch (SecurityException securityException) {
                bl = false;
            }
            fileAttributes.setPermissions(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(file.canRead() && vFSPermission.canRead() ? "r" : "-"))).append(file.canWrite() && vFSPermission.canWrite() ? "w" : "-").append(bl && vFSPermission.canExecute() ? "x" : "-"))));
            fileAttributes.setPermissions(new UnsignedInteger32(fileAttributes.getPermissions().longValue() | (long)(file.isDirectory() ? 16384 : 32768)));
            return fileAttributes;
        }
        throw new InvalidHandleException("The handle is invalid");
    }

    public FileAttributes getFileAttributes(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        VFSPermission vFSPermission = this.getVFSPermission(string);
        if (vFSPermission == null) {
            throw new IOException("No default permissions set");
        }
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setSize(new UnsignedInteger64(String.valueOf(file.length())));
        fileAttributes.setTimes(new UnsignedInteger32(file.lastModified() / (long)1000), new UnsignedInteger32(file.lastModified() / (long)1000));
        boolean bl = true;
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkExec(file.getCanonicalPath());
            }
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        fileAttributes.setPermissions(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(file.canRead() && vFSPermission.canRead() ? "r" : "-"))).append(file.canWrite() && vFSPermission.canWrite() ? "w" : "-").append(bl && vFSPermission.canExecute() ? "x" : "-"))));
        fileAttributes.setPermissions(new UnsignedInteger32(fileAttributes.getPermissions().longValue() | (long)(file.isDirectory() ? 16384 : 32768)));
        return fileAttributes;
    }

    public byte[] openDirectory(String string) throws IOException, FileNotFoundException, PermissionDeniedException {
        File file = new File(string);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string, "r");
        if (file.exists()) {
            if (file.isDirectory()) {
                this.openFiles.put(file.toString(), new OpenDirectory(this, file));
                return file.toString().getBytes();
            }
            throw new IOException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string))).concat(" is not a directory"));
        }
        throw new FileNotFoundException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string))).concat(" does not exist"));
    }

    public File[] readDirectory(byte[] byArray) throws EOFException, InvalidHandleException {
        String string = new String(byArray);
        if (this.openFiles.containsKey(string)) {
            Object v = this.openFiles.get(string);
            if (v instanceof OpenDirectory) {
                int n;
                OpenDirectory openDirectory = (OpenDirectory)v;
                int n2 = openDirectory.getPosition();
                File[] fileArray = openDirectory.getChildren();
                int n3 = n = fileArray.length - n2 < 100 ? fileArray.length - n2 : 100;
                if (n > 0) {
                    File[] fileArray2 = new File[n];
                    System.arraycopy(fileArray, n2, fileArray2, 0, fileArray2.length);
                    openDirectory.setPosition(n2 + fileArray2.length);
                    return fileArray2;
                }
                throw new EOFException("There are no more files");
            }
            throw new InvalidHandleException("Handle is not an open directory");
        }
        throw new InvalidHandleException("The handle is invalid");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] openFile(String string, UnsignedInteger32 unsignedInteger32, FileAttributes fileAttributes) throws IOException, FileNotFoundException, PermissionDeniedException {
        File file = new File(string);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string, "r");
        if (!file.exists()) {
            if ((unsignedInteger32.intValue() & 8) != 8) throw new FileNotFoundException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string))).concat(" does not exist"));
            if (!file.createNewFile()) {
                throw new IOException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string))).concat(" could not be created"));
            }
        } else if ((unsignedInteger32.intValue() & 8) == 8 && (unsignedInteger32.intValue() & 0x20) == 32) {
            throw new IOException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string))).concat(" already exists"));
        }
        String string2 = "r".concat(String.valueOf(String.valueOf((unsignedInteger32.intValue() & 2) == 2 ? "ws" : "")));
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, string2);
        if ((unsignedInteger32.intValue() & 8) == 8 && (unsignedInteger32.intValue() & 0x10) == 16) {
            randomAccessFile.setLength(0L);
        }
        this.openFiles.put(randomAccessFile.toString(), new OpenFile(this, file, randomAccessFile, unsignedInteger32));
        return randomAccessFile.toString().getBytes();
    }

    public byte[] readFile(byte[] byArray, UnsignedInteger64 unsignedInteger64, UnsignedInteger32 unsignedInteger32) throws IOException, EOFException, InvalidHandleException {
        String string = new String(byArray);
        if (this.openFiles.containsKey(string)) {
            Object v = this.openFiles.get(string);
            if (v instanceof OpenFile) {
                OpenFile openFile = (OpenFile)v;
                if ((openFile.getFlags().intValue() & 1) == 1) {
                    int n;
                    byte[] byArray2 = new byte[unsignedInteger32.intValue()];
                    if (openFile.getRandomAccessFile().getFilePointer() != unsignedInteger64.longValue()) {
                        openFile.getRandomAccessFile().seek(unsignedInteger64.longValue());
                    }
                    if ((n = openFile.getRandomAccessFile().read(byArray2)) >= 0) {
                        if (n == byArray2.length) {
                            return byArray2;
                        }
                        byte[] byArray3 = new byte[n];
                        System.arraycopy(byArray2, 0, byArray3, 0, n);
                        return byArray3;
                    }
                    throw new EOFException("The file is EOF");
                }
                throw new InvalidHandleException("The file handle was not opened for reading");
            }
            throw new InvalidHandleException("Handle is not an open file");
        }
        throw new InvalidHandleException("The handle is invalid");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeFile(byte[] byArray, UnsignedInteger64 unsignedInteger64, byte[] byArray2, int n, int n2) throws IOException, InvalidHandleException {
        String string = new String(byArray);
        if (!this.openFiles.containsKey(string)) throw new InvalidHandleException("The handle is invalid");
        Object v = this.openFiles.get(string);
        if (!(v instanceof OpenFile)) throw new InvalidHandleException("Handle is not an open file");
        OpenFile openFile = (OpenFile)v;
        if ((openFile.getFlags().intValue() & 2) != 2) throw new InvalidHandleException("The file was not opened for writing");
        if ((openFile.getFlags().intValue() & 4) == 4) {
            openFile.getRandomAccessFile().seek(openFile.getRandomAccessFile().length());
        } else if (openFile.getRandomAccessFile().getFilePointer() != unsignedInteger64.longValue()) {
            openFile.getRandomAccessFile().seek(unsignedInteger64.longValue());
        }
        openFile.getRandomAccessFile().write(byArray2, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeFile(byte[] byArray) throws IOException, InvalidHandleException {
        String string = new String(byArray);
        if (!this.openFiles.containsKey(string)) throw new InvalidHandleException("The handle is invalid");
        Object v = this.openFiles.get(string);
        if (v instanceof OpenDirectory) {
            this.openFiles.remove(string);
            return;
        } else {
            if (!(v instanceof OpenFile)) throw new InvalidHandleException("Internal server error");
            ((OpenFile)v).getRandomAccessFile().close();
            this.openFiles.remove(string);
        }
    }

    public void removeFile(String string) throws FileNotFoundException, IOException, PermissionDeniedException {
        block5: {
            File file = new File(string);
            if (file.exists()) {
                try {
                    if (file.isFile()) {
                        if (!file.delete()) {
                            throw new IOException("Failed to delete ".concat(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string)))));
                        }
                        break block5;
                    }
                    throw new IOException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string))).concat(" is a directory, use remove directory command to remove"));
                }
                catch (SecurityException securityException) {
                    throw new PermissionDeniedException("Permission denied");
                }
            }
            throw new FileNotFoundException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string))).concat(" does not exist"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renameFile(String string, String string2) throws IOException, FileNotFoundException, PermissionDeniedException {
        File file = new File(string);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string, "rw");
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string2, "rw");
        if (!file.exists()) throw new FileNotFoundException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string))).concat(" does not exist"));
        File file2 = new File(string2);
        if (file2.exists()) throw new IOException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string2))).concat(" already exists"));
        if (file.renameTo(file2)) return;
        throw new IOException("Failed to rename file ".concat(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeDirectory(String string) throws IOException, FileNotFoundException, PermissionDeniedException {
        File file = new File(string);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), string, "rw");
        if (!file.isDirectory()) throw new IOException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string))).concat(" is not a directory"));
        if (!file.exists()) throw new FileNotFoundException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string))).concat(" does not exist"));
        if (file.listFiles().length != 0) throw new IOException(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string))).concat(" is not an empty directory"));
        if (file.delete()) return;
        throw new IOException("Failed to remove directory ".concat(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string)))));
    }

    public void setFileAttributes(String string, FileAttributes fileAttributes) throws FileNotFoundException, IOException, PermissionDeniedException {
    }

    public void setFileAttributes(byte[] byArray, FileAttributes fileAttributes) throws InvalidHandleException, IOException, PermissionDeniedException {
    }

    public File readSymbolicLink(String string) throws PermissionDeniedException, IOException, FileNotFoundException, UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException("Symbolic links are not supported by the Virtual File System");
    }

    public void createSymbolicLink(String string, String string2) throws PermissionDeniedException, IOException, FileNotFoundException, UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException("Symbolic links are not supported by the Virtual File System");
    }

    public void verifyPermissions(String string, String string2, String string3) throws IOException, FileNotFoundException, PermissionDeniedException {
        VFSPermission vFSPermission;
        String string4 = VirtualFileSystem.translateNFSPath(string2);
        VFSMount vFSMount = VirtualFileSystem.getMount(string4);
        if (vFSMount.getPermissions().containsKey(SshThread.getCurrentThreadUser())) {
            vFSPermission = (VFSPermission)vFSMount.getPermissions().get(SshThread.getCurrentThreadUser());
        } else if (vFSMount.getPermissions().containsKey("default")) {
            vFSPermission = (VFSPermission)vFSMount.getPermissions().get("default");
        } else {
            throw new PermissionDeniedException("No permissions set for mount");
        }
        if (!vFSPermission.verifyPermissions(string3)) {
            throw new PermissionDeniedException("Permission denied for ".concat(String.valueOf(String.valueOf(VirtualFileSystem.translateNFSPath(string2)))));
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$sftp$VirtualFileSystem == null ? (class$com$sshtools$j2ssh$sftp$VirtualFileSystem = VirtualFileSystem.class$("com.sshtools.j2ssh.sftp.VirtualFileSystem")) : class$com$sshtools$j2ssh$sftp$VirtualFileSystem));
        try {
            vfsmounts = ConfigurationLoader.getPlatformConfiguration().getVFSMounts();
            vfsroot = ConfigurationLoader.getPlatformConfiguration().getVFSRoot();
        }
        catch (ConfigurationException configurationException) {
            log.error((Object)"Failed to initialize the Virtual File System", (Throwable)configurationException);
        }
    }

    class OpenDirectory {
        File f;
        File[] children;
        int readpos = 0;

        public OpenDirectory(VirtualFileSystem virtualFileSystem, File file) {
            this.f = file;
            this.children = file.listFiles();
        }

        public File getFile() {
            return this.f;
        }

        public File[] getChildren() {
            return this.children;
        }

        public int getPosition() {
            return this.readpos;
        }

        public void setPosition(int n) {
            this.readpos = n;
        }
    }

    class OpenFile {
        File f;
        RandomAccessFile raf;
        UnsignedInteger32 flags;

        public OpenFile(VirtualFileSystem virtualFileSystem, File file, RandomAccessFile randomAccessFile, UnsignedInteger32 unsignedInteger32) {
            this.f = file;
            this.raf = randomAccessFile;
            this.flags = unsignedInteger32;
        }

        public File getFile() {
            return this.f;
        }

        public RandomAccessFile getRandomAccessFile() {
            return this.raf;
        }

        public UnsignedInteger32 getFlags() {
            return this.flags;
        }
    }
}

