/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

public abstract class SubsystemMessage {
    private int type;

    public SubsystemMessage(int n) {
        this.type = n;
    }

    public abstract String getMessageName();

    public int getMessageType() {
        return this.type;
    }

    public abstract void constructByteArray(ByteArrayWriter var1) throws IOException, InvalidMessageException;

    public abstract void constructMessage(ByteArrayReader var1) throws IOException, InvalidMessageException;

    public void fromByteArray(byte[] byArray) throws InvalidMessageException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            if (byteArrayReader.available() <= 0) {
                throw new InvalidMessageException("Not enough message data to complete the message");
            }
            this.type = byteArrayReader.read();
            this.constructMessage(byteArrayReader);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("The message data cannot be read!");
        }
    }

    public byte[] toByteArray() throws InvalidMessageException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.write(this.type);
            this.constructByteArray(byteArrayWriter);
            byte[] byArray = byteArrayWriter.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("The message data cannot be written!");
        }
    }
}

