/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.transport.AbstractHostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DialogHostKeyVerification
extends AbstractHostKeyVerification {
    Component parent;
    private boolean verificationEnabled = true;

    public DialogHostKeyVerification(Component component) throws InvalidHostFileException {
        this.parent = component;
    }

    public DialogHostKeyVerification(Component component, String string) throws InvalidHostFileException {
        super(string);
        this.parent = component;
    }

    public void setVerificationEnabled(boolean bl) {
        this.verificationEnabled = this.verificationEnabled;
    }

    public void onDeniedHost(final String string) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(DialogHostKeyVerification.this.parent, String.valueOf(String.valueOf(new StringBuffer("Access to '").append(string).append("' is denied.\n").append("Verify the access granted/denied in the allowed hosts file."))), "Remote Host Authentication", 0);
                    }
                });
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TransportProtocolException("Invocation Exception: ".concat(String.valueOf(String.valueOf(invocationTargetException.getMessage()))));
        }
        catch (InterruptedException interruptedException) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    public void onHostKeyMismatch(final String string, final String string2, final String string3) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Object[] objectArray = DialogHostKeyVerification.this.getOptions();
                        int n = JOptionPane.showOptionDialog(DialogHostKeyVerification.this.parent, String.valueOf(String.valueOf(new StringBuffer("The host '").append(string).append("' has provided a different host key.\nThe host key").append(" fingerprint provided is '").append(string3).append("'.\n").append("The allowed host key fingerprint is ").append(string2).append(".\nDo you want to allow this host?"))), "Remote host authentication", 1, 3, null, objectArray, objectArray[0]);
                        try {
                            if (objectArray.length == 3 && n == 0) {
                                DialogHostKeyVerification.this.allowHost(string, string3, true);
                            } else if (objectArray.length == 2 && n == 0 || objectArray.length == 3 && n == 1) {
                                DialogHostKeyVerification.this.allowHost(string, string3, false);
                            }
                        }
                        catch (InvalidHostFileException invalidHostFileException) {
                            DialogHostKeyVerification.this.showExceptionMessage(invalidHostFileException);
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TransportProtocolException("Invocation Exception: ".concat(String.valueOf(String.valueOf(invocationTargetException.getMessage()))));
        }
        catch (InterruptedException interruptedException) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    public void onUnknownHost(final String string, final String string2) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Object[] objectArray = DialogHostKeyVerification.this.getOptions();
                        int n = JOptionPane.showOptionDialog(DialogHostKeyVerification.this.parent, String.valueOf(String.valueOf(new StringBuffer("The host '").append(string).append("' is unknown. The host key").append(" fingerprint is\n'").append(string2).append("'.\nDo you want to allow this host?"))), "Remote host authentication", 1, 3, null, objectArray, objectArray[0]);
                        try {
                            if (objectArray.length == 3 && n == 0) {
                                DialogHostKeyVerification.this.allowHost(string, string2, true);
                            } else if (objectArray.length == 2 && n == 0 || objectArray.length == 3 && n == 1) {
                                DialogHostKeyVerification.this.allowHost(string, string2, false);
                            }
                        }
                        catch (InvalidHostFileException invalidHostFileException) {
                            DialogHostKeyVerification.this.showExceptionMessage(invalidHostFileException);
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TransportProtocolException("Invocation Exception: ".concat(String.valueOf(String.valueOf(invocationTargetException.getMessage()))));
        }
        catch (InterruptedException interruptedException) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    private String[] getOptions() {
        String[] stringArray;
        if (this.isHostFileWriteable()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "Always";
            stringArray2[1] = "Yes";
            stringArray = stringArray2;
            stringArray2[2] = "No";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "Yes";
            stringArray = stringArray3;
            stringArray3[1] = "No";
        }
        return stringArray;
    }

    private void showExceptionMessage(Exception exception) {
        JOptionPane.showMessageDialog(this.parent, "An unexpected error occured!\n\n".concat(String.valueOf(String.valueOf(exception.getMessage()))), "Host Verification", 0);
    }
}

