/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import com.sshtools.j2ssh.transport.compression.SshCompression;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.log4j.Logger;

class TransportProtocolInputStream {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$transport$TransportProtocolInputStream == null ? (class$com$sshtools$j2ssh$transport$TransportProtocolInputStream = TransportProtocolInputStream.class$("com.sshtools.j2ssh.transport.TransportProtocolInputStream")) : class$com$sshtools$j2ssh$transport$TransportProtocolInputStream));
    private long bytesTransfered = 0L;
    private BufferedInputStream in;
    private Object sequenceLock = new Object();
    private Socket socket;
    private TransportProtocolAlgorithmSync algorithms;
    private long sequenceNo = 0L;
    private long sequenceWrapLimit = BigInteger.valueOf(2L).pow(32).longValue();
    private SshCipher cipher;
    private SshHmac hmac;
    private SshCompression compression;
    int msglen;
    int padlen;
    int read;
    int remaining;
    int cipherlen = 8;
    int maclen = 0;
    byte[] buffer = new byte[128 * this.cipherlen];
    ByteArrayWriter message = new ByteArrayWriter();
    byte[] initial = new byte[this.cipherlen];
    byte[] data;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$TransportProtocolInputStream;

    public TransportProtocolInputStream(Socket socket, TransportProtocolAlgorithmSync transportProtocolAlgorithmSync) throws IOException {
        this.socket = socket;
        this.in = new BufferedInputStream(socket.getInputStream());
        this.algorithms = transportProtocolAlgorithmSync;
    }

    public synchronized long getSequenceNo() {
        return this.sequenceNo;
    }

    protected long getNumBytesTransfered() {
        return this.bytesTransfered;
    }

    public byte[] readMessage() throws IOException, SocketTimeoutException {
        this.message.reset();
        this.read = this.in.read(this.initial, 0, 1);
        if (this.read < 0) {
            throw new IOException("Socket is EOF");
        }
        this.cipher = this.algorithms.getCipher();
        this.hmac = this.algorithms.getHmac();
        this.compression = this.algorithms.getCompression();
        this.cipherlen = this.cipher != null ? this.cipher.getBlockSize() : 8;
        if (this.initial.length != this.cipherlen) {
            byte[] byArray = new byte[this.cipherlen];
            System.arraycopy(this.initial, 0, byArray, 0, this.initial.length);
            this.initial = byArray;
        }
        int n = this.read;
        do {
            this.read = this.in.read(this.initial, n, this.initial.length - n);
        } while ((n += this.read) < this.initial.length);
        if (this.buffer.length % this.cipherlen != 0) {
            this.buffer = new byte[128 * this.cipherlen];
        }
        this.maclen = this.hmac != null ? this.hmac.getMacLength() : 0;
        if (this.cipher != null) {
            this.initial = this.cipher.transform(this.initial);
        }
        this.message.write(this.initial);
        this.msglen = (int)ByteArrayReader.readInt(this.initial, 0);
        this.padlen = this.initial[4];
        this.remaining = this.msglen - (this.cipherlen - 4);
        while (this.remaining > 0) {
            this.read = this.remaining > this.buffer.length ? this.in.read(this.buffer) : this.in.read(this.buffer, 0, this.remaining);
            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Read ").append(String.valueOf(this.read)).append(" bytes from socket"))));
            if (this.read > 0) {
                this.remaining -= this.read;
                if (this.cipher != null) {
                    this.message.write(this.cipher.transform(this.buffer, 0, this.read));
                    continue;
                }
                this.message.write(this.buffer, 0, this.read);
                continue;
            }
            if (this.read == 0) {
                log.warn((Object)"Read returned zero bytes");
                continue;
            }
            throw new IOException("Socket InputStream is EOF");
        }
        Object object = this.sequenceLock;
        synchronized (object) {
            if (this.hmac != null) {
                for (n = 0; n < this.maclen; n += this.read) {
                    this.read = this.in.read(this.buffer, 0, this.maclen - n);
                    if (this.read > 0) {
                        this.message.write(this.buffer, 0, this.read);
                        continue;
                    }
                    throw new IOException("EOF whilst reading MAC data!");
                }
                if (!this.hmac.verify(this.sequenceNo, this.message.toByteArray())) {
                    throw new IOException("Corrupt Mac on input");
                }
            }
            this.sequenceNo = this.sequenceNo < this.sequenceWrapLimit ? ++this.sequenceNo : 0L;
        }
        this.bytesTransfered += (long)this.message.size();
        byte[] byArray = new byte[this.msglen + 4 - this.padlen];
        System.arraycopy(this.message.toByteArray(), 0, byArray, 0, this.msglen + 4 - this.padlen);
        return byArray;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

