/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.compression;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.compression.SshCompression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SshCompressionFactory {
    public static final String COMP_NONE = "none";
    private static String defaultAlgorithm;
    private static Map comps;
    private static Logger log;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$compression$SshCompressionFactory;

    protected SshCompressionFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultCompression() {
        return defaultAlgorithm;
    }

    public static List getSupportedCompression() {
        return new ArrayList(comps.keySet());
    }

    public static SshCompression newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            SshCompression sshCompression = (SshCompression)((Class)comps.get(string)).newInstance();
            return sshCompression;
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(String.valueOf(String.valueOf(string)).concat(" is not supported!"));
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$transport$compression$SshCompressionFactory == null ? (class$com$sshtools$j2ssh$transport$compression$SshCompressionFactory = SshCompressionFactory.class$("com.sshtools.j2ssh.transport.compression.SshCompressionFactory")) : class$com$sshtools$j2ssh$transport$compression$SshCompressionFactory));
        comps = new HashMap();
        log.info((Object)"Loading compression methods");
        comps.put(COMP_NONE, "");
        try {
            SshAPIConfiguration sshAPIConfiguration = ConfigurationLoader.getAPIConfiguration();
            if (sshAPIConfiguration != null) {
                List list = sshAPIConfiguration.getCompressionExtensions();
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ExtensionAlgorithm extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
                        String string = extensionAlgorithm.getAlgorithmName();
                        if (comps.containsKey(string)) {
                            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Standard compression method ").append(string).append(" is being overidden by ").append(extensionAlgorithm.getImplementationClass()))));
                        } else {
                            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(extensionAlgorithm.getAlgorithmName()))).append(" compression is implemented by ").append(extensionAlgorithm.getImplementationClass()))));
                        }
                        try {
                            comps.put(extensionAlgorithm.getAlgorithmName(), ConfigurationLoader.getExtensionClass(extensionAlgorithm.getImplementationClass()));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            log.error((Object)"Could not locate ".concat(String.valueOf(String.valueOf(extensionAlgorithm.getImplementationClass()))));
                        }
                    }
                }
                defaultAlgorithm = sshAPIConfiguration.getDefaultCompression();
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (defaultAlgorithm == null || !comps.containsKey(defaultAlgorithm)) {
            defaultAlgorithm = COMP_NONE;
        }
    }
}

