/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyFormatConversion;
import com.sshtools.j2ssh.util.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Base64EncodedFileFormat
implements SshKeyFormatConversion {
    protected String begin;
    protected String end;
    private Map headers = new HashMap();
    private int MAX_LINE_LENGTH = 70;

    protected Base64EncodedFileFormat(String string, String string2) {
        this.begin = string;
        this.end = string2;
    }

    public String getFormatType() {
        return "Base64Encoded";
    }

    public boolean isFormatted(byte[] byArray) {
        String string = new String(byArray);
        return string.indexOf(this.begin) >= 0 && string.indexOf(this.end) > 0;
    }

    public void setHeaderValue(String string, String string2) {
        this.headers.put(string, string2);
    }

    public String getHeaderValue(String string) {
        return (String)this.headers.get(string);
    }

    public byte[] getKeyBlob(byte[] byArray) throws InvalidSshKeyException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
        String string = "";
        try {
            Object object;
            String string2;
            do {
                if ((string2 = bufferedReader.readLine()) != null) continue;
                throw new InvalidSshKeyException("Incorrect file format!");
            } while (!string2.endsWith(this.begin));
            while (true) {
                if ((string2 = bufferedReader.readLine()) == null) {
                    throw new InvalidSshKeyException("Incorrect file format!");
                }
                int n = string2.indexOf(": ");
                if (n <= 0) break;
                while (string2.endsWith("\\")) {
                    string2 = string2.substring(0, string2.length() - 1);
                    object = bufferedReader.readLine();
                    if (object == null) {
                        throw new InvalidSshKeyException("Incorrect file format!");
                    }
                    string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(object)));
                }
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 2);
                this.headers.put(string3, string4);
            }
            object = new ByteArrayWriter();
            do {
                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(string2)));
                string2 = bufferedReader.readLine();
                if (string2 != null) continue;
                throw new InvalidSshKeyException("Invalid file format!");
            } while (!string2.endsWith(this.end));
            byte[] byArray2 = Base64.decode(string);
            return byArray2;
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException();
        }
    }

    public byte[] formatKey(byte[] byArray) {
        try {
            String string;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.begin.getBytes());
            byteArrayOutputStream.write(10);
            Set set = this.headers.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = (String)this.headers.get(string2);
                string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append(": ").append(string3)));
                for (int i = 0; i < string.length(); i += this.MAX_LINE_LENGTH) {
                    String string4 = String.valueOf(String.valueOf(string.substring(i, i + this.MAX_LINE_LENGTH < string.length() ? i + this.MAX_LINE_LENGTH : string.length()))).concat(String.valueOf(String.valueOf(i + this.MAX_LINE_LENGTH < string.length() ? "\\" : "")));
                    byteArrayOutputStream.write(string4.getBytes());
                    byteArrayOutputStream.write(10);
                }
            }
            string = Base64.encodeBytes(byArray, false);
            byteArrayOutputStream.write(string.getBytes());
            byteArrayOutputStream.write(10);
            byteArrayOutputStream.write(this.end.getBytes());
            byteArrayOutputStream.write(10);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            byte[] byArray3 = null;
            return byArray3;
        }
    }
}

