/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormatFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SshPrivateKeyFile {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFile == null ? (class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFile = SshPrivateKeyFile.class$("com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile")) : class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFile));
    private SshPrivateKeyFormat format;
    private byte[] keyblob;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFile;

    protected SshPrivateKeyFile(byte[] byArray, SshPrivateKeyFormat sshPrivateKeyFormat) {
        this.keyblob = byArray;
        this.format = sshPrivateKeyFormat;
    }

    public byte[] getBytes() {
        return this.keyblob;
    }

    public byte[] getKeyBlob(String string) throws InvalidSshKeyException {
        return this.format.decryptKeyblob(this.keyblob, string);
    }

    public void changePassphrase(String string, String string2) throws InvalidSshKeyException {
        byte[] byArray = this.format.decryptKeyblob(this.keyblob, string);
        this.keyblob = this.format.encryptKeyblob(byArray, string2);
    }

    public static SshPrivateKeyFile parse(byte[] byArray) throws InvalidSshKeyException {
        log.info((Object)"Parsing private key file");
        SshPrivateKeyFormat sshPrivateKeyFormat = SshPrivateKeyFormatFactory.newInstance(SshPrivateKeyFormatFactory.getDefaultFormatType());
        boolean bl = sshPrivateKeyFormat.isFormatted(byArray);
        if (!bl) {
            log.info((Object)"Private key is not in the default format, attempting parse with other supported formats");
            Iterator iterator = SshPrivateKeyFormatFactory.getSupportedFormats().iterator();
            while (iterator.hasNext() && !bl) {
                String string = (String)iterator.next();
                log.debug((Object)"Attempting ".concat(String.valueOf(String.valueOf(string))));
                sshPrivateKeyFormat = SshPrivateKeyFormatFactory.newInstance(string);
                bl = sshPrivateKeyFormat.isFormatted(byArray);
            }
        }
        if (bl) {
            return new SshPrivateKeyFile(byArray, sshPrivateKeyFormat);
        }
        throw new InvalidSshKeyException("The key format is not a supported format");
    }

    public static SshPrivateKeyFile parse(File file) throws IOException, InvalidSshKeyException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return SshPrivateKeyFile.parse(byArray);
    }

    public boolean isPassphraseProtected() {
        return this.format.isPassphraseProtected(this.keyblob);
    }

    public static SshPrivateKeyFile create(SshPrivateKey sshPrivateKey, String string, SshPrivateKeyFormat sshPrivateKeyFormat) throws InvalidSshKeyException {
        byte[] byArray = sshPrivateKeyFormat.encryptKeyblob(sshPrivateKey.getEncoded(), string);
        return new SshPrivateKeyFile(byArray, sshPrivateKeyFormat);
    }

    public void setFormat(SshPrivateKeyFormat sshPrivateKeyFormat, String string) throws InvalidSshKeyException {
        byte[] byArray = this.format.decryptKeyblob(this.keyblob, string);
        this.format = sshPrivateKeyFormat;
        this.keyblob = this.format.encryptKeyblob(byArray, string);
    }

    public SshPrivateKeyFormat getFormat() {
        return this.format;
    }

    public SshPrivateKey toPrivateKey(String string) throws InvalidSshKeyException {
        try {
            byte[] byArray = this.format.decryptKeyblob(this.keyblob, string);
            SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(this.getAlgorithm(byArray));
            SshPrivateKey sshPrivateKey = sshKeyPair.decodePrivateKey(byArray);
            return sshPrivateKey;
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            throw new InvalidSshKeyException("The public key algorithm for this private key is not supported");
        }
    }

    public String toString() {
        return new String(this.keyblob);
    }

    private String getAlgorithm(byte[] byArray) {
        return ByteArrayReader.readString(byArray, 0);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

