/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.rsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;

public class SshRsaPublicKey
extends SshPublicKey {
    RSAPublicKey pubKey;

    public SshRsaPublicKey(RSAPublicKey rSAPublicKey) {
        this.pubKey = rSAPublicKey;
    }

    public SshRsaPublicKey(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.pubKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidSshKeyException();
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidSshKeyException();
            }
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException();
        }
    }

    public String getAlgorithmName() {
        return "ssh-rsa";
    }

    public int getBitLength() {
        return this.pubKey.getModulus().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBigInteger(this.pubKey.getPublicExponent());
            byteArrayWriter.writeBigInteger(this.pubKey.getModulus());
            byte[] byArray = byteArrayWriter.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws InvalidSshKeySignatureException {
        try {
            Object object;
            if (byArray.length != 128) {
                object = new ByteArrayReader(byArray);
                byte[] byArray3 = ((ByteArrayReader)object).readBinaryString();
                String string = new String(byArray3);
                if (!string.equals(this.getAlgorithmName())) {
                    throw new InvalidSshKeySignatureException();
                }
                byArray = ((ByteArrayReader)object).readBinaryString();
            }
            object = Signature.getInstance("SHA1withRSA");
            ((Signature)object).initVerify(this.pubKey);
            ((Signature)object).update(byArray2);
            boolean bl = ((Signature)object).verify(byArray);
            return bl;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (IOException iOException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (SignatureException signatureException) {
            throw new InvalidSshKeySignatureException();
        }
    }
}

