/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.util;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.util.State;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class MultipleStateMonitor {
    private List monitors = new Vector();
    private List states = new Vector();
    private State changed = null;

    public void addState(State state) {
        this.states.add(state);
    }

    public synchronized void breakWaiting() {
        this.notifyAll();
    }

    public synchronized State monitor() {
        this.monitors.clear();
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            this.monitors.add(new StateMonitor(this, (State)iterator.next(), this));
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.changed;
    }

    public synchronized void updateState() {
        this.notifyAll();
    }

    class StateMonitor
    implements Runnable {
        private MultipleStateMonitor monitor;
        private State state;
        private Thread thread;
        private boolean active = false;

        public StateMonitor(MultipleStateMonitor multipleStateMonitor, State state, MultipleStateMonitor multipleStateMonitor2) {
            this.state = state;
            this.monitor = multipleStateMonitor2;
            this.thread = new SshThread(this, "Multiple state monitor", true);
            this.thread.start();
        }

        public void close() {
            this.active = false;
            this.monitor.breakWaiting();
        }

        public void run() {
            this.active = true;
            while (this.active) {
                try {
                    this.state.waitForStateUpdate();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.active) continue;
                this.monitor.updateState();
            }
        }
    }
}

