/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;

import com.sshtools.j2ssh.transport.TransportProtocolState;

import java.util.HashMap;


public class SshThread extends Thread {
    private static HashMap names = new HashMap();
    protected byte[] sessionId;
    protected String sessionIdString = null;
    protected String username;
    private HashMap settings = new HashMap();

    public SshThread(Runnable target, String name, boolean daemon) {
        super(target);

        Integer i;

        if (names.containsKey(name)) {
            i = new Integer(((Integer) names.get(name)).intValue() + 1);
        } else {
            i = new Integer(1);
        }

        names.put(name, i);
        setName(name + " " + Integer.toHexString(i.intValue() & 0xFF));
        setDaemon(daemon);

        if (ConfigurationLoader.isContextClassLoader()) {
            setContextClassLoader(ConfigurationLoader.getContextClassLoader());
        }
    }

    public void setSessionId(byte[] sessionId) {
        if (sessionId != null) {
            this.sessionId = new byte[sessionId.length];
            System.arraycopy(sessionId, 0, this.sessionId, 0, sessionId.length);
            sessionIdString = String.valueOf(new String(sessionId).hashCode() & 0xFFFFFFFFL);
        }
    }

    /*public byte[] getSessionId() {
        return sessionId;
    }*/

    public String getSessionIdString() {
      return sessionIdString;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return username;
    }

    public SshThread cloneThread(Runnable target, String name) {
        SshThread thread = new SshThread(target, name, isDaemon());
        thread.setSessionId(sessionId);
        thread.setUsername(username);
        thread.settings.putAll(settings);

        return thread;
    }

    public void setProperty(String name, Object value) {
        settings.put(name, value);
    }

    public Object getProperty(String name) {
        return settings.get(name);
    }

    public boolean containsProperty(String name) {
        return settings.containsKey(name);
    }

    public static String getCurrentThreadUser() throws SshRuntimeException {
        String username;

        if (Thread.currentThread() instanceof SshThread) {
            return ((SshThread) Thread.currentThread()).getUsername();
        } else {
            throw new SshRuntimeException(
                "The current thread is not running within an SshThread context");
        }
    }

    public static String getCurrentSessionId() throws SshRuntimeException {
        String username;

        if (Thread.currentThread() instanceof SshThread) {
            return ((SshThread) Thread.currentThread()).getSessionIdString();
        } else {
            throw new SshRuntimeException(
                "The current thread is not running within an SshThread context");
        }
    }

    public static SshThread getCurrentThread() throws SshRuntimeException {

      if(Thread.currentThread() instanceof SshThread) {
        return (SshThread) Thread.currentThread();
      }
      else
        throw new SshRuntimeException("The current thread is not an SshThread");
    }

}
