package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.io.IOException;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;

public class SshAgentPing extends SubsystemMessage {

  public static final int SSH_AGENT_PING = 212;

  private byte[] padding;

  public SshAgentPing() {
    super(SSH_AGENT_PING);
  }

  public SshAgentPing(byte[] padding) {
    super(SSH_AGENT_PING);
    this.padding = padding;
  }

  public byte[] getPadding() {
    return padding;
  }

  public String getMessageName() {
    return "SSH_AGENT_PING";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.write(padding);
    } catch(IOException ioe) {
      throw new InvalidMessageException(ioe.getMessage());
    }
  }
  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      padding = new byte[bar.available()];
      bar.read(padding);
    } catch(IOException ioe) {
      throw new InvalidMessageException(ioe.getMessage());
    }

  }
}