/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.authentication;

import java.io.IOException;
import java.util.Map;

import org.apache.log4j.Logger;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.platform.NativeAuthenticationProvider;
import com.sshtools.j2ssh.platform.PasswordChangeException;

public class PasswordAuthenticationServer
    extends SshAuthenticationServer {
  private static Logger log = Logger.getLogger(PasswordAuthenticationServer.class);

  public final String getMethodName() {
    return "password";
  }

  public void setAuthenticatedTokens(Map tokens) {
  }

  public int authenticate(AuthenticationProtocolServer authentication,
                          SshMsgUserAuthRequest msg) throws IOException {
    NativeAuthenticationProvider authImpl = NativeAuthenticationProvider
        .getInstance();

    if (authImpl == null) {
      log.error(
          "Cannot perfrom authentication witout native authentication provider");

      return AuthenticationProtocolState.FAILED;
    }

    ByteArrayReader bar = new ByteArrayReader(msg.getRequestData());
    boolean changepwd = ( (bar.read() == 0) ? false : true);
    String password = bar.readString();
    String newpassword = null;

    if (changepwd) {
      newpassword = bar.readString();

      try {
        if (!authImpl.changePassword(msg.getUsername(), password,
                                     newpassword)) {
          return AuthenticationProtocolState.FAILED;
        }

        if (authImpl.logonUser(msg.getUsername(), newpassword)) {
          return AuthenticationProtocolState.COMPLETE;
        }
        else {
          return AuthenticationProtocolState.FAILED;
        }
      }
      catch (PasswordChangeException ex1) {
        return AuthenticationProtocolState.FAILED;
      }
    }
    else {
      try {
        if (authImpl.logonUser(msg.getUsername(), password)) {
          log.info(msg.getUsername()
                   + " has passed password authentication");

          return AuthenticationProtocolState.COMPLETE;
        }
        else {
          log.info(msg.getUsername()
                   + " has failed password authentication");

          return AuthenticationProtocolState.FAILED;
        }
      }
      catch (PasswordChangeException ex) {
        SshMsgUserAuthPwdChangeReq reply = new SshMsgUserAuthPwdChangeReq(msg
            .getUsername() + " is required to change password", "");
        authentication.sendMessage(reply);

        return AuthenticationProtocolState.READY;
      }
    }
  }
}
