/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.authentication;

import java.io.IOException;
import java.util.Properties;

public abstract class SshAuthenticationClient {
  private String username;
  private SshAuthenticationPrompt prompt;

  public abstract String getMethodName();

  public abstract void authenticate(
      AuthenticationProtocolClient authentication, String serviceToStart) throws
      IOException, TerminatedStateException;

  public void setAuthenticationPrompt(SshAuthenticationPrompt prompt)
      throws AuthenticationProtocolException {

    prompt.setInstance(this);
    this.prompt = prompt;
  }

  public SshAuthenticationPrompt getAuthenticationPrompt() {
    return prompt;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public String getUsername() {
    return username;
  }

  public abstract Properties getPersistableProperties();

  public abstract void setPersistableProperties(Properties properties);

  public abstract boolean canAuthenticate();

  public boolean canPrompt() {
    return prompt != null;
  }
}
