/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.configuration;

import java.util.HashMap;
import java.util.Map;
import java.io.File;
import java.io.IOException;


public class VFSMount {
    private String mount;
    private String path;
    private HashMap acl = new HashMap();
    private boolean isroot = false;

    public VFSMount(String mount, String path) throws IOException {

      path.replace('\\', '/');

      // Replace any tokens
      int index = path.indexOf("%HOME%");
      if(index >= 0) {

         path = ((index > 0) ? path.substring(0, index) : "")
                + ConfigurationLoader.getHomeDirectory()
                + ((index+6 < path.length() - 1)? path.substring(index+ (path.charAt(index+6)=='/' ? 7 : 6)) : "");

         }

        File f = new File(path);

        if(!f.exists())
          f.mkdirs();

        if (!mount.trim().startsWith("/")) {
            this.mount = "/" + mount.trim();
        } else {
            this.mount = mount.trim();
        }

        this.path = f.getCanonicalPath();
    }

    public boolean isRoot() {
        return isroot;
    }

    protected void setRoot(boolean isroot) {
        this.isroot = isroot;
    }

    public void setPermissions(VFSPermission permissions) {
        acl.put(permissions.getName(), permissions);
    }

    public String getPath() {
        return path.replace('\\', '/');
    }

    public String getMount() {
        return mount;
    }

    public Map getPermissions() {
        return acl;
    }
}
