/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.configuration.automate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;


public class RemoteIdentificationRule {
    private static HashSet allowedOperations = new HashSet();

    static {
        allowedOperations.add("startsWith");
        allowedOperations.add("contains");
    }

    private HashMap expressions = new HashMap();
    private int priority = 10;
    private String name;

    public boolean testRule(String identification) {
        // Get the software version portion of the id string
        String svc = identification.substring(identification.lastIndexOf("-")
                + 1);
        Iterator it = expressions.entrySet().iterator();
        Map.Entry entry;
        boolean pass = false;
        String operation;

        while (it.hasNext()) {
            entry = (Map.Entry) it.next();
            operation = (String) entry.getKey();

            if (operation.equals("startsWith")) {
                pass = svc.startsWith((String) entry.getValue());
            }

            if (operation.equals("contains")) {
                pass = (svc.indexOf((String) entry.getValue()) >= 0);
            }
        }

        return pass;
    }

    protected void setPriority(int priority) {
        this.priority = priority;
    }

    protected void addExpression(String operation, String value)
        throws UnsupportedRuleException {
        if (allowedOperations.contains(operation)) {
            expressions.put(operation, value);
        } else {
            throw new UnsupportedRuleException("The rule '" + operation
                + "' is not supported");
        }
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public int getPriority() {
        return priority;
    }
}
