/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.io;

import java.io.Serializable;

import java.math.BigInteger;


public class UnsignedInteger64 extends Number implements Serializable,
    Comparable {
    final static long serialVersionUID = 200;
    public final static BigInteger MAX_VALUE = new BigInteger(
            "18446744073709551615");
    public final static BigInteger MIN_VALUE = new BigInteger("0");
    private BigInteger bigInt;

    public UnsignedInteger64(String sval) throws NumberFormatException {
        bigInt = new BigInteger(sval);

        if ((bigInt.compareTo(MIN_VALUE) < 0)
                || (bigInt.compareTo(MAX_VALUE) > 0)) {
            throw new NumberFormatException();
        }
    }

    public UnsignedInteger64(byte[] bval) throws NumberFormatException {
        bigInt = new BigInteger(bval);

        if ((bigInt.compareTo(MIN_VALUE) < 0)
                || (bigInt.compareTo(MAX_VALUE) > 0)) {
            throw new NumberFormatException();
        }
    }

    public UnsignedInteger64(BigInteger input) {
        bigInt = new BigInteger(input.toString());

        if ((bigInt.compareTo(MIN_VALUE) < 0)
                || (bigInt.compareTo(MAX_VALUE) > 0)) {
            throw new NumberFormatException();
        }
    }

    public boolean equals(Object o) {
        try {
            UnsignedInteger64 u = (UnsignedInteger64) o;

            return u.bigInt.equals(this.bigInt);
        } catch (ClassCastException ce) {
            // This was not an UnsignedInt64, so equals should fail.
            return false;
        }
    }

    public BigInteger bigIntValue() {
        return bigInt;
    }

    public int intValue() {
        return bigInt.intValue();
    }

    public long longValue() {
        return bigInt.longValue();
    }

    public double doubleValue() {
        return bigInt.doubleValue();
    }

    public float floatValue() {
        return bigInt.floatValue();
    }

    public int compareTo(Object val) {
        return bigInt.compareTo(((UnsignedInteger64) val).bigInt);
    }

    public String toString() {
        return bigInt.toString();
    }

    public int hashCode() {
        return bigInt.hashCode();
    }

    public static UnsignedInteger64 add(UnsignedInteger64 x, UnsignedInteger64 y) {
        return new UnsignedInteger64(x.bigInt.add(y.bigInt));
    }

    public static UnsignedInteger64 add(UnsignedInteger64 x, int y) {
        return new UnsignedInteger64(x.bigInt.add(BigInteger.valueOf(y)));
    }
}
