/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.transport.hmac;

public class HmacMd596 extends HmacMd5 {
    public HmacMd596() {
    }

    public int getMacLength() {
        return 12;
    }

    public byte[] generate(long sequenceNo, byte[] data, int offset, int len) {
        byte[] generated = super.generate(sequenceNo, data, offset, len);
        byte[] result = new byte[getMacLength()];

        System.arraycopy(generated, 0, result, 0, getMacLength());

        return result;
    }
}
