/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.transport.kex;

import java.math.BigInteger;


public class KeyExchangeState {
    public final static int IN_PROGRESS = 0;
    public final static int COMPLETE = 1;
    public final static int FAILED = 2;
    private BigInteger secret;
    private String reason;
    private byte[] exchangeHash;
    private byte[] hostKey;
    private byte[] signature;
    private int state = IN_PROGRESS;

    public KeyExchangeState() {
    }

    public final synchronized void setComplete(byte[] exchangeHash,
        byte[] hostKey, byte[] signature, BigInteger secret) {
        this.exchangeHash = exchangeHash;
        this.hostKey = hostKey;
        this.signature = signature;
        this.secret = secret;
        state = COMPLETE;

        notifyAll();
    }

    public byte[] getExchangeHash() {
        return exchangeHash;
    }

    public final synchronized void setFailed(String reason) {
        this.reason = reason;

        state = FAILED;

        notifyAll();
    }

    public byte[] getHostKey() {
        return hostKey;
    }

    public BigInteger getSecret() {
        return secret;
    }

    public byte[] getSignature() {
        return signature;
    }

    public synchronized int getState() {
        return state;
    }

    public final synchronized void waitForCompletion() {
        while (state == IN_PROGRESS) {
            try {
                wait();
            } catch (InterruptedException e) {
            }
        }
    }

    public synchronized String getFailureReason() {
        return reason;
    }
}
