/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.transport.publickey;

public abstract class SshKeyPair {
    private SshPrivateKey prv;
    private SshPublicKey pub;

    public SshKeyPair() {
    }

    public abstract void generate(int bits);

    public void setPrivateKey(SshPrivateKey key) {
        this.prv = key;
        this.pub = key.getPublicKey();
    }

    public SshPrivateKey setPrivateKey(byte[] encoded)
        throws InvalidSshKeyException {
        setPrivateKey(decodePrivateKey(encoded));

        return this.prv;
    }

    public SshPrivateKey getPrivateKey() {
        return prv;
    }

    public SshPublicKey setPublicKey(byte[] encoded)
        throws InvalidSshKeyException {
        this.pub = decodePublicKey(encoded);
        this.prv = null;

        return this.pub;
    }

    public SshPublicKey getPublicKey() {
        return pub;
    }

    public abstract SshPrivateKey decodePrivateKey(byte[] encoded)
        throws InvalidSshKeyException;

    public abstract SshPublicKey decodePublicKey(byte[] encoded)
        throws InvalidSshKeyException;
}
