/*
 *  Sshtools - Application Framework
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.daemon.windows;

import java.io.IOException;
import java.io.InputStream;


public class WindowsProcessInputStream extends InputStream {
    static {
        System.loadLibrary("sshtools-daemon-win32");
    }

    int handle;

    public WindowsProcessInputStream(int handle) {
        this.handle = handle;
    }

    public int available() {
        return getAvailable(handle);
    }

    public int read() throws IOException {
        return readByte(handle);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return readBytes(handle, b, off, len);
    }

    private native int getAvailable(int handle);

    private native int readByte(int handle);

    private native int readBytes(int handle, byte[] b, int off, int len);
}
