package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.io.*;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.*;
import java.util.*;

public class SshAgentDeleteKey extends SubsystemMessage {

  public static final int SSH_AGENT_DELETE_KEY = 207;


  SshPublicKey pubkey;
  String description;

  public SshAgentDeleteKey() {
    super(SSH_AGENT_DELETE_KEY);
  }

  public SshAgentDeleteKey(SshPublicKey pubkey,
  String description) {
  super(SSH_AGENT_DELETE_KEY);


    this.pubkey = pubkey;
    this.description = description;

}


  public SshPublicKey getPublicKey() {
    return pubkey;
  }

  public String getDescription() {
    return description;
  }


  public String getMessageName() {
    return "SSH_AGENT_DELETE_KEY";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException,
      com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.writeBinaryString(pubkey.getEncoded());
      baw.writeString(description);
    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }

  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      pubkey = SshKeyPairFactory.decodePublicKey(bar.readBinaryString());
      description = bar.readString();
    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }
}