package com.sshtools.j2ssh.agent;


import java.net.*;
import java.io.*;
import com.sshtools.j2ssh.io.*;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import java.util.*;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.*;

import org.apache.log4j.Logger;

import com.sshtools.j2ssh.connection.*;

import com.sshtools.j2ssh.util.StartStopState;

public class SshAgentForwardingListener {

   ServerSocket server;
   int port;
   String location;
   StartStopState state = new StartStopState(StartStopState.STOPPED);
   Thread thread;
   ConnectionProtocol connection;
   Vector references = new Vector();
   String sessionId;

   private static Logger log = Logger.getLogger(SshAgentForwardingListener.class);

   private static HashMap agents = new HashMap();

   SshAgentForwardingListener(String sessionId, ConnectionProtocol connection) {

     log.info("Forwarding agent started");
     this.sessionId = sessionId;
     this.connection = connection;
     port = selectPort();
     location = "localhost:" + String.valueOf(port);
     thread = new Thread(new Runnable() {

       public void run() {

            state.setValue(StartStopState.STARTED);


           try {
             server = new ServerSocket();
             server.bind(new InetSocketAddress("localhost", port));
             Socket socket;
              while(state.getValue()==StartStopState.STARTED
                    && (socket = server.accept())!=null) {
                AgentForwardingChannel channel = new AgentForwardingChannel(true);
                channel.bindSocket(socket);
                if(!SshAgentForwardingListener.this.connection.openChannel(channel))
                  log.warn("Failed to open agent forwarding channel");
              }
           }
           catch (Exception e) {
             if(state.getValue()==StartStopState.STARTED)
               log.warn("Forwarding agent socket failed", e);
           }

           state.setValue(StartStopState.STOPPED);
       }

      });


   }

   public String getConfiguration() {
     return location;
   }

   public void addReference(Object obj) {
     if(!references.contains(obj))
       references.add(obj);
   }

   public void removeReference(Object obj) {
     if(references.contains(obj)) {
       references.remove(obj);
       if(references.size() == 0) {
         stop();
         agents.remove(sessionId);
       }
     }
   }

   public void start() throws IOException {
     thread.start();
   }

   public int getPort() {
     return port;
   }

   public void stop() {
    try {
      state.setValue(StartStopState.STOPPED);
      server.close();
    }
    catch (IOException ex) {
    }
   }

   private int selectPort() {
     return 49152 + (int) Math.round(((float)16383 * ConfigurationLoader.getRND().nextFloat()));
   }

   public static SshAgentForwardingListener getInstance(String sessionId, ConnectionProtocol connection)
       throws AgentNotAvailableException {
     if(agents.containsKey(sessionId)) {
       SshAgentForwardingListener agent = (SshAgentForwardingListener)agents.get(sessionId);
       return agent;
     } else {
      try {
        SshAgentForwardingListener agent = new SshAgentForwardingListener(
            sessionId, connection);
        agent.start();
        agents.put(sessionId, agent);
        return agent;
      }
      catch (IOException ex) {
        throw new AgentNotAvailableException();
      }
     }
   }


}