package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.io.*;
import com.sshtools.j2ssh.transport.InvalidMessageException;

public class SshAgentForwardingNotice extends SubsystemMessage {

  public static final int SSH_AGENT_FORWARDING_NOTICE = 206;
  String remoteHostname;
  String remoteIPAddress;
  UnsignedInteger32 remotePort;

  public SshAgentForwardingNotice() {
    super(SSH_AGENT_FORWARDING_NOTICE);
  }

  public SshAgentForwardingNotice(String remoteHostname,
                                  String remoteIPAddress,
                                  int remotePort) {
  super(SSH_AGENT_FORWARDING_NOTICE);
  this.remoteHostname = remoteHostname;
  this.remoteIPAddress = remoteIPAddress;
  this.remotePort = new UnsignedInteger32(remotePort);
}


  public String getRemoteHostname() {
    return remoteHostname;
  }

  public String getRemoteIPAddress() {
    return remoteIPAddress;
  }

  public int getRemotePort() {
    return remotePort.intValue();
  }

  public String getMessageName() {
    return "SSH_AGENT_FORWARDING_NOTICE";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException,
      com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.writeString(remoteHostname);
      baw.writeString(remoteIPAddress);
      baw.writeUINT32(remotePort);
    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }
  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      remoteHostname = bar.readString();
      remoteIPAddress = bar.readString();
      remotePort = bar.readUINT32();
    }
    catch (IOException ex) {
      throw new InvalidMessageException(ex.getMessage());
    }
  }
}