package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.util.*;
import com.sshtools.j2ssh.transport.publickey.*;
import java.io.*;
import com.sshtools.j2ssh.transport.InvalidMessageException;

public class SshAgentKeyList extends SubsystemMessage {

  public static final int SSH_AGENT_KEY_LIST = 104;
  private Map keys;

  public SshAgentKeyList(Map keys) {
    super(SSH_AGENT_KEY_LIST);
    this.keys = keys;
  }

  public SshAgentKeyList() {
      super(SSH_AGENT_KEY_LIST);
      this.keys = new HashMap();
    }

  public Map getKeys() {
    return keys;
  }

  public String getMessageName() {
    return "SSH_AGENT_KEY_LIST";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {

    try {
      baw.writeInt(keys.size());

      Map.Entry entry;
      Iterator it = keys.entrySet().iterator();
      SshPublicKey key;
      String description;
      while (it.hasNext()) {
        entry = (Map.Entry) it.next();
        key = (SshPublicKey) entry.getKey();
        description = (String) entry.getValue();
        baw.writeBinaryString(key.getEncoded());
        baw.writeString(description);
      }
    }
    catch (IOException ex) {
      throw new InvalidMessageException("Failed to write message data");
    }
  }
  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {

    try {

      int num = (int)bar.readInt();
      SshPublicKey key;
      String description;
      byte[] buf;
      for(int i=0;i<num;i++) {
        buf = bar.readBinaryString();
        key = SshKeyPairFactory.decodePublicKey(buf);
        description = bar.readString();
        keys.put(key, description);
      }
    }
    catch (IOException ex) {
      throw new InvalidMessageException("Failed to read message data");
    }
  }
}