package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.subsystem.*;
import com.sshtools.j2ssh.io.*;
import java.io.IOException;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;

public class SshAgentRandom extends SubsystemMessage {

  public static final int SSH_AGENT_RANDOM = 213;

  private int length;

  public SshAgentRandom() {
    super(SSH_AGENT_RANDOM);
  }

  public SshAgentRandom(int length) {
    super(SSH_AGENT_RANDOM);
    this.length = length;
  }

  public int getLength() {
    return length;
  }

  public String getMessageName() {
    return "SSH_AGENT_RANDOM";
  }

  public void constructByteArray(ByteArrayWriter baw) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      baw.writeInt(length);
    } catch(IOException ioe) {
      throw new InvalidMessageException(ioe.getMessage());
    }
  }
  public void constructMessage(ByteArrayReader bar) throws java.io.IOException, com.sshtools.j2ssh.transport.InvalidMessageException {
    try {
      length = (int)bar.readInt();
    } catch(IOException ioe) {
      throw new InvalidMessageException(ioe.getMessage());
    }

  }
}