/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.configuration;

public class VFSPermission {
    private boolean canRead;
    private boolean canWrite;
    private boolean canExecute;
    private String name;

    public VFSPermission(String name, String permissions) {
        this.name = name;
        setPermissions(permissions);
    }

    public VFSPermission(String name) {
        this.name = name;
        setPermissions("rwx");
    }

    public String getName() {
        return name;
    }

    public void setPermissions(String permissions) {
        canRead = false;
        canWrite = false;
        canExecute = false;

        for (int i = 0; i < permissions.length(); i++) {
            switch (permissions.charAt(i)) {
            case 'r': {
                canRead = true;

                break;
            }

            case 'w': {
                canWrite = true;

                break;
            }

            case 'x': {
                canExecute = true;

                break;
            }
            }
        }
    }

    public String getPermissions() {
        return (canRead ? "r" : "") + (canWrite ? "w" : "")
        + (canExecute ? "x" : "");
    }

    public boolean verifyPermissions(String permissions) {
        String tmp = getPermissions();
        String ch;

        for (int i = 0; i < permissions.length(); i++) {
            ch = permissions.substring(i, 1);

            if (tmp.indexOf(ch) == -1) {
                return false;
            }
        }

        return true;
    }

    public boolean canRead() {
        return canRead;
    }

    public boolean canWrite() {
        return canWrite;
    }

    public boolean canExecute() {
        return canExecute;
    }
}
