/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;

import com.sshtools.j2ssh.transport.InvalidMessageException;

import java.io.IOException;


public abstract class SubsystemMessage {
    private int type;

    public SubsystemMessage(int type) {
        this.type = type;
    }

    public abstract String getMessageName();

    public int getMessageType() {
        return type;
    }

    public abstract void constructByteArray(ByteArrayWriter baw)
        throws InvalidMessageException, IOException;

    public abstract void constructMessage(ByteArrayReader bar)
        throws InvalidMessageException, IOException;

    public void fromByteArray(byte[] data) throws InvalidMessageException {
        try {
            ByteArrayReader bar = new ByteArrayReader(data);

            if (bar.available() > 0) {
                type = bar.read();
                constructMessage(bar);
            } else {
                throw new InvalidMessageException(
                    "Not enough message data to complete the message");
            }
        } catch (IOException ioe) {
            throw new InvalidMessageException(
                "The message data cannot be read!");
        }
    }

    public byte[] toByteArray() throws InvalidMessageException {
        try {
            ByteArrayWriter baw = new ByteArrayWriter();
            baw.write(type);
            constructByteArray(baw);

            return baw.toByteArray();
        } catch (IOException ioe) {
            throw new InvalidMessageException(
                "The message data cannot be written!");
        }
    }
}
