/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;


public class ConsoleHostKeyVerification extends AbstractHostKeyVerification {
    public ConsoleHostKeyVerification() throws InvalidHostFileException {
        super();
    }

    public ConsoleHostKeyVerification(String hostFile)
        throws InvalidHostFileException {
        super(hostFile);
    }

    public void onDeniedHost(String hostname) {
        System.out.println("Access to the host " + hostname
            + " is denied from this system");
    }

    public void onHostKeyMismatch(String host, String fingerprint, String actual) {
        try {
            System.out.println("The host key supplied by " + host + " is: "
                + actual);
            System.out.println("The current allowed key for " + host + " is: "
                + fingerprint);
            getResponse(host, actual);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onUnknownHost(String host, String fingerprint) {
        try {
            System.out.println("The host " + host
                + " is currently unknown to the system");
            System.out.println("The host key fingerprint is: " + fingerprint);
            getResponse(host, fingerprint);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getResponse(String host, String fingerprint)
        throws InvalidHostFileException, IOException {
        String response = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(
                    System.in));

        while (!(response.equalsIgnoreCase("YES")
                || response.equalsIgnoreCase("NO")
                || (response.equalsIgnoreCase("ALWAYS")
                && isHostFileWriteable()))) {
            String options = (isHostFileWriteable() ? "Yes|No|Always" : "Yes|No");

            if (!isHostFileWriteable()) {
                System.out.println(
                    "Always option disabled, host file is not writeable");
            }

            System.out.print("Do you want to allow this host key? [" + options
                + "]: ");

            response = reader.readLine();
        }

        if (response.equalsIgnoreCase("YES")) {
            allowHost(host, fingerprint, false);
        }

        if (response.equalsIgnoreCase("NO")) {
            System.out.println("Cannot continue without a valid host key");
            System.exit(1);
        }

        if (response.equalsIgnoreCase("ALWAYS") && isHostFileWriteable()) {
            allowHost(host, fingerprint, true);
        }
    }
}
