/*
 *  Sshtools - Java SSH2 API
 *
 *  Copyright (C) 2002 Lee David Painter.
 *
 *  Written by: 2002 Lee David Painter <lee@sshtools.com>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.TransportProtocol;

import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;

import java.io.IOException;

import java.math.BigInteger;


public abstract class SshKeyExchange { //implements Runnable {

    protected BigInteger secret;
    protected SshMessageStore messageStore = new SshMessageStore();
    protected byte[] exchangeHash;
    protected byte[] hostKey;
    protected byte[] signature;
    protected TransportProtocol transport;

    public SshKeyExchange() {
    }

    public byte[] getExchangeHash() {
        return exchangeHash;
    }

    public byte[] getHostKey() {
        return hostKey;
    }

    public BigInteger getSecret() {
        return secret;
    }

    public byte[] getSignature() {
        return signature;
    }

    public void init(TransportProtocol transport) throws IOException {
        this.transport = transport;
        onInit();
        transport.addMessageStore(messageStore);
    }

    protected abstract void onInit();

    public abstract void performClientExchange(String clientId,
        String serverId, byte[] clientKexInit, byte[] serverKexInit)
        throws IOException;

    public abstract void performServerExchange(String clientId,
        String serverId, byte[] clientKexInit, byte[] serverKexInit,
        SshPrivateKey prvkey) throws IOException;

    public void reset() {
        exchangeHash = null;
        hostKey = null;
        signature = null;
        secret = null;
    }
}
