/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.AboutAction;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.util.PropertyUtil;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplicationApplet
extends JApplet {
    public static final String[][] PARAMETER_INFO = new String[][]{{"sshapps.log.file", "string", "Logging output destination. Defaults to @console@"}, {"sshapps.log.level", "string", "Logging level. DEBUG,FATAL,ERROR,WARN,INFO,DEBUG or OFF. Defaults to OFF"}, {"sshapps.ui.informationPanel.background", "hex color", "Set the background color of the 'information panel'"}, {"sshapps.ui.informationPanel.foreground", "boolean", "Set the foreground color of the 'information panel'"}, {"sshapps.ui.informationPanel.borderColor", "boolean", "Set the border color of the 'information panel'"}, {"sshapps.ui.informationPanel.borderThickness", "integer", "Set the border thickness of the 'information panel'"}, {"sshapps.ui.toolBar", "boolean", "Enable / Disable the tool bar"}, {"sshapps.ui.menuBar", "boolean", "Enable / Disable the menu bar"}, {"sshapps.ui.disabledActions", "string", "Comma (,) separated list of disable actions"}, {"sshapps.ui.statusBar", "boolean", "Enable / Disable the menu bar"}};
    protected Log log = LogFactory.getLog(class$com$sshtools$common$ui$SshToolsApplicationApplet == null ? (class$com$sshtools$common$ui$SshToolsApplicationApplet = SshToolsApplicationApplet.class$("com.sshtools.common.ui.SshToolsApplicationApplet")) : class$com$sshtools$common$ui$SshToolsApplicationApplet);
    protected LoadingPanel loadingPanel;
    protected JSeparator toolSeparator;
    protected SshToolsApplicationPanel applicationPanel;
    protected Color infoForeground;
    protected int infoBorderThickness;
    protected boolean toolBar;
    protected boolean menuBar;
    protected boolean statusBar;
    protected Color infoBackground;
    protected Color infoBorderColor;
    protected String disabledActions;
    static /* synthetic */ Class class$com$sshtools$common$ui$SshToolsApplicationApplet;

    public String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        return string3 != null ? string3 : string2;
    }

    public void init() {
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        SshToolsApplicationApplet.this.getContentPane().setLayout(new BorderLayout());
                        SshToolsApplicationApplet.this.loadingPanel = new LoadingPanel();
                        SshToolsApplicationApplet.this.setAppletComponent(SshToolsApplicationApplet.this.loadingPanel);
                        SshToolsApplicationApplet.this.initApplet();
                        JComponent jComponent = SshToolsApplicationApplet.this.buildAppletComponent();
                        SshToolsApplicationApplet.this.startApplet();
                        SshToolsApplicationApplet.this.setAppletComponent(jComponent);
                    }
                    catch (Throwable throwable) {
                        SshToolsApplicationApplet.this.seriousAppletError(throwable);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
        catch (Throwable throwable) {
            this.seriousAppletError(throwable);
        }
    }

    public void initApplet() throws IOException {
        ConfigurationLoader.initialize(false);
        this.infoBackground = PropertyUtil.stringToColor(this.getParameter("sshapps.ui.informationPanel.background", PropertyUtil.colorToString(new Color(255, 255, 204))));
        this.infoForeground = PropertyUtil.stringToColor(this.getParameter("sshapps.ui.informationPanel.foreground", PropertyUtil.colorToString(Color.black)));
        this.infoBorderColor = PropertyUtil.stringToColor(this.getParameter("sshapps.ui.informationPanel.borderColor", PropertyUtil.colorToString(Color.black)));
        this.infoBorderThickness = PropertyUtil.stringToInt(this.getParameter("sshapps.ui.informationPanel.borderThickness", "1"), 1);
        this.toolBar = this.getParameter("sshapps.ui.toolBar", "true").equalsIgnoreCase("true");
        this.menuBar = this.getParameter("sshapps.ui.menuBar", "true").equalsIgnoreCase("true");
        this.statusBar = this.getParameter("sshapps.ui.statusBar", "true").equalsIgnoreCase("true");
        this.disabledActions = this.getParameter("sshapps.ui.disabledActions", "");
    }

    public void startApplet() {
    }

    public JComponent buildAppletComponent() throws IOException, SshToolsApplicationException {
        Object object;
        this.loadingPanel.setStatus("Creating application");
        this.applicationPanel = this.createApplicationPanel();
        this.loadingPanel.setStatus("Building action components");
        this.applicationPanel.rebuildActionComponents();
        this.log.debug("Disabled actions list = " + this.disabledActions);
        StringTokenizer stringTokenizer = new StringTokenizer(this.disabledActions == null ? "" : this.disabledActions, ",");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            this.log.debug("Disable " + (String)object);
            this.applicationPanel.setActionVisible((String)object, false);
        }
        object = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this.applicationPanel.getJMenuBar() != null) {
            jPanel.add((Component)this.applicationPanel.getJMenuBar(), "North");
            this.log.debug("Setting menu bar visibility to " + this.menuBar);
            this.applicationPanel.setMenuBarVisible(this.menuBar);
        }
        if (this.applicationPanel.getToolBar() != null) {
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.applicationPanel.getToolBar(), "North");
            this.applicationPanel.setToolBarVisible(this.toolBar);
            this.toolSeparator = new JSeparator(0);
            jPanel2.add((Component)this.toolSeparator, "South");
            this.toolSeparator.setVisible(this.applicationPanel.getToolBar().isVisible());
            final SshToolsApplicationPanel sshToolsApplicationPanel = this.applicationPanel;
            this.applicationPanel.getToolBar().addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent componentEvent) {
                    SshToolsApplicationApplet.this.toolSeparator.setVisible(sshToolsApplicationPanel.getToolBar().isVisible());
                }
            });
            jPanel.add((Component)jPanel2, "South");
        }
        ((Container)object).add((Component)jPanel, "North");
        ((Container)object).add((Component)this.applicationPanel, "Center");
        if (this.applicationPanel.getStatusBar() != null) {
            ((Container)object).add((Component)this.applicationPanel.getStatusBar(), "South");
            this.applicationPanel.setStatusBarVisible(this.statusBar);
        }
        return object;
    }

    public void doAction(String string) {
        StandardAction standardAction = this.applicationPanel.getAction(string);
        if (standardAction != null) {
            if (standardAction.isEnabled()) {
                this.log.debug("Performing action " + standardAction.getName());
                standardAction.actionPerformed(new ActionEvent(this, 1001, standardAction.getActionCommand()));
            } else {
                this.log.warn("No performing action '" + standardAction.getName() + "' because it is disabled.");
            }
        } else {
            this.log.error("No action named " + string);
        }
    }

    public abstract SshToolsApplicationPanel createApplicationPanel() throws SshToolsApplicationException;

    protected void setAppletComponent(JComponent jComponent) {
        if (this.getContentPane().getComponentCount() > 0) {
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
        }
        this.getContentPane().add((Component)jComponent, "Center");
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    protected void seriousAppletError(Throwable throwable) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><p>A serious error has occured ...</p><br>");
        stringBuffer.append("<p><font size=\"-1\" color=\"#ff0000\"><b>");
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        StringTokenizer stringTokenizer = new StringTokenizer(stringWriter.toString(), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            stringBuffer.append((String)object);
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append("<br>");
        }
        stringBuffer.append("</b></font></p><html>");
        object = new SshToolsApplicationAppletPanel();
        ((Container)object).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints.fill = 0;
        UIUtil.jGridBagAdd((JComponent)object, new JLabel(stringBuffer.toString()), gridBagConstraints, 0);
        this.setAppletComponent((JComponent)object);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String[][] getParameterInfo() {
        return PARAMETER_INFO;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LoadingPanel
    extends SshToolsApplicationAppletPanel {
        private JProgressBar bar;

        LoadingPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 8, 0);
            gridBagConstraints.fill = 0;
            UIUtil.jGridBagAdd(this, new JLabel("Loading " + SshToolsApplicationApplet.this.getAppletInfo()), gridBagConstraints, 0);
            this.bar = new JProgressBar(0, 100);
            this.bar.setStringPainted(true);
            UIUtil.jGridBagAdd(this, this.bar, gridBagConstraints, 0);
        }

        public void setStatus(String string) {
            this.bar.setString(string);
        }
    }

    class SshToolsApplicationAppletPanel
    extends JPanel {
        SshToolsApplicationAppletPanel() {
            this.setOpaque(true);
            this.setBackground(SshToolsApplicationApplet.this.infoBackground);
            this.setForeground(SshToolsApplicationApplet.this.infoForeground);
            this.setBorder(BorderFactory.createLineBorder(SshToolsApplicationApplet.this.infoBorderColor, SshToolsApplicationApplet.this.infoBorderThickness));
        }
    }

    public class SshToolsApplicationAppletContainer
    extends JPanel
    implements SshToolsApplicationContainer {
        private SshToolsApplicationPanel panel;
        private SshToolsApplication application;

        public void init(SshToolsApplication sshToolsApplication, SshToolsApplicationPanel sshToolsApplicationPanel) throws SshToolsApplicationException {
            this.application = sshToolsApplication;
            this.panel = sshToolsApplicationPanel;
            sshToolsApplicationPanel.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Help", "Help", 104, 99));
            sshToolsApplicationPanel.registerAction(new AboutAction(this, sshToolsApplication));
            this.getApplicationPanel().rebuildActionComponents();
        }

        public void setContainerTitle(String string) {
            SshToolsApplicationApplet.this.getAppletContext().showStatus(string);
        }

        public SshToolsApplicationPanel getApplicationPanel() {
            return this.panel;
        }

        public void closeContainer() {
        }

        public void setContainerVisible(boolean bl) {
            this.setVisible(bl);
        }

        public boolean isContainerVisible() {
            return this.isVisible();
        }
    }
}

