/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthPKOK;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublicKeyAuthenticationClient
extends SshAuthenticationClient {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient == null ? (class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient = PublicKeyAuthenticationClient.class$("com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient")) : class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient);
    protected SshPrivateKey key;
    private String privateKeyFile = null;
    private String passphrase = null;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationClient;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPKOK;

    public void setKey(SshPrivateKey sshPrivateKey) {
        this.key = sshPrivateKey;
    }

    public void setKeyfile(String string) {
        this.privateKeyFile = string;
    }

    public String getKeyfile() {
        return this.privateKeyFile;
    }

    public void reset() {
        this.privateKeyFile = null;
        this.passphrase = null;
    }

    public String getMethodName() {
        return "publickey";
    }

    public boolean acceptsKey(AuthenticationProtocolClient authenticationProtocolClient, String string, String string2, SshPublicKey sshPublicKey) throws IOException {
        authenticationProtocolClient.registerMessage(class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPKOK == null ? (class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPKOK = PublicKeyAuthenticationClient.class$("com.sshtools.j2ssh.authentication.SshMsgUserAuthPKOK")) : class$com$sshtools$j2ssh$authentication$SshMsgUserAuthPKOK, 60);
        log.info("Determining if server can accept public key for authentication");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.write(0);
        byteArrayWriter.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
        SshMessage sshMessage = new SshMsgUserAuthRequest(string, string2, this.getMethodName(), byteArrayWriter.toByteArray());
        authenticationProtocolClient.sendMessage(sshMessage);
        try {
            sshMessage = authenticationProtocolClient.readMessage(60);
            if (sshMessage instanceof SshMsgUserAuthPKOK) {
                return true;
            }
            throw new IOException("Unexpected message returned from readMessage");
        }
        catch (TerminatedStateException terminatedStateException) {
            return false;
        }
    }

    public void authenticate(AuthenticationProtocolClient authenticationProtocolClient, String string) throws IOException, TerminatedStateException {
        if (this.getUsername() == null || this.key == null) {
            throw new AuthenticationProtocolException("You must supply a username and a key");
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        log.info("Generating data to sign");
        SshPublicKey sshPublicKey = this.key.getPublicKey();
        log.info("Preparing public key authentication request");
        byteArrayWriter.write(1);
        byteArrayWriter.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
        ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
        byteArrayWriter2.writeBinaryString(authenticationProtocolClient.getSessionIdentifier());
        byteArrayWriter2.write(50);
        byteArrayWriter2.writeString(this.getUsername());
        byteArrayWriter2.writeString(string);
        byteArrayWriter2.writeString(this.getMethodName());
        byteArrayWriter2.write(1);
        byteArrayWriter2.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter2.writeBinaryString(sshPublicKey.getEncoded());
        byteArrayWriter.writeBinaryString(this.key.generateSignature(byteArrayWriter2.toByteArray()));
        SshMsgUserAuthRequest sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), string, this.getMethodName(), byteArrayWriter.toByteArray());
        authenticationProtocolClient.sendMessage(sshMsgUserAuthRequest);
    }

    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        if (this.getUsername() != null) {
            properties.setProperty("Username", this.getUsername());
        }
        if (this.privateKeyFile != null) {
            properties.setProperty("PrivateKey", this.privateKeyFile);
        }
        return properties;
    }

    public void setPersistableProperties(Properties properties) {
        this.setUsername(properties.getProperty("Username"));
        if (properties.getProperty("PrivateKey") != null) {
            this.privateKeyFile = properties.getProperty("PrivateKey");
        }
        if (properties.getProperty("Passphrase") != null) {
            this.passphrase = properties.getProperty("Passphrase");
        }
    }

    public boolean canAuthenticate() {
        return this.getUsername() != null && this.key != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

