/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelInputStream;
import com.sshtools.j2ssh.connection.ChannelOutputStream;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessageStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class IOChannel
extends Channel {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$connection$IOChannel == null ? (class$com$sshtools$j2ssh$connection$IOChannel = IOChannel.class$("com.sshtools.j2ssh.connection.IOChannel")) : class$com$sshtools$j2ssh$connection$IOChannel);
    private SshMessageStore incoming = new SshMessageStore();
    protected ChannelInputStream in;
    protected ChannelOutputStream out;
    protected InputStream boundInputStream = null;
    protected OutputStream boundOutputStream = null;
    protected IOStreamConnector ios = null;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$IOChannel;

    protected void init(ConnectionProtocol connectionProtocol, long l, long l2, long l3, long l4) throws IOException {
        this.in = new ChannelInputStream(this.incoming);
        this.out = new ChannelOutputStream(this);
        super.init(connectionProtocol, l, l2, l3, l4);
    }

    protected void open() throws IOException {
        super.open();
        if (this.boundOutputStream != null) {
            this.sendOutstandingMessages();
        }
        if (this.boundInputStream != null && this.ios == null) {
            this.ios.setCloseInput(false);
            this.ios.setCloseOutput(false);
            this.ios.connect(this.boundInputStream, this.out);
        }
    }

    public ChannelInputStream getInputStream() {
        return this.in;
    }

    public ChannelOutputStream getOutputStream() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChannelData(SshMsgChannelData sshMsgChannelData) throws IOException {
        SshMessageStore sshMessageStore = this.incoming;
        synchronized (sshMessageStore) {
            if (this.boundOutputStream != null) {
                try {
                    this.boundOutputStream.write(sshMsgChannelData.getChannelData());
                }
                catch (IOException iOException) {
                    log.info("Could not route data to the bound OutputStream; Closing channel.");
                    log.info(iOException.getMessage());
                    this.close();
                }
            } else {
                this.incoming.addMessage(sshMsgChannelData);
            }
        }
    }

    public void setLocalEOF() throws IOException {
        super.setLocalEOF();
        if (!this.out.isClosed()) {
            this.out.close();
        }
    }

    protected void onChannelEOF() throws IOException {
        if (!this.in.isClosed()) {
            this.in.close();
        }
    }

    protected void onChannelClose() throws IOException {
        if (!this.in.isClosed()) {
            this.in.close();
        }
        if (!this.out.isClosed()) {
            this.out.close();
        }
        if (this.ios != null) {
            this.ios.close();
        }
    }

    protected void onChannelExtData(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindOutputStream(OutputStream outputStream) throws IOException {
        SshMessageStore sshMessageStore = this.incoming;
        synchronized (sshMessageStore) {
            this.boundOutputStream = outputStream;
            if (this.state.getValue() == 2) {
                this.sendOutstandingMessages();
            }
        }
    }

    public void bindInputStream(InputStream inputStream) throws IOException {
        this.boundInputStream = inputStream;
        this.ios = new IOStreamConnector();
        if (this.state.getValue() == 2) {
            this.ios.setCloseInput(false);
            this.ios.setCloseOutput(false);
            this.ios.connect(inputStream, this.out);
        }
    }

    private void sendOutstandingMessages() throws IOException {
        if (this.boundInputStream != null && this.boundOutputStream != null && this.incoming.hasMessages()) {
            block6: while (true) {
                try {
                    while (true) {
                        SshMsgChannelData sshMsgChannelData = (SshMsgChannelData)this.incoming.peekMessage(94);
                        this.incoming.removeMessage(sshMsgChannelData);
                        try {
                            this.boundOutputStream.write(sshMsgChannelData.getChannelData());
                            continue block6;
                        }
                        catch (IOException iOException) {
                            this.close();
                            continue;
                        }
                        break;
                    }
                }
                catch (MessageStoreEOFException messageStoreEOFException) {
                    break;
                }
                catch (MessageNotAvailableException messageNotAvailableException) {
                    break;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("The thread was interrupted");
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

