/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.CloseAction;
import com.sshtools.common.ui.ConnectionPropertiesAction;
import com.sshtools.common.ui.DataNotificationListener;
import com.sshtools.common.ui.Option;
import com.sshtools.common.ui.OptionsDialog;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.PrintPreview;
import com.sshtools.common.ui.RecordAction;
import com.sshtools.common.ui.RefreshAction;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsApplicationSessionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.StatusBar;
import com.sshtools.common.ui.StopAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventAdapter;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.sshterm.ClearAction;
import com.sshtools.sshterm.CopyAction;
import com.sshtools.sshterm.PasteAction;
import com.sshtools.sshterm.PlayAction;
import com.sshtools.sshterm.PrintAction;
import com.sshtools.sshterm.PrintPreviewAction;
import com.sshtools.sshterm.SshTermTerminalTab;
import com.sshtools.sshterm.emulation.TerminalEmulation;
import com.sshtools.sshterm.emulation.TerminalListener;
import com.sshtools.sshterm.emulation.TerminalPanel;
import java.awt.AWTEvent;
import java.awt.AWTPermission;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshTermSessionPanel
extends SshToolsApplicationSessionPanel
implements ActionListener,
ClipboardOwner,
TerminalListener,
MouseMotionListener {
    public static final String PREF_SHIFT_GEOMETRY = "sshterm.shift.geometry";
    public static final String PREF_PORT_FORWARDING_GEOMETRY = "sshterm.portForwarding.geometry";
    public static final String PREF_PORT_FORWARDING_DIVIDER_LOCATION = "sshterm.portForwarding.dividerLocation";
    public static final String PREF_PORT_FORWARDING_FORWARDS_TABLE_METRICS = "sshterm.portForwarding.forwards.tableMetrics";
    public static final String PREF_PORT_FORWARDING_ACTIVE_TABLE_METRICS = "sshterm.portForwarding.active.tableMetrics";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_X = "sshterm.pageFormat.imageable.x";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_Y = "sshterm.pageFormat.imageable.y";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_W = "sshterm.pageFormat.imageable.w";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_H = "sshterm.pageFormat.imageable.h";
    public static final String PREF_PAGE_FORMAT_SIZE_W = "sshterm.pageFormat.size.w";
    public static final String PREF_PAGE_FORMAT_SIZE_H = "sshterm.pageFormat.size.h";
    public static final String PREF_PAGE_FORMAT_ORIENTATION = "sshterm.pageFormat.orientation";
    public static final String PREF_X11_FORWARDING = "sshterm.xForwarding";
    public static final String PREF_X11_FORWARDING_LOCAL_DISPLAY = "sshterm.xForwarding.localDisplay";
    public static final String PREF_X11_FORWARDING_REMOTE_DISPLAY_NUMBER = "sshterm.xForwarding.remoteDisplayNumber";
    public static final String PREF_MOUSE_WHEEL_INCREMENT = "sshterm.mouseWheelIncrement";
    public static final String PROFILE_PROPERTY_TERMINAL = "TERM";
    public static final String PROFILE_PROPERTY_EOL = "EOL";
    public static final String PROFILE_PROPERTY_RESIZE_STRATEGY = "RESIZE_STRATEGY";
    public static final String PROFILE_PROPERTY_ANTIALIAS = "ANTIALIAS";
    public static final String PROFILE_PROPERTY_FONT_SIZE = "FONT_SIZE";
    public static final String PROFILE_PROPERTY_BACKGROUND_COLOR = "BACKGROUND_COLOR";
    public static final String PROFILE_PROPERTY_FOREGROUND_COLOR = "FOREGROUND_COLOR";
    public static final String PROFILE_PROPERTY_COLOR_PRINTING = "COLOR_PRINTING";
    private static final long VDU_EVENTS = 252L;
    static final String ABOUT_ICON = "/com/sshtools/sshterm/largessh.png";
    protected static Log log = LogFactory.getLog(class$com$sshtools$sshterm$SshTerminalPanel == null ? (class$com$sshtools$sshterm$SshTerminalPanel = SshTermSessionPanel.class$("com.sshtools.sshterm.SshTerminalPanel")) : class$com$sshtools$sshterm$SshTerminalPanel);
    public static final ResourceIcon MY3SP_TERMINAL_ICON = new ResourceIcon(class$com$sshtools$sshterm$SshTermSessionPanel == null ? (class$com$sshtools$sshterm$SshTermSessionPanel = SshTermSessionPanel.class$("com.sshtools.sshterm.SshTermSessionPanel")) : class$com$sshtools$sshterm$SshTermSessionPanel, "sshframeicon.gif");
    private JScrollBar scrollBar;
    private SessionChannelClient session;
    private int eol;
    private TerminalPanel terminal;
    private Vector actionMenus;
    protected TerminalEmulation emulation;
    private PrintPreviewAction printPreviewAction;
    private PrintAction printAction;
    private CloseAction closeAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private ClearAction clearAction;
    private RefreshAction refreshAction;
    private PlayAction playAction;
    private StopAction stopAction;
    private RecordAction recordAction;
    private PageFormat pageFormat;
    private ConnectionPropertiesAction connectionPropertiesAction;
    private JSeparator toolSeparator;
    JPanel contentPane;
    private OutputStream recordingOutputStream;
    private File recordingFile;
    private StatusBar statusBar;
    private DataNotificationListener dataListener;
    private TitledBorder titledBorder1;
    private BorderLayout borderLayout1 = new BorderLayout();
    private boolean anyHost = true;
    private boolean anyUser = true;
    private boolean anyPort = true;
    private boolean dialogActionsEnabled;
    private boolean fullScreenMode;
    private boolean autoHideTools;
    private SshToolsConnectionTab[] additionalTabs;
    private ChannelEventListener eventListener;
    static /* synthetic */ Class class$com$sshtools$sshterm$SshTerminalPanel;
    static /* synthetic */ Class class$com$sshtools$sshterm$SshTermSessionPanel;
    static /* synthetic */ Class class$com$sshtools$sshterm$SshTermFrame;
    static /* synthetic */ Class class$com$sshtools$sshterm$SshTermFullScreenWindowContainer;
    static /* synthetic */ Class class$java$awt$Window;

    public ResourceIcon getIcon() {
        return MY3SP_TERMINAL_ICON;
    }

    public String getId() {
        return "sshterm";
    }

    public void init(SshToolsApplication sshToolsApplication) throws SshToolsApplicationException {
        Object object;
        super.init(sshToolsApplication);
        this.additionalTabs = new SshToolsConnectionTab[]{new SshTermTerminalTab()};
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new RuntimePermission("queuePrintJob"));
            }
            try {
                object = PrinterJob.getPrinterJob();
                if (object == null) {
                    throw new IOException("Could not get print page format.");
                }
                this.pageFormat = ((PrinterJob)object).defaultPage();
                if (PreferencesStore.preferenceExists(PREF_PAGE_FORMAT_ORIENTATION)) {
                    this.pageFormat.setOrientation(PreferencesStore.getInt(PREF_PAGE_FORMAT_ORIENTATION, 0));
                    Paper paper = new Paper();
                    paper.setImageableArea(PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_X, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_Y, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_W, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_H, 0.0));
                    paper.setSize(PreferencesStore.getDouble(PREF_PAGE_FORMAT_SIZE_W, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_SIZE_H, 0.0));
                    this.pageFormat.setPaper(paper);
                }
            }
            catch (Exception exception) {
                this.showExceptionMessage("Error", exception.getMessage());
            }
        }
        catch (AccessControlException accessControlException) {
            accessControlException.printStackTrace();
        }
        this.enableEvents(252L);
        this.initActions();
        this.statusBar = new StatusBar();
        this.dataListener = new DataNotificationListener(this.statusBar);
        try {
            this.emulation = this.createEmulation();
        }
        catch (IOException iOException) {
            throw new SshToolsApplicationException(iOException);
        }
        this.emulation.addTerminalListener(this);
        this.scrollBar = new JScrollBar(1);
        this.emulation.setBufferSize(1000);
        this.terminal = new TerminalPanel(this.emulation){

            public void processEvent(AWTEvent aWTEvent) {
                if (aWTEvent instanceof MouseEvent && aWTEvent.getID() == 507) {
                    try {
                        Method method = aWTEvent.getClass().getMethod("getWheelRotation", new Class[0]);
                        SshTermSessionPanel.this.scrollBar.setValue(SshTermSessionPanel.this.scrollBar.getValue() + SshTermSessionPanel.this.scrollBar.getUnitIncrement() * (Integer)method.invoke((Object)aWTEvent, new Object[0]) * PreferencesStore.getInt(SshTermSessionPanel.PREF_MOUSE_WHEEL_INCREMENT, 1));
                    }
                    catch (Throwable throwable) {}
                } else {
                    super.processEvent(aWTEvent);
                }
            }
        };
        this.terminal.requestFocus();
        this.terminal.setScrollbar(this.scrollBar);
        this.terminal.addMouseMotionListener(this);
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBackground(Color.red);
        ((Container)object).add((Component)this.terminal, "Center");
        ((Container)object).add((Component)this.scrollBar, "East");
        this.terminal.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) > 0) {
                    SshTermSessionPanel.this.getContextMenu().setLabel(SshTermSessionPanel.this.getApplication().getApplicationName());
                    SshTermSessionPanel.this.getContextMenu().show(SshTermSessionPanel.this.terminal, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)object, "Center");
        this.terminal.requestFocus();
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public boolean requiresConfiguration() {
        return false;
    }

    public void addEventListener(ChannelEventListener channelEventListener) {
        this.eventListener = channelEventListener;
        if (this.session != null) {
            this.session.addEventListener(channelEventListener);
        }
    }

    public boolean setAutoHideTools(boolean bl) {
        if (this.autoHideTools != bl) {
            this.setToolBarVisible(!bl);
            this.setMenuBarVisible(!bl);
            this.setStatusBarVisible(!bl);
            this.setScrollBarVisible(!bl);
            this.autoHideTools = bl;
            return true;
        }
        return false;
    }

    public boolean isAutoHideTools() {
        return this.autoHideTools;
    }

    public boolean isScrollBarVisible() {
        return this.scrollBar != null && this.scrollBar.isVisible();
    }

    public void setScrollBarVisible(boolean bl) {
        if (this.scrollBar != null && this.scrollBar.isVisible() != bl) {
            this.scrollBar.setVisible(bl);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isAutoHideTools()) {
            if (!this.isToolsVisible() && mouseEvent.getY() < 4) {
                this.setToolsVisible(true);
            } else if (this.isToolsVisible() && mouseEvent.getY() > 12) {
                this.setToolsVisible(false);
            }
            if (!this.scrollBar.isVisible() && mouseEvent.getX() > this.getWidth() - 4) {
                this.setScrollBarVisible(true);
            } else if (this.scrollBar.isVisible() && mouseEvent.getX() < this.getWidth() - 12) {
                this.setScrollBarVisible(false);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void setFullScreenMode(boolean bl) {
        if (this.fullScreenMode != bl) {
            try {
                if (!bl) {
                    this.application.convertContainer(this.getContainer(), class$com$sshtools$sshterm$SshTermFrame == null ? (class$com$sshtools$sshterm$SshTermFrame = SshTermSessionPanel.class$("com.sshtools.sshterm.SshTermFrame")) : class$com$sshtools$sshterm$SshTermFrame);
                } else {
                    this.application.convertContainer(this.getContainer(), class$com$sshtools$sshterm$SshTermFullScreenWindowContainer == null ? (class$com$sshtools$sshterm$SshTermFullScreenWindowContainer = SshTermSessionPanel.class$("com.sshtools.sshterm.SshTermFullScreenWindowContainer")) : class$com$sshtools$sshterm$SshTermFullScreenWindowContainer);
                }
                this.requestFocus();
                this.fullScreenMode = bl;
            }
            catch (SshToolsApplicationException sshToolsApplicationException) {
                sshToolsApplicationException.printStackTrace();
                log.error(sshToolsApplicationException);
            }
            this.setAvailableActions();
        }
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public void requestFocus() {
        this.terminal.requestFocus();
    }

    public void registerAction(StandardAction standardAction) {
        super.registerAction(standardAction);
        standardAction.addActionListener(this);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void screenResized(int n, int n2) {
        try {
            if (this.session != null) {
                this.session.changeTerminalDimensions(this.emulation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setToolsVisible(boolean bl) {
        super.setToolsVisible(bl);
        this.setScrollBarVisible(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent var1_1) {
        block22: {
            var2_2 = var1_1.getActionCommand();
            if (this.stopAction != null && var2_2.equals(this.stopAction.getActionCommand())) {
                this.stopRecording();
            }
            if (this.recordAction != null && var2_2.equals(this.recordAction.getActionCommand())) {
                this.setFullScreenMode(false);
                var3_3 = new JFileChooser(System.getProperty("user.home"));
                var4_4 = var3_3.showSaveDialog(this);
                if (var4_4 == 0) {
                    this.recordingFile = var3_3.getSelectedFile();
                    if (this.recordingFile.exists() && JOptionPane.showConfirmDialog(this, "File exists. Are you sure?", "File exists", 0, 2) == 1) {
                        return;
                    }
                    try {
                        this.recordingOutputStream = new FileOutputStream(this.recordingFile);
                        this.statusBar.setStatusText("Recording to " + this.recordingFile.getName());
                        this.setAvailableActions();
                    }
                    catch (IOException var5_5) {
                        this.showExceptionMessage("Error", "Could not open file for recording\n\n" + var5_5.getMessage());
                    }
                }
            }
            if (this.playAction != null && var2_2.equals(this.playAction.getActionCommand())) {
                this.setFullScreenMode(false);
                var3_3 = new JFileChooser(System.getProperty("user.home"));
                var4_4 = var3_3.showOpenDialog(this);
                if (var4_4 == 0) {
                    var5_6 = var3_3.getSelectedFile();
                    var6_7 = null;
                    try {
                        this.statusBar.setStatusText("Playing from " + var5_6.getName());
                        var6_7 = new FileInputStream(var5_6);
                        var7_8 = null;
                        var8_10 = 0;
                        while ((var8_10 = var6_7.available()) != -1) {
                            if (var8_10 == 0) {
                                var8_10 = 1;
                            }
                            if ((var8_10 = var6_7.read(var7_8 = new byte[var8_10])) == -1) break;
                            this.emulation.getOutputStream().write(var7_8);
                        }
                        this.statusBar.setStatusText("Finished playing " + var5_6.getName());
                        this.setAvailableActions();
                        var10_11 = null;
                        ** if (var6_7 == null) goto lbl-1000
                    }
                    catch (Throwable var9_17) {
                        var10_13 = null;
                        if (var6_7 != null) {
                            try {
                                var6_7.close();
                            }
                            catch (IOException var11_16) {
                                SshTermSessionPanel.log.error(var11_16);
                            }
                        }
                        throw var9_17;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var6_7.close();
                        }
                        catch (IOException var11_14) {
                            SshTermSessionPanel.log.error(var11_14);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block22;
                        catch (IOException var7_9) {
                            this.statusBar.setStatusText("Error playing " + var5_6.getName());
                            this.showExceptionMessage("Error", "Could not open file for playback\n\n" + var7_9.getMessage());
                            var10_12 = null;
                            if (var6_7 != null) {
                                try {
                                    var6_7.close();
                                }
                                catch (IOException var11_15) {
                                    SshTermSessionPanel.log.error(var11_15);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.closeAction != null && var2_2.equals(this.closeAction.getActionCommand())) {
            this.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeSession() {
        block9: {
            if (this.recordingOutputStream != null) {
                this.stopRecording();
            }
            this.emulation.reset();
            try {
                block8: {
                    try {
                        if (this.session == null) break block8;
                        this.session.close();
                        this.session = null;
                    }
                    catch (IOException iOException) {
                        Object var3_2 = null;
                        if (this.manager.isConnected()) {
                            this.manager.requestDisconnect();
                        }
                        break block9;
                    }
                }
                Object var3_1 = null;
                if (this.manager.isConnected()) {
                    this.manager.requestDisconnect();
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.manager.isConnected()) {
                    this.manager.requestDisconnect();
                }
                throw throwable;
            }
        }
        this.setAvailableActions();
        this.statusBar.setStatusText("Closed");
        this.statusBar.setHost("");
        this.statusBar.setUser("");
        this.statusBar.setRemoteId("");
        this.statusBar.setConnected(false);
    }

    public void stopRecording() {
        try {
            this.recordingOutputStream.flush();
            this.recordingOutputStream.close();
            this.statusBar.setStatusText("Stopped recording to " + this.recordingFile.getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.recordingOutputStream = null;
        this.setAvailableActions();
    }

    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    public SshToolsConnectionTab[] getAdditionalConnectionTabs() {
        return this.additionalTabs;
    }

    public boolean canClose() {
        if (this.session != null && this.session.isOpen()) {
            this.setFullScreenMode(false);
            if (JOptionPane.showConfirmDialog(this, "Close the current session?", "Close Session", 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    public void printScreen() {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this.terminal, this.pageFormat);
            if (printerJob.printDialog()) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                printerJob.print();
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (PrinterException printerException) {
            JOptionPane.showMessageDialog(this, printerException.getMessage(), "Error", 0);
        }
    }

    public boolean onOpenSession() throws IOException {
        Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = SshTermSessionPanel.class$("java.awt.Window")) : class$java$awt$Window, this);
        if (window != null) {
            window.toFront();
        }
        this.terminal.requestFocus();
        SshToolsConnectionProfile sshToolsConnectionProfile = this.getCurrentConnectionProfile();
        this.setTerminalProperties(sshToolsConnectionProfile);
        this.statusBar.setStatusText("Connected");
        this.statusBar.setConnected(true);
        this.setContainerTitle(null);
        if (this.eol == 0) {
            if (this.manager.getRemoteEOL() == 1) {
                this.emulation.setEOL(1);
            } else {
                this.emulation.setEOL(2);
            }
        }
        if (sshToolsConnectionProfile.getOnceAuthenticatedCommand() != 1) {
            if (sshToolsConnectionProfile.getOnceAuthenticatedCommand() == 3) {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(sshToolsConnectionProfile.getCommandsToExecute() + "\n"));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.trim().length() <= 0) continue;
                    log.info("Executing " + string);
                    this.session = this.createNewSession(false);
                    if (!this.session.executeCommand(string)) continue;
                    this.session.bindInputStream(this.emulation.getTerminalInputStream());
                    this.session.bindOutputStream(this.emulation.getTerminalOutputStream());
                    try {
                        this.session.getState().waitForState(3);
                    }
                    catch (InterruptedException interruptedException) {
                        JOptionPane.showMessageDialog(this, "The command was interrupted!", "Interrupted Exception", 0);
                    }
                }
            } else {
                this.session = this.createNewSession(true);
                if (this.session.startShell()) {
                    this.session.bindInputStream(this.emulation.getTerminalInputStream());
                    this.session.bindOutputStream(this.emulation.getTerminalOutputStream());
                }
            }
        }
        this.setAvailableActions();
        return true;
    }

    private SessionChannelClient createNewSession(boolean bl) throws IOException {
        SessionChannelClient sessionChannelClient = this.manager.openSession();
        sessionChannelClient.addEventListener(this.dataListener);
        if (this.eventListener != null) {
            sessionChannelClient.addEventListener(this.eventListener);
        }
        if (bl) {
            sessionChannelClient.addEventListener(new ChannelEventAdapter(){

                public void onChannelClose(Channel channel) {
                    SshTermSessionPanel.this.closeSession();
                }
            });
        }
        if (this.getCurrentConnectionProfile().getAllowAgentForwarding() && !sessionChannelClient.requestAgentForwarding()) {
            JOptionPane.showMessageDialog(this, "The server failed to open an agent listener", "Allow Agent Forwarding", 0, (Icon)UIManager.get("OptionPane.informationIcon"));
        }
        if (this.getCurrentConnectionProfile().requiresPseudoTerminal() && !sessionChannelClient.requestPseudoTerminal(this.emulation)) {
            JOptionPane.showMessageDialog(this, "The server refused to allocate a pseudo terminal!", "Request Pseudo Terminal", 0);
        }
        return sessionChannelClient;
    }

    private void setTerminalProperties(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.eol = sshToolsConnectionProfile.getApplicationPropertyInt(PROFILE_PROPERTY_EOL, 0);
        if (this.eol != 0) {
            this.emulation.setEOL(this.eol);
        }
        this.emulation.setTerminalType(sshToolsConnectionProfile.getApplicationProperty(PROFILE_PROPERTY_TERMINAL, "vt100"));
        this.terminal.setBackground(sshToolsConnectionProfile.getApplicationPropertyColor(PROFILE_PROPERTY_BACKGROUND_COLOR, Color.black));
        this.terminal.setForeground(sshToolsConnectionProfile.getApplicationPropertyColor(PROFILE_PROPERTY_FOREGROUND_COLOR, Color.white));
        this.terminal.setColorPrinting(sshToolsConnectionProfile.getApplicationPropertyBoolean(PROFILE_PROPERTY_COLOR_PRINTING, false));
        this.terminal.setAntialias(sshToolsConnectionProfile.getApplicationPropertyBoolean(PROFILE_PROPERTY_ANTIALIAS, false));
        int n = sshToolsConnectionProfile.getApplicationPropertyInt(PROFILE_PROPERTY_RESIZE_STRATEGY, 2);
        this.terminal.setResizeStrategy(n);
        if (n == 2) {
            this.terminal.setFont(this.terminal.getFont().deriveFont((float)sshToolsConnectionProfile.getApplicationPropertyInt(PROFILE_PROPERTY_FONT_SIZE, 12)));
        }
    }

    private void initActions() {
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Edit", "Edit", 101, 10));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("View", "View", 118, 20));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Help", "Help", 104, 90));
        this.actions = new Vector();
        this.connectionPropertiesAction = new ConnectionPropertiesActionImpl();
        this.registerAction(this.connectionPropertiesAction);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            this.playAction = new PlayAction();
            this.registerAction(this.playAction);
        }
        catch (AccessControlException accessControlException) {
            log.warn("File reading actions are not available");
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            this.recordAction = new RecordAction();
            this.registerAction(this.recordAction);
            this.stopAction = new StopAction();
            this.registerAction(this.stopAction);
        }
        catch (AccessControlException accessControlException) {
            log.warn("File write actions are not available");
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
        }
        catch (AccessControlException accessControlException) {
            log.warn("Read / write actions are not available");
        }
        if (this.pageFormat != null) {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new RuntimePermission("queuePrintJob"));
                }
                this.printAction = new PrintActionImpl();
                this.registerAction(this.printAction);
                this.printPreviewAction = new PrintPreviewActionImpl();
                this.registerAction(this.printPreviewAction);
            }
            catch (AccessControlException accessControlException) {
                log.warn("Print actions are not available");
            }
        }
        this.refreshAction = new RefreshActionImpl();
        this.registerAction(this.refreshAction);
        this.closeAction = new CloseAction();
        this.registerAction(this.closeAction);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new AWTPermission("accessClipboard"));
            }
            this.copyAction = new CopyActionImpl();
            this.registerAction(this.copyAction);
            this.pasteAction = new PasteActionImpl();
            this.registerAction(this.pasteAction);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
        }
        catch (AccessControlException accessControlException) {
            log.warn("Keygen actions is not available");
        }
        this.clearAction = new ClearActionImpl();
        this.registerAction(this.clearAction);
        this.deregisterAction(this.getAction("Options"));
        this.setActionVisible("New Window", false);
        this.setActionVisible("About", false);
    }

    public void setDialogActionsEnabled(boolean bl) {
        this.dialogActionsEnabled = bl;
        this.setAvailableActions();
    }

    public void setAvailableActions() {
        boolean bl = this.isConnected();
        if (this.connectionPropertiesAction != null) {
            this.connectionPropertiesAction.setEnabled(bl);
        }
        if (this.closeAction != null) {
            this.closeAction.setEnabled(bl);
        }
        if (this.recordAction != null) {
            this.recordAction.setEnabled(bl && this.recordingOutputStream == null);
        }
        if (this.recordAction != null) {
            this.playAction.setEnabled(bl);
        }
        if (this.recordAction != null) {
            this.stopAction.setEnabled(this.recordingOutputStream != null);
        }
    }

    private TerminalEmulation createEmulation() throws IOException {
        return new TerminalEmulation("vt320");
    }

    public void showExceptionMessage(String string, String string2) {
        this.setFullScreenMode(false);
        super.showExceptionMessage(string, string2);
    }

    public void close() {
        if (this.pageFormat != null) {
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_X, this.pageFormat.getImageableX());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_Y, this.pageFormat.getImageableY());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_W, this.pageFormat.getImageableWidth());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_H, this.pageFormat.getImageableHeight());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_SIZE_W, this.pageFormat.getWidth());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_SIZE_H, this.pageFormat.getHeight());
            PreferencesStore.putInt(PREF_PAGE_FORMAT_ORIENTATION, this.pageFormat.getOrientation());
        }
        if (this.isConnected()) {
            this.closeSession();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RefreshActionImpl
    extends RefreshAction {
        RefreshActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(20));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SshTermSessionPanel.this.emulation.update[0] = true;
            SshTermSessionPanel.this.terminal.redraw();
        }
    }

    public class ClearActionImpl
    extends ClearAction {
        ClearActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(20));
            this.putValue("contextMenuWeight", new Integer(0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SshTermSessionPanel.this.emulation.clearScreen();
            SshTermSessionPanel.this.emulation.setCursorPosition(0, 0);
            SshTermSessionPanel.this.terminal.refresh();
        }
    }

    public class PasteActionImpl
    extends PasteAction {
        PasteActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(10));
            this.putValue("contextMenuWeight", new Integer(10));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(SshTermSessionPanel.this);
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    SshTermSessionPanel.this.emulation.getOutputStream().write(transferable.getTransferData(DataFlavor.stringFlavor).toString().getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class CopyActionImpl
    extends CopyAction {
        CopyActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(10));
            this.putValue("contextMenuWeight", new Integer(0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(SshTermSessionPanel.this.terminal.getSelection()), SshTermSessionPanel.this);
        }
    }

    public class ConnectionPropertiesActionImpl
    extends ConnectionPropertiesAction {
        public ConnectionPropertiesActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(45));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SshTermSessionPanel.this.editSettings(SshTermSessionPanel.this.getCurrentConnectionProfile())) {
                SshTermSessionPanel.this.setTerminalProperties(SshTermSessionPanel.this.getCurrentConnectionProfile());
            }
        }
    }

    public class PrintActionImpl
    extends PrintAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SshTermSessionPanel.this.printScreen();
        }
    }

    public class PrintPreviewActionImpl
    extends PrintPreviewAction {
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreview printPreview = new PrintPreview(SshTermSessionPanel.this.terminal, SshTermSessionPanel.this.pageFormat);
            Option option = new Option("Print", "Print the screen", 112);
            Option option2 = new Option("Close", "Close this dialog", 99);
            OptionsDialog optionsDialog = OptionsDialog.createOptionDialog(SshTermSessionPanel.this, new Option[]{option, option2}, printPreview, "Print Preview", option2, null, null);
            optionsDialog.pack();
            UIUtil.positionComponent(0, optionsDialog);
            optionsDialog.setVisible(true);
            if (optionsDialog.getSelectedOption() == option) {
                SshTermSessionPanel.this.printScreen();
            }
        }
    }
}

