/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class SessionRecorder {
    protected FileOutputStream f;
    protected DataOutputStream df;
    protected long startTime;
    protected long lastTimeOffset;
    protected byte[] buffer;
    protected int bufferSize;
    protected int bufferBytes;

    public SessionRecorder(String string, int n) throws IOException {
        this.f = new FileOutputStream(string);
        this.df = new DataOutputStream(this.f);
        this.startTime = System.currentTimeMillis();
        this.lastTimeOffset = 0L;
        this.bufferSize = n;
        this.bufferBytes = 0;
        this.buffer = new byte[this.bufferSize];
    }

    public SessionRecorder(String string) throws IOException {
        this(string, 65536);
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.df = null;
        this.f.close();
        this.f = null;
        this.buffer = null;
    }

    public void writeHeader() throws IOException {
        this.df.write("FBS 001.000\n".getBytes());
    }

    public void writeByte(int n) throws IOException {
        this.prepareWriting();
        this.buffer[this.bufferBytes++] = (byte)n;
    }

    public void writeShortBE(int n) throws IOException {
        this.prepareWriting();
        this.buffer[this.bufferBytes++] = (byte)(n >> 8);
        this.buffer[this.bufferBytes++] = (byte)n;
    }

    public void writeIntBE(int n) throws IOException {
        this.prepareWriting();
        this.buffer[this.bufferBytes] = (byte)(n >> 24);
        this.buffer[this.bufferBytes + 1] = (byte)(n >> 16);
        this.buffer[this.bufferBytes + 2] = (byte)(n >> 8);
        this.buffer[this.bufferBytes + 3] = (byte)n;
        this.bufferBytes += 4;
    }

    public void writeShortLE(int n) throws IOException {
        this.prepareWriting();
        this.buffer[this.bufferBytes++] = (byte)n;
        this.buffer[this.bufferBytes++] = (byte)(n >> 8);
    }

    public void writeIntLE(int n) throws IOException {
        this.prepareWriting();
        this.buffer[this.bufferBytes] = (byte)n;
        this.buffer[this.bufferBytes + 1] = (byte)(n >> 8);
        this.buffer[this.bufferBytes + 2] = (byte)(n >> 16);
        this.buffer[this.bufferBytes + 3] = (byte)(n >> 24);
        this.bufferBytes += 4;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.prepareWriting();
        while (n2 > 0) {
            if (this.bufferBytes > this.bufferSize - 4) {
                this.flush(false);
            }
            int n3 = this.bufferBytes + n2 > this.bufferSize ? this.bufferSize - this.bufferBytes : n2;
            System.arraycopy(byArray, n, this.buffer, this.bufferBytes, n3);
            this.bufferBytes += n3;
            n += n3;
            n2 -= n3;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void flush(boolean bl) throws IOException {
        if (this.bufferBytes > 0) {
            this.df.writeInt(this.bufferBytes);
            this.df.write(this.buffer, 0, this.bufferBytes + 3 & 0x7FFFFFFC);
            this.df.writeInt((int)this.lastTimeOffset);
            this.bufferBytes = 0;
            if (bl) {
                this.lastTimeOffset = -1L;
            }
        }
    }

    public void flush() throws IOException {
        this.flush(true);
    }

    protected void prepareWriting() throws IOException {
        if (this.lastTimeOffset == -1L) {
            this.lastTimeOffset = System.currentTimeMillis() - this.startTime;
        }
        if (this.bufferBytes > this.bufferSize - 4) {
            this.flush(false);
        }
    }
}

