/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.sshvnc.AuthenticationFrame;
import com.sshtools.sshvnc.ClipboardFrame;
import com.sshtools.sshvnc.DesCipher;
import com.sshtools.sshvnc.HexASCII;
import com.sshtools.sshvnc.RfbProto;
import com.sshtools.sshvnc.SshVNCOptions;
import com.sshtools.sshvnc.VncCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SshVNCViewer
extends JPanel {
    private String[] mainArgs;
    private RfbProto rfb;
    private JScrollPane desktopScrollPane;
    private GridBagLayout gridbag;
    private VncCanvas vc;
    private ClipboardFrame clipboard;
    private boolean protocolInitialised;
    private Object recordingSync;
    private String sessionFileName;
    private boolean recordingActive;
    private boolean recordingStatusChanged;
    private String cursorUpdatesDef;
    private String eightBitColorsDef;
    private String socketFactory;
    private boolean showOfflineDesktop;
    private int deferScreenUpdates;
    private int deferCursorUpdates;
    private int deferUpdateRequests;
    private SshToolsApplicationPanel application;
    private SshVNCOptions options;
    private SshVNCOptions oldOptions;
    private AuthenticationFrame authFrame;
    private boolean frameResizeable = true;
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public SshVNCViewer() {
        this.showWelcomeScreen();
    }

    public boolean init(InputStream inputStream, OutputStream outputStream, SshToolsApplicationPanel sshToolsApplicationPanel, SshVNCOptions sshVNCOptions) throws Exception {
        this.options = sshVNCOptions;
        this.application = sshToolsApplicationPanel;
        this.recordingSync = new Object();
        Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = SshVNCViewer.class$("java.awt.Window")) : class$java$awt$Window, this);
        this.clipboard = window instanceof JFrame ? new ClipboardFrame((Frame)((JFrame)window), this) : (window instanceof JDialog ? new ClipboardFrame((Dialog)((JDialog)window), this) : new ClipboardFrame(this));
        this.sessionFileName = null;
        this.recordingActive = false;
        this.recordingStatusChanged = false;
        this.cursorUpdatesDef = null;
        this.eightBitColorsDef = null;
        this.application = sshToolsApplicationPanel;
        this.gridbag = new GridBagLayout();
        this.removeAll();
        this.setLayout(this.gridbag);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        try {
            if (!this.connectAndAuthenticate(inputStream, outputStream)) {
                sshToolsApplicationPanel.getStatusBar().setStatusText("Failed to authenticate with VNC server");
                this.closeConnection();
                return false;
            }
            sshToolsApplicationPanel.getStatusBar().setStatusText("Initialising VNC protocol");
            this.doProtocolInitialisation();
            this.vc = new VncCanvas(this);
            if (sshVNCOptions.isRequestCursorUpdates() && !sshVNCOptions.isIgnoreCursorUpdates()) {
                try {
                    BufferedImage bufferedImage = new BufferedImage(1, 1, 6);
                    if (bufferedImage != null) {
                        Cursor cursor = this.getToolkit().createCustomCursor(bufferedImage, new Point(0, 0), "Dot");
                        this.vc.setCursor(cursor);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.gridbag.setConstraints(this.vc, gridBagConstraints);
            this.desktopScrollPane = new JScrollPane(this.vc);
            this.desktopScrollPane.setBorder(null);
            gridBagConstraints.fill = 1;
            this.gridbag.setConstraints(this.desktopScrollPane, gridBagConstraints);
            this.add(this.desktopScrollPane);
            this.validate();
            this.vc.resizeDesktopFrame();
            sshToolsApplicationPanel.getStatusBar().setStatusText("Connected");
            this.vc.processNormalProtocol();
            return true;
        }
        catch (Exception exception) {
            this.closeConnection();
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showWelcomeScreen() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.removeAll();
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(Color.black);
            jPanel.setForeground(Color.white);
            JLabel jLabel = new JLabel("SSHVnc", 0);
            jLabel.setForeground(Color.white);
            jLabel.setFont(jLabel.getFont().deriveFont(72.0f).deriveFont(3));
            jPanel.add((Component)jLabel, "Center");
            this.add((Component)jPanel, "Center");
            this.validate();
        }
    }

    public boolean isFrameResizeable() {
        return this.frameResizeable;
    }

    public void setFrameResizeable(boolean bl) {
        this.frameResizeable = bl;
    }

    public void setClipboardVisible(boolean bl) {
        if (this.clipboard != null) {
            this.clipboard.setVisible(bl);
        }
    }

    public int getScreenSizePolicy() {
        return this.options.getScreenSizePolicy();
    }

    public boolean isClipboardVisible() {
        return this.clipboard != null && this.clipboard.isVisible();
    }

    public void closeConnection() {
        this.protocolInitialised = false;
        if (this.vc != null) {
            this.vc.enableInput(false);
            this.vc.setCursor(Cursor.getDefaultCursor());
        }
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        System.out.println("Disconnect");
        if (this.rfb != null && !this.rfb.closed()) {
            this.rfb.close();
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        if (this.recordingActive) {
            this.setRecordingStatus(null);
            try {
                this.stopRecording();
            }
            catch (IOException iOException) {
                System.err.println("Could not stop recording sesion.");
                iOException.printStackTrace();
            }
        }
        this.showWelcomeScreen();
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public RfbProto getRFB() {
        return this.rfb;
    }

    public SshVNCOptions getOptions() {
        return this.options;
    }

    public int getDeferCursorUpdates() {
        return this.deferCursorUpdates;
    }

    public int getDeferUpdateRequests() {
        return this.deferUpdateRequests;
    }

    public int getDeferScreenUpdates() {
        return this.deferUpdateRequests;
    }

    public ClipboardFrame getClipboard() {
        return this.clipboard;
    }

    public VncCanvas getVNCCanvas() {
        return this.vc;
    }

    public JFrame getFrame() {
        return (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SshVNCViewer.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
    }

    public JScrollPane getScroller() {
        return this.desktopScrollPane;
    }

    private boolean connectAndAuthenticate(InputStream inputStream, OutputStream outputStream) throws Exception {
        this.protocolInitialised = false;
        if (this.authFrame == null) {
            Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = SshVNCViewer.class$("java.awt.Window")) : class$java$awt$Window, this);
            this.authFrame = window instanceof JFrame ? new AuthenticationFrame((JFrame)window) : (window instanceof JDialog ? new AuthenticationFrame((JDialog)window) : new AuthenticationFrame());
            UIUtil.positionComponent(0, this.authFrame);
        }
        this.rfb = new RfbProto(inputStream, outputStream, this);
        this.rfb.readVersionMsg();
        System.out.println("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
        this.rfb.writeVersionMsg();
        int n = this.rfb.readAuthScheme();
        System.out.println("Got auth scheme " + n);
        block9: while (true) {
            switch (n) {
                case 1: {
                    return true;
                }
                case 2: {
                    int n2;
                    Object object;
                    Object[] objectArray;
                    String string = "";
                    String string2 = this.options.getEncryptedPassword();
                    if (!string2.equals("")) {
                        objectArray = HexASCII.ToByteArray(string2);
                        byte[] byArray = new byte[]{23, 82, 107, 6, 35, 78, 88, 7};
                        object = new DesCipher(byArray);
                        ((DesCipher)object).decrypt((byte[])objectArray, 0, (byte[])objectArray, 0);
                        string = new String((byte[])objectArray);
                    } else {
                        objectArray = this.authFrame.doAuthentication();
                        if (objectArray == null) {
                            return false;
                        }
                        string = new String((char[])objectArray);
                    }
                    objectArray = new byte[16];
                    this.rfb.is.readFully((byte[])objectArray);
                    if (string.length() > 8) {
                        string = string.substring(0, 8);
                    }
                    if ((n2 = string.indexOf(0)) != -1) {
                        string = string.substring(0, n2);
                    }
                    object = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                    System.arraycopy(string.getBytes(), 0, object, 0, string.length());
                    DesCipher desCipher = new DesCipher((byte[])object);
                    desCipher.encrypt((byte[])objectArray, 0, (byte[])objectArray, 0);
                    desCipher.encrypt((byte[])objectArray, 8, (byte[])objectArray, 8);
                    this.rfb.os.write((byte[])objectArray);
                    int n3 = this.rfb.is.readInt();
                    switch (n3) {
                        case 0: {
                            return true;
                        }
                        case 1: {
                            continue block9;
                        }
                        case 2: {
                            throw new Exception("VNC authentication failed - too many tries");
                        }
                    }
                    throw new Exception("Unknown VNC authentication result " + n3);
                }
            }
            break;
        }
        throw new Exception("Unknown VNC authentication scheme " + n);
    }

    public boolean isProtocolInitialised() {
        return this.protocolInitialised;
    }

    void doProtocolInitialisation() throws IOException {
        this.rfb.writeClientInit();
        this.protocolInitialised = true;
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
    }

    void setEncodings() {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeSetEncodings(this.options.getEncodings(), this.options.getNumberOfEncodings());
                if (this.vc != null) {
                    this.vc.softCursorFree();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setCutText(String string) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRecordingStatus(String string) {
        Object object = this.recordingSync;
        synchronized (object) {
            this.sessionFileName = string;
            this.recordingStatusChanged = true;
        }
    }

    public String getRecordingStatus() {
        return this.sessionFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkRecordingStatus() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingStatusChanged) {
                this.recordingStatusChanged = false;
                if (this.sessionFileName != null) {
                    this.startRecording();
                    boolean bl = true;
                    return bl;
                }
                this.stopRecording();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (!this.recordingActive) {
                try {
                    this.oldOptions = (SshVNCOptions)this.options.clone();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.options.setEightBitColors(false);
                this.options.setRequestCursorUpdates(false);
                this.options.setEncodings();
                this.setEncodings();
            } else {
                this.rfb.closeSession();
            }
            System.out.println("Recording the session in " + this.sessionFileName);
            this.rfb.startSession(this.sessionFileName);
            this.recordingActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRecording() throws IOException {
        Object object = this.recordingSync;
        synchronized (object) {
            if (this.recordingActive) {
                this.options = this.oldOptions;
                this.setEncodings();
                this.rfb.closeSession();
                System.out.println("Session recording stopped.");
            }
            this.sessionFileName = null;
            this.recordingActive = false;
        }
    }

    public void refresh() throws IOException {
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
    }

    public void sendCtrlAltDel() throws IOException {
        KeyEvent keyEvent = new KeyEvent(this, 401, 0L, 10, 127, '\uffff');
        this.getRFB().writeKeyEvent(keyEvent);
        keyEvent = new KeyEvent(this, 402, 0L, 10, 127, '\uffff');
        this.getRFB().writeKeyEvent(keyEvent);
    }

    void moveFocusToDesktop() {
        if (this.vc != null && this.isAncestorOf(this.vc)) {
            this.vc.requestFocus();
        }
    }

    public synchronized void fatalError(String string, Exception exception) {
        if (this.rfb != null) {
            if (this.rfb.closed()) {
                return;
            }
            this.rfb.close();
        }
        SshToolsApplicationPanel.showErrorMessage(this, string, "VNC Error", exception);
    }

    void showMessage(String string) {
        this.removeAll();
        Label label = new Label(string, 1);
        label.setFont(new Font("Helvetica", 0, 12));
        this.setLayout(new FlowLayout(0, 30, 30));
        this.add(label);
        this.validate();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AuthenticationDialog
    extends JDialog {
        AuthenticationDialog() {
        }
    }
}

