/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.ui.CloseAction;
import com.sshtools.common.ui.ConnectionPropertiesAction;
import com.sshtools.common.ui.DataNotificationListener;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.RefreshAction;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsApplicationSessionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.StatusBar;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.IOChannel;
import com.sshtools.j2ssh.forwarding.ForwardingChannel;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingIOChannel;
import com.sshtools.j2ssh.forwarding.XDisplay;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.sshterm.emulation.TerminalEmulation;
import com.sshtools.sshterm.emulation.TerminalPanel;
import com.sshtools.sshvnc.ClipboardAction;
import com.sshtools.sshvnc.CtrlAltDelAction;
import com.sshtools.sshvnc.SshVNCOptions;
import com.sshtools.sshvnc.SshVNCViewer;
import com.sshtools.sshvnc.VNCAdvancedTab;
import com.sshtools.sshvnc.VNCTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshVncSessionPanel
extends SshToolsApplicationSessionPanel
implements ActionListener {
    public static final String PROFILE_PROPERTY_VNC_HOST = "VNC_HOST";
    public static final String PROFILE_PROPERTY_VNC_DISPLAY = "VNC_DISPLAY";
    public static final String PROFILE_PROPERTY_PREFERRED_ENCODING = "PREFERRED_ENCODING";
    public static final String PROFILE_PROPERTY_USE_COPY_RECT = "USE_COPY_RECT";
    public static final String PROFILE_PROPERTY_COMPRESS_LEVEL = "COMPRESS_LEVEL";
    public static final String PROFILE_PRE_VNC_COMMAND = "PRE_VNC_COMMAND";
    public static final String PROFILE_POST_VNC_COMMAND = "POST_VNC_COMMAND";
    public static final String PROFILE_PROPERTY_JPEG_QUALITY = "JPEG_QUALITY";
    public static final String PROFILE_PROPERTY_CURSOR_UPDATES = "CURSOR_UPDATES";
    public static final String PROFILE_PROPERTY_EIGHT_BIT_COLORS = "EIGHT_BIT_COLORS";
    public static final String PROFILE_PROPERTY_REVERSE_MOUSE_BUTTONS_2_AND_3 = "REVERSE_MOUSE_BUTTONS_2_AND_3";
    public static final String PROFILE_PROPERTY_SHARE_DESKTOP = "SHARE_DESKTOP";
    public static final String PROFILE_PROPERTY_VIEW_ONLY = "VIEW_ONLY";
    protected static Log log = LogFactory.getLog(class$com$sshtools$sshvnc$SshVNC == null ? (class$com$sshtools$sshvnc$SshVNC = SshVncSessionPanel.class$("com.sshtools.sshvnc.SshVNC")) : class$com$sshtools$sshvnc$SshVNC);
    private static boolean debug = true;
    public static final ResourceIcon MY3SP_VNC_ICON = new ResourceIcon(class$com$sshtools$sshvnc$SshVncSessionPanel == null ? (class$com$sshtools$sshvnc$SshVncSessionPanel = SshVncSessionPanel.class$("com.sshtools.sshvnc.SshVncSessionPanel")) : class$com$sshtools$sshvnc$SshVncSessionPanel, "sshvncframeicon.gif");
    private boolean closing = false;
    private SshVNCViewer vnc;
    private StandardAction closeAction;
    private StandardAction refreshAction;
    private StandardAction clipboardAction;
    private StandardAction ctrlAltDelAction;
    private StandardAction recordAction;
    private StandardAction stopAction;
    private Thread rfbThread;
    private JFileChooser recordingFileChooser;
    private VNCTab vncTab;
    private StatusBar statusBar;
    private Timer sendTimer;
    private Timer receiveTimer;
    private SessionChannelClient sessionCloserSession;
    private TerminalPanel terminal;
    protected TerminalEmulation emulation;
    private boolean fullScreenMode;
    private SshToolsConnectionTab[] additionalTabs;
    private ConnectionPropertiesAction connectionPropertiesAction;
    private VncThread vncThread;
    protected SshClient ssh;
    private ChannelEventListener eventListener;
    static /* synthetic */ Class class$com$sshtools$sshvnc$SshVNC;
    static /* synthetic */ Class class$com$sshtools$sshvnc$SshVncSessionPanel;
    static /* synthetic */ Class class$com$sshtools$sshvnc$SshVncFullScreenWindowContainer;

    public void init(SshToolsApplication sshToolsApplication) throws SshToolsApplicationException {
        super.init(sshToolsApplication);
        this.setLayout(new BorderLayout());
        this.sendTimer = new Timer(500, this);
        this.sendTimer.setRepeats(false);
        this.receiveTimer = new Timer(500, this);
        this.receiveTimer.setRepeats(false);
        this.statusBar = new StatusBar();
        this.statusBar.setUser("");
        this.statusBar.setHost("");
        this.statusBar.setStatusText("Disconnected");
        this.statusBar.setConnected(false);
        this.setLayout(new BorderLayout());
        try {
            this.emulation = this.createEmulation();
        }
        catch (IOException iOException) {
            throw new SshToolsApplicationException(iOException);
        }
        this.emulation.setBufferSize(1000);
        this.terminal = new TerminalPanel(this.emulation);
        this.terminal.requestFocus();
        try {
            this.vnc = new SshVNCViewer();
            this.additionalTabs = new SshToolsConnectionTab[]{new VNCTab(), new VNCAdvancedTab()};
            this.add((Component)this.vnc, "Center");
            this.initActions();
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(UIManager.getIcon("OptionPane.errorIcon"), new ErrorTextBox((throwable.getMessage() == null ? "<no message supplied>" : throwable.getMessage()) + (debug ? "\n\n" + stringWriter.getBuffer().toString() : "")));
            iconWrapperPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.add((Component)iconWrapperPanel, "Center");
            throw new SshToolsApplicationException("Failed to start SshVNC. ", throwable);
        }
    }

    public ResourceIcon getIcon() {
        return MY3SP_VNC_ICON;
    }

    public String getId() {
        return "sshvnc";
    }

    public void addEventListener(ChannelEventListener channelEventListener) {
        this.eventListener = channelEventListener;
        if (this.vncThread != null) {
            this.vncThread.getChannel().addEventListener(channelEventListener);
        }
    }

    public SshToolsConnectionTab[] getAdditionalConnectionTabs() {
        return this.additionalTabs;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.receiveTimer) {
            this.statusBar.setReceiving(false);
        } else if (actionEvent.getSource() == this.sendTimer) {
            this.statusBar.setSending(false);
        }
    }

    public boolean requiresConfiguration() {
        return true;
    }

    public void setFrameResizeable(boolean bl) {
        this.vnc.setFrameResizeable(bl);
    }

    public void opened(ForwardingConfiguration forwardingConfiguration, ForwardingChannel forwardingChannel) {
    }

    public void closed(ForwardingConfiguration forwardingConfiguration, ForwardingChannel forwardingChannel) {
    }

    public void dataReceived(ForwardingConfiguration forwardingConfiguration, ForwardingChannel forwardingChannel, int n) {
        if (!this.receiveTimer.isRunning()) {
            this.statusBar.setReceiving(true);
            this.receiveTimer.start();
        }
    }

    public void setFullScreenMode(boolean bl) {
        if (this.fullScreenMode != bl) {
            try {
                if (!bl) {
                    this.application.convertContainer(this.getContainer(), class$com$sshtools$sshvnc$SshVncSessionPanel == null ? (class$com$sshtools$sshvnc$SshVncSessionPanel = SshVncSessionPanel.class$("com.sshtools.sshvnc.SshVncSessionPanel")) : class$com$sshtools$sshvnc$SshVncSessionPanel);
                } else {
                    this.application.convertContainer(this.getContainer(), class$com$sshtools$sshvnc$SshVncFullScreenWindowContainer == null ? (class$com$sshtools$sshvnc$SshVncFullScreenWindowContainer = SshVncSessionPanel.class$("com.sshtools.sshvnc.SshVncFullScreenWindowContainer")) : class$com$sshtools$sshvnc$SshVncFullScreenWindowContainer);
                }
                this.requestFocus();
                this.fullScreenMode = bl;
            }
            catch (SshToolsApplicationException sshToolsApplicationException) {
                sshToolsApplicationException.printStackTrace();
                log.error(sshToolsApplicationException);
            }
            this.setAvailableActions();
        }
    }

    public void dataSent(ForwardingConfiguration forwardingConfiguration, ForwardingChannel forwardingChannel, int n) {
        if (!this.sendTimer.isRunning()) {
            this.statusBar.setSending(true);
            this.sendTimer.start();
        }
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void initVNC(InputStream inputStream, OutputStream outputStream, SshVNCOptions sshVNCOptions) {
        log.info("Initialising VNC");
        try {
            this.vnc.init(inputStream, outputStream, this, sshVNCOptions);
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeVNC() {
        this.vnc.closeConnection();
    }

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void closeConnection(boolean bl) {
        block8: {
            this.closing = true;
            this.closeVNC();
            try {
                String string = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_POST_VNC_COMMAND, null);
                if (string == null || string.trim().length() <= 0 || !this.manager.isConnected()) break block8;
                this.statusBar.setStatusText("Executing command: " + string);
                this.remove(this.vnc);
                this.add((Component)this.terminal, "Center");
                this.emulation.reset();
                this.emulation.clearScreen();
                this.emulation.setCursorPosition(0, 0);
                this.terminal.refresh();
                log.debug("Executing post VNC command " + string);
                this.sessionCloserSession.requestPseudoTerminal("vt100", 80, 24, 0, 0, "");
                if (this.sessionCloserSession.executeCommand(string)) {
                    this.sessionCloserSession.bindInputStream(this.emulation.getTerminalInputStream());
                    this.sessionCloserSession.bindOutputStream(this.emulation.getTerminalOutputStream());
                }
                try {
                    try {
                        this.sessionCloserSession.getState().waitForState(3);
                    }
                    catch (InterruptedException interruptedException) {
                        Object var5_5 = null;
                        this.remove(this.terminal);
                        this.add((Component)this.vnc, "Center");
                        break block8;
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.remove(this.terminal);
                    this.add((Component)this.vnc, "Center");
                    throw throwable;
                }
                this.remove(this.terminal);
                this.add((Component)this.vnc, "Center");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.manager.isConnected()) {
            this.manager.requestDisconnect();
        }
        this.statusBar.setUser("");
        this.statusBar.setHost("");
        this.statusBar.setStatusText("Closed");
        this.statusBar.setConnected(false);
        this.setAvailableActions();
        this.closing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onOpenSession() throws IOException {
        Object object;
        Object object2;
        XDisplay xDisplay;
        int n;
        block9: {
            this.statusBar.setStatusText("User Authenticated");
            n = 0;
            String string = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PROPERTY_VNC_HOST, "localhost");
            String string2 = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PROPERTY_VNC_DISPLAY, "5900");
            xDisplay = new XDisplay(string + ":" + string2, 5900);
            String string3 = this.getCurrentConnectionProfile().getApplicationProperty(PROFILE_PRE_VNC_COMMAND, null);
            if (string3 != null && string3.trim().length() > 0) {
                this.statusBar.setStatusText("Executing command: " + string3);
                this.remove(this.vnc);
                this.add((Component)this.terminal, "Center");
                this.emulation.reset();
                this.emulation.clearScreen();
                this.emulation.setCursorPosition(0, 0);
                this.terminal.refresh();
                log.debug("Executing pre VNC command " + string3);
                object2 = this.manager.openSession();
                this.sessionCloserSession = this.manager.openSession();
                ((SessionChannelClient)object2).requestPseudoTerminal("vt100", 80, 24, 0, 0, "");
                if (((SessionChannelClient)object2).executeCommand(string3)) {
                    object = new IOStreamConnector(((SessionChannelClient)object2).getStderrInputStream(), this.emulation.getTerminalOutputStream());
                    ((IOChannel)object2).bindInputStream(this.emulation.getTerminalInputStream());
                    ((IOChannel)object2).bindOutputStream(this.emulation.getTerminalOutputStream());
                }
                try {
                    try {
                        ((Channel)object2).getState().waitForState(3);
                    }
                    catch (InterruptedException interruptedException) {
                        Object var10_10 = null;
                        this.remove(this.terminal);
                        this.add((Component)this.vnc, "Center");
                        break block9;
                    }
                    Object var10_9 = null;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    this.remove(this.terminal);
                    this.add((Component)this.vnc, "Center");
                    throw throwable;
                }
                this.remove(this.terminal);
                this.add((Component)this.vnc, "Center");
            }
        }
        this.statusBar.setStatusText("Setting up VNC forwarding");
        if (log.isDebugEnabled()) {
            log.debug("Setting up forwarding on 0.0.0.0 (" + n + ") to " + xDisplay.getHost() + ":" + xDisplay.getPort());
        }
        object2 = new SshVNCOptions(this.getCurrentConnectionProfile());
        this.statusBar.setStatusText("Initialising VNC");
        object = new ForwardingIOChannel("direct-tcpip", "VNC", xDisplay.getHost(), xDisplay.getPort(), "0.0.0.0", xDisplay.getPort());
        if (!this.manager.openChannel((Channel)object)) {
            this.closeConnection(true);
            throw new IOException("Could not connect to the vnc server");
        }
        ((Channel)object).addEventListener(new DataNotificationListener(this.statusBar));
        if (this.eventListener != null) {
            ((Channel)object).addEventListener(this.eventListener);
        }
        this.vncThread = new VncThread((ForwardingIOChannel)object);
        this.vncThread.start();
        this.setAvailableActions();
        return true;
    }

    private void initActions() {
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Edit", "Edit", 101, 10));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("View", "View", 118, 20));
        this.vncTab = new VNCTab();
        this.closeAction = new VncCloseAction();
        this.registerAction(this.closeAction);
        this.refreshAction = new VncRefreshAction();
        this.registerAction(this.refreshAction);
        this.ctrlAltDelAction = new VncCtrlAltDelAction();
        this.registerAction(this.ctrlAltDelAction);
        this.clipboardAction = new VncClipboardAction();
        this.registerAction(this.clipboardAction);
        this.connectionPropertiesAction = new VncConnectionPropertiesAction();
        this.registerAction(this.connectionPropertiesAction);
        this.deregisterAction(this.getAction("Options"));
        this.setActionVisible("New Window", false);
        this.setActionVisible("About", false);
    }

    private void startRecording() {
    }

    private void stopRecording() {
    }

    public void refresh() {
        try {
            this.vnc.refresh();
        }
        catch (IOException iOException) {
            this.closeConnection(true);
            SshToolsApplicationPanel.showErrorMessage(this, "Error", iOException);
        }
    }

    public void setAvailableActions() {
        boolean bl = this.isConnected();
        this.closeAction.setEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.ctrlAltDelAction.setEnabled(bl);
        this.clipboardAction.setEnabled(bl);
        String string = this.vnc.getRecordingStatus();
        this.closeAction.setEnabled(bl);
    }

    public void close() {
        this.closeConnection(true);
    }

    private TerminalEmulation createEmulation() throws IOException {
        return new TerminalEmulation("vt320");
    }

    public boolean canClose() {
        return !this.isConnected() || JOptionPane.showConfirmDialog(this, "Close the current session and exit?", "Exit Application", 0, 3) != 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class DisplayErrorMessage
    implements Runnable {
        public void run() {
            JOptionPane.showMessageDialog(SshVncSessionPanel.this, "SSHVnc failed to open a forwarding channel", "SSHVnc", 0);
        }
    }

    public class VncThread
    extends SshThread {
        ForwardingIOChannel channel;

        public VncThread(ForwardingIOChannel forwardingIOChannel) {
            super("VNC", false);
            this.channel = forwardingIOChannel;
        }

        public Channel getChannel() {
            return this.channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block6: {
                boolean bl = false;
                String string = SshVncSessionPanel.this.getCurrentConnectionProfile().getApplicationProperty(SshVncSessionPanel.PROFILE_PROPERTY_VNC_HOST, "localhost");
                String string2 = SshVncSessionPanel.this.getCurrentConnectionProfile().getApplicationProperty(SshVncSessionPanel.PROFILE_PROPERTY_VNC_DISPLAY, "5900");
                XDisplay xDisplay = new XDisplay(string + ":" + string2, 5900);
                String string3 = SshVncSessionPanel.this.getCurrentConnectionProfile().getApplicationProperty(SshVncSessionPanel.PROFILE_PRE_VNC_COMMAND, null);
                if (string3 != null && string3.trim().length() > 0) {
                    try {
                        try {
                            SshVncSessionPanel.this.statusBar.setStatusText("Executing command: " + string3);
                            SshVncSessionPanel.this.remove(SshVncSessionPanel.this.vnc);
                            SshVncSessionPanel.this.add((Component)SshVncSessionPanel.this.terminal, "Center");
                            SshVncSessionPanel.this.emulation.reset();
                            SshVncSessionPanel.this.emulation.clearScreen();
                            SshVncSessionPanel.this.emulation.setCursorPosition(0, 0);
                            SshVncSessionPanel.this.terminal.refresh();
                            log.debug("Executing pre VNC command" + string3);
                            SessionChannelClient sessionChannelClient = SshVncSessionPanel.this.ssh.openSessionChannel();
                            sessionChannelClient.requestPseudoTerminal("vt100", 80, 24, 0, 0, "");
                            if (sessionChannelClient.executeCommand(string3)) {
                                sessionChannelClient.bindInputStream(SshVncSessionPanel.this.emulation.getTerminalInputStream());
                                sessionChannelClient.bindOutputStream(SshVncSessionPanel.this.emulation.getTerminalOutputStream());
                            }
                            sessionChannelClient.getState().waitForState(3);
                        }
                        catch (Exception exception) {
                            Object var9_9 = null;
                            SshVncSessionPanel.this.remove(SshVncSessionPanel.this.terminal);
                            SshVncSessionPanel.this.add((Component)SshVncSessionPanel.this.vnc, "Center");
                            break block6;
                        }
                        Object var9_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        SshVncSessionPanel.this.remove(SshVncSessionPanel.this.terminal);
                        SshVncSessionPanel.this.add((Component)SshVncSessionPanel.this.vnc, "Center");
                        throw throwable;
                    }
                    SshVncSessionPanel.this.remove(SshVncSessionPanel.this.terminal);
                    SshVncSessionPanel.this.add((Component)SshVncSessionPanel.this.vnc, "Center");
                }
            }
            SshVncSessionPanel.this.initVNC(this.channel.getInputStream(), this.channel.getOutputStream(), new SshVNCOptions(SshVncSessionPanel.this.getCurrentConnectionProfile()));
        }
    }

    public class VncConnectionPropertiesAction
    extends ConnectionPropertiesAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SshVncSessionPanel.this.editSettings(SshVncSessionPanel.this.getCurrentConnectionProfile());
        }
    }

    public class VncClipboardAction
    extends ClipboardAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SshVncSessionPanel.this.vnc.setClipboardVisible(!SshVncSessionPanel.this.vnc.isClipboardVisible());
        }
    }

    public class VncCtrlAltDelAction
    extends CtrlAltDelAction {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                SshVncSessionPanel.this.vnc.sendCtrlAltDel();
            }
            catch (IOException iOException) {
                SshVncSessionPanel.this.closeConnection(true);
                SshToolsApplicationPanel.showErrorMessage(SshVncSessionPanel.this, "Error", iOException);
            }
        }
    }

    public class VncRefreshAction
    extends RefreshAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SshVncSessionPanel.this.refresh();
        }
    }

    public class VncCloseAction
    extends CloseAction {
        public void actionPerformed(ActionEvent actionEvent) {
            SshVncSessionPanel.this.closeConnection(true);
        }
    }

    public class IOConnector
    extends Thread {
        InputStream in;
        OutputStream out;

        public IOConnector(InputStream inputStream, OutputStream outputStream) {
            super("IOConnector");
            this.in = inputStream;
            this.out = outputStream;
            this.start();
        }

        public void run() {
            IOStreamConnector iOStreamConnector = new IOStreamConnector(this.in, this.out);
        }
    }

    public class ErrorTextBox
    extends JTextArea {
        public ErrorTextBox(String string) {
            super(string);
            this.setOpaque(false);
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
            this.setEditable(false);
        }
    }
}

