/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VNCTab
extends JPanel
implements SshToolsConnectionTab,
ActionListener {
    static final String DEFAULT = "<Default>";
    static final ResourceIcon vncIcon = new ResourceIcon(class$com$sshtools$sshvnc$VNCTab == null ? (class$com$sshtools$sshvnc$VNCTab = VNCTab.class$("com.sshtools.sshvnc.VNCTab")) : class$com$sshtools$sshvnc$VNCTab, "largevnc.png");
    static final String DEFAULT_HOST = "localhost";
    static final String DEFAULT_DISPLAY = "5900";
    protected SshToolsConnectionProfile profile;
    protected XTextField vncHost;
    protected JTextField startCommand;
    protected JTextField stopCommand;
    protected JRadioButton nix;
    protected JRadioButton windows;
    protected ButtonGroup group;
    protected JLabel display;
    protected NumericTextField port;
    protected JCheckBox jChkScreenSize;
    static /* synthetic */ Class class$com$sshtools$sshvnc$VNCTab;

    public VNCTab() {
        Insets insets = new Insets(2, 24, 2, 2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("The VNC server I want to connect to is a"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = insets;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weightx = 0.0;
        this.windows = new JRadioButton("Windows/Macintosh");
        UIUtil.jGridBagAdd(jPanel2, this.windows, gridBagConstraints2, -1);
        this.nix = new JRadioButton("Linux/Unix Variant");
        UIUtil.jGridBagAdd(jPanel2, this.nix, gridBagConstraints2, -1);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Or manually specify the SSH forwarding settings"));
        gridBagConstraints.insets = new Insets(2, 16, 2, 2);
        UIUtil.jGridBagAdd(jPanel3, new JLabel("Host "), gridBagConstraints, -1);
        this.vncHost = new XTextField(15);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        UIUtil.jGridBagAdd(jPanel3, this.vncHost, gridBagConstraints, 0);
        gridBagConstraints.insets = new Insets(2, 16, 2, 2);
        this.display = new JLabel("Display ");
        UIUtil.jGridBagAdd(jPanel3, this.display, gridBagConstraints, -1);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        this.port = new NumericTextField(new Integer(0), new Integer(65535), new Integer(1));
        UIUtil.jGridBagAdd(jPanel3, this.port, gridBagConstraints, 0);
        this.group = new ButtonGroup();
        this.group.add(this.nix);
        this.group.add(this.windows);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                VNCTab.this.display.setText(VNCTab.this.windows.isSelected() ? "Port    " : "Display ");
                VNCTab.this.port.setValue(VNCTab.this.windows.isSelected() ? new Integer(5900) : new Integer(1));
            }
        };
        this.nix.addChangeListener(changeListener);
        this.windows.addChangeListener(changeListener);
        this.nix.setSelected(true);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder("You may enter commands to start/stop your VNC server"));
        gridBagConstraints.insets = new Insets(2, 16, 2, 2);
        UIUtil.jGridBagAdd(jPanel4, new JLabel("Start VNC Command"), gridBagConstraints, -1);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        this.startCommand = new JTextField();
        UIUtil.jGridBagAdd(jPanel4, this.startCommand, gridBagConstraints, 0);
        gridBagConstraints.insets = new Insets(2, 16, 2, 2);
        UIUtil.jGridBagAdd(jPanel4, new JLabel("Stop VNC Command"), gridBagConstraints, -1);
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        this.stopCommand = new JTextField();
        UIUtil.jGridBagAdd(jPanel4, this.stopCommand, gridBagConstraints, 0);
        gridBagConstraints.insets = new Insets(2, 16, 2, 2);
        this.jChkScreenSize = new JCheckBox("Resize window to fit remote screen");
        UIUtil.jGridBagAdd(jPanel4, this.jChkScreenSize, gridBagConstraints, 0);
        Box box = new Box(1);
        box.add(jPanel2);
        box.add(jPanel3);
        box.add(jPanel4);
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(vncIcon, box);
        this.setLayout(new BorderLayout());
        this.add((Component)iconWrapperPanel, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setConnectionProfile(null);
    }

    public void setConnectionProfile(SshToolsConnectionProfile sshToolsConnectionProfile) {
        int n;
        this.profile = sshToolsConnectionProfile;
        String string = sshToolsConnectionProfile == null ? "" : sshToolsConnectionProfile.getApplicationProperty("VNC_HOST", "");
        String string2 = sshToolsConnectionProfile == null ? "" : sshToolsConnectionProfile.getApplicationProperty("VNC_DISPLAY", "");
        int n2 = n = sshToolsConnectionProfile == null ? 0 : sshToolsConnectionProfile.getApplicationPropertyInt("VNC_SERVER_OS", 0);
        if (n == 0) {
            this.windows.setSelected(true);
        } else {
            this.nix.setSelected(true);
        }
        if (string.equals("") || string2.equals("")) {
            string = DEFAULT_HOST;
            string2 = DEFAULT_DISPLAY;
        }
        this.port.setText(string2);
        this.vncHost.setText(string);
        if (sshToolsConnectionProfile != null) {
            this.startCommand.setText(sshToolsConnectionProfile.getApplicationProperty("PRE_VNC_COMMAND", ""));
            this.stopCommand.setText(sshToolsConnectionProfile.getApplicationProperty("POST_VNC_COMMAND", ""));
        }
        this.jChkScreenSize.setSelected(sshToolsConnectionProfile == null ? false : sshToolsConnectionProfile.getApplicationPropertyInt("VNC_SCREEN_SIZE", 0) == 1);
        this.setAvailableActions();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setAvailableActions();
    }

    private void setAvailableActions() {
    }

    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    public String getTabContext() {
        return "Connection";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "VNC Settings";
    }

    public String getTabToolTipText() {
        return "Here you can specify your VNC settings for this connection.  You can also enter commands to stop/start your remote VNC server here.";
    }

    public int getTabMnemonic() {
        return 118;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        this.profile.setApplicationProperty("sshvnc.configured", true);
        this.profile.setApplicationProperty("VNC_HOST", this.vncHost.getText().equals("") ? DEFAULT_HOST : this.vncHost.getText());
        this.profile.setApplicationProperty("VNC_DISPLAY", this.port.getText().equals("") ? DEFAULT_DISPLAY : this.port.getText());
        if (this.nix.isSelected()) {
            this.profile.setApplicationProperty("VNC_SERVER_OS", 1);
        } else if (this.windows.isSelected()) {
            this.profile.setApplicationProperty("VNC_SERVER_OS", 0);
        }
        this.profile.setApplicationProperty("PRE_VNC_COMMAND", this.startCommand.getText());
        this.profile.setApplicationProperty("POST_VNC_COMMAND", this.stopCommand.getText());
        this.profile.setApplicationProperty("VNC_SCREEN_SIZE", this.jChkScreenSize.isSelected() ? 1 : 0);
    }

    public void tabSelected() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

