/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.AuthorizedKeys;
import com.sshtools.common.automate.AuthorizedKeysFileLoader;
import com.sshtools.common.automate.AuthorizedKeysFileSaver;
import com.sshtools.common.automate.AuthorizedKeysFormat;
import com.sshtools.common.configuration.Authorization;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SshtoolsAuthorizedKeysFormat
implements AuthorizedKeysFormat {
    public byte[] format(AuthorizedKeys authorizedKeys) {
        throw new UnsupportedOperationException("SSHTools authorized keys format requries seperate key files!");
    }

    public AuthorizedKeys unformat(byte[] byArray) {
        throw new UnsupportedOperationException("SSHTools authorized keys format requries seperate key files!");
    }

    public byte[] format(AuthorizedKeys authorizedKeys, AuthorizedKeysFileSaver authorizedKeysFileSaver) throws IOException, InvalidSshKeyException {
        Authorization authorization = new Authorization();
        SECSHPublicKeyFormat sECSHPublicKeyFormat = new SECSHPublicKeyFormat();
        Iterator iterator = authorizedKeys.getAuthorizedKeys().entrySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getValue();
            String string2 = string + ".pub";
            sECSHPublicKeyFormat.setComment(string);
            SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.create((SshPublicKey)entry.getKey(), sECSHPublicKeyFormat);
            authorizedKeysFileSaver.saveFile(string2, sshPublicKeyFile.toString().getBytes("US-ASCII"));
            authorization.addKey(string2);
        }
        return authorization.toString().getBytes("US-ASCII");
    }

    public AuthorizedKeys unformat(byte[] byArray, AuthorizedKeysFileLoader authorizedKeysFileLoader) throws IOException, InvalidSshKeyException {
        try {
            AuthorizedKeys authorizedKeys = new AuthorizedKeys();
            Authorization authorization = new Authorization(new ByteArrayInputStream(byArray));
            List list = authorization.getAuthorizedKeys();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse(authorizedKeysFileLoader.loadFile(string));
                String string2 = string.substring(0, string.length() - 4);
                authorizedKeys.addKey(string2, sshPublicKeyFile.toPublicKey());
            }
            return authorizedKeys;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Failed to read authorization file: " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException("Failed to read authorization file: " + sAXException.getMessage());
        }
    }

    public boolean requiresKeyFiles() {
        return true;
    }
}

