/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration;

import com.sshtools.j2ssh.configuration.ConfigurationContext;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.compression.SshCompressionFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormatFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormatFactory;
import com.sshtools.j2ssh.util.ExtensionClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationLoader {
    private static Vector contexts = new Vector();
    private static SecureRandom rnd;
    private static ExtensionClassLoader ext;
    private static ClassLoader clsLoader;
    private static Log log;
    private static String homedir;
    private static boolean initialized;
    private static Object initializationLock;
    static /* synthetic */ Class class$com$sshtools$j2ssh$configuration$ConfigurationLoader;

    public static SecureRandom getRND() {
        return rnd;
    }

    public static String getVersionString(String string, String string2) {
        Properties properties = new Properties();
        String string3 = string;
        try {
            properties.load(ConfigurationLoader.loadFile(string2));
            String string4 = string.toLowerCase();
            String string5 = properties.getProperty(string4 + ".version.major");
            String string6 = properties.getProperty(string4 + ".version.minor");
            String string7 = properties.getProperty(string4 + ".version.build");
            String string8 = properties.getProperty(string4 + ".project.type");
            if (string5 != null && string6 != null && string7 != null) {
                string3 = string3 + " " + string5 + "." + string6 + "." + string7;
            }
            if (string8 != null) {
                string3 = string3 + " " + string8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    public static String checkAndGetProperty(String string, String string2) {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new PropertyPermission(string, "read"));
            }
            return System.getProperty(string, string2);
        }
        catch (AccessControlException accessControlException) {
            return string2;
        }
    }

    public static void initialize(boolean bl) throws ConfigurationException {
        ConfigurationLoader.initialize(bl, new DefaultConfigurationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(boolean bl, ConfigurationContext configurationContext) throws ConfigurationException {
        File[] fileArray;
        Object object;
        try {
            object = System.getProperty("java.version");
            log.info("JAVA version is " + (String)object);
            if (((String)object).startsWith("1.3")) {
                boolean bl2 = false;
                int n = 0;
                while (n < Security.getProviders().length) {
                    log.info(Security.getProviders()[n].getName() + " security provider found");
                    if (Security.getProviders()[n].getClass().getName().equals("org.bouncycastle.jce.provider.BouncyCastleProvider")) {
                        bl2 = true;
                    }
                    ++n;
                }
                if (!bl2) {
                    log.info("Attempting to load the bouncycastle jce provider");
                    fileArray = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                    Security.addProvider((Provider)fileArray.newInstance());
                }
            }
        }
        catch (Exception exception) {
            log.info("Failed to load the bouncycastle jce provider", exception);
            if (Security.getProviders().length <= 0) {
                throw new ConfigurationException("There are no security providers available; install jce-jdk13-119.jar available from http://www.bouncycastle.org");
            }
            log.info("An existing provider has been detected");
        }
        object = initializationLock;
        synchronized (object) {
            if (initialized && !bl) {
                return;
            }
            if (ext == null) {
                ext = new ExtensionClassLoader((class$com$sshtools$j2ssh$configuration$ConfigurationLoader == null ? (class$com$sshtools$j2ssh$configuration$ConfigurationLoader = ConfigurationLoader.class$("com.sshtools.j2ssh.configuration.ConfigurationLoader")) : class$com$sshtools$j2ssh$configuration$ConfigurationLoader).getClassLoader());
                try {
                    File file = new File(homedir + "lib" + File.separator + "ext");
                    FilenameFilter filenameFilter = new FilenameFilter(){

                        public boolean accept(File file, String string) {
                            return string.endsWith(".jar");
                        }
                    };
                    fileArray = file.listFiles(filenameFilter);
                    Vector vector = new Vector();
                    if (fileArray != null) {
                        int n = 0;
                        while (n < fileArray.length) {
                            log.info("Extension " + fileArray[n].getAbsolutePath() + " being added to classpath");
                            ext.add(fileArray[n]);
                            ++n;
                        }
                    }
                }
                catch (AccessControlException accessControlException) {
                    log.info("Cannot access lib/ext directory, extension classes will not be loaded");
                }
            }
            SshCipherFactory.initialize();
            SshPrivateKeyFormatFactory.initialize();
            SshPublicKeyFormatFactory.initialize();
            SshCompressionFactory.initialize();
            SshHmacFactory.initialize();
            SshKeyPairFactory.initialize();
            SshKeyExchangeFactory.initialize();
            configurationContext.initialize();
            contexts.add(configurationContext);
            initialized = true;
        }
    }

    public static boolean isConfigurationAvailable(Class clazz) throws ConfigurationException {
        if (!initialized) {
            ConfigurationLoader.initialize(false);
        }
        if (contexts.size() > 0) {
            Iterator iterator = contexts.iterator();
            while (iterator.hasNext()) {
                ConfigurationContext configurationContext = (ConfigurationContext)iterator.next();
                if (!configurationContext.isConfigurationAvailable(clazz)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static Object getConfiguration(Class clazz) throws ConfigurationException {
        if (contexts.size() > 0) {
            Iterator iterator = contexts.iterator();
            while (iterator.hasNext()) {
                ConfigurationContext configurationContext = (ConfigurationContext)iterator.next();
                if (!configurationContext.isConfigurationAvailable(clazz)) continue;
                return configurationContext.getConfiguration(clazz);
            }
        }
        throw new ConfigurationException("No " + clazz.getName() + " configuration is available in this context");
    }

    public static String getConfigurationDirectory() {
        return homedir + "conf/";
    }

    public static Class getExtensionClass(String string) throws ClassNotFoundException, ConfigurationException {
        if (!initialized) {
            ConfigurationLoader.initialize(false);
        }
        if (ext == null) {
            throw new ClassNotFoundException("Configuration not initialized");
        }
        return ext.loadClass(string);
    }

    public static String getHomeDirectory() {
        return homedir;
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        clsLoader = classLoader;
    }

    public static ExtensionClassLoader getExtensionClassLoader() {
        return ext;
    }

    public static String getExtensionPath() {
        return homedir + "/lib/ext";
    }

    public static ClassLoader getContextClassLoader() {
        return clsLoader;
    }

    public static boolean isContextClassLoader() {
        return clsLoader != null;
    }

    public static void setHomeDirectory(String string) {
        homedir = string.replace('\\', '/');
        if (!homedir.endsWith("/")) {
            homedir = homedir + "/";
        }
    }

    public static InputStream loadFile(String string) throws FileNotFoundException {
        try {
            FileInputStream fileInputStream = new FileInputStream(ConfigurationLoader.getConfigurationDirectory() + string);
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                FileInputStream fileInputStream = new FileInputStream(homedir + string);
                return fileInputStream;
            }
            catch (FileNotFoundException fileNotFoundException2) {
                FileInputStream fileInputStream = new FileInputStream(string);
                return fileInputStream;
            }
        }
    }

    public static OutputStream saveFile(String string) throws FileNotFoundException {
        File file = new File(ConfigurationLoader.getConfigurationDirectory() + string);
        if (file.exists()) {
            return new FileOutputStream(file);
        }
        file = new File(string);
        if (file.exists()) {
            return new FileOutputStream(string);
        }
        return new FileOutputStream(string.indexOf(File.pathSeparator) >= 0 ? string : ConfigurationLoader.getConfigurationDirectory() + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ext = null;
        clsLoader = null;
        log = LogFactory.getLog(class$com$sshtools$j2ssh$configuration$ConfigurationLoader == null ? (class$com$sshtools$j2ssh$configuration$ConfigurationLoader = ConfigurationLoader.class$("com.sshtools.j2ssh.configuration.ConfigurationLoader")) : class$com$sshtools$j2ssh$configuration$ConfigurationLoader);
        initialized = false;
        initializationLock = new Object();
        homedir = ConfigurationLoader.checkAndGetProperty("sshtools.home", System.getProperty("java.home"));
        if (homedir != null && !homedir.endsWith(File.separator)) {
            homedir = homedir + File.separator;
        }
        rnd = new SecureRandom();
        rnd.nextInt();
    }

    static class DefaultConfigurationContext
    implements ConfigurationContext {
        DefaultConfigurationContext() {
        }

        public void initialize() throws ConfigurationException {
        }

        public boolean isConfigurationAvailable(Class clazz) {
            return false;
        }

        public Object getConfiguration(Class clazz) throws ConfigurationException {
            throw new ConfigurationException("Default configuration does not contain " + clazz.getName());
        }
    }
}

