/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.sshvnc.SshVNCViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ClipboardFrame
extends JDialog
implements WindowListener,
ActionListener,
DocumentListener {
    JTextArea textArea;
    JButton clearButton;
    JButton closeButton;
    String selection;
    SshVNCViewer viewer;

    ClipboardFrame(Frame frame, SshVNCViewer sshVNCViewer) {
        super(frame, "VNC Clipboard", false);
        this.init(sshVNCViewer);
    }

    ClipboardFrame(Dialog dialog, SshVNCViewer sshVNCViewer) {
        super(dialog, "VNC Clipboard", false);
        this.init(sshVNCViewer);
    }

    ClipboardFrame(SshVNCViewer sshVNCViewer) {
        super((Frame)null, "VNC Clipboard", false);
        this.init(sshVNCViewer);
    }

    private void init(SshVNCViewer sshVNCViewer) {
        this.viewer = sshVNCViewer;
        JPanel jPanel = new JPanel(new FlowLayout(2, 2, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.closeButton = new JButton("Close");
        this.closeButton.setMnemonic('c');
        this.closeButton.addActionListener(this);
        this.closeButton.setDefaultCapable(true);
        jPanel.add(this.closeButton);
        this.clearButton = new JButton("Clear");
        this.clearButton.setMnemonic('l');
        this.clearButton.addActionListener(this);
        jPanel.add(this.clearButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.textArea = new JTextArea(8, 30);
        this.textArea.getDocument().addDocumentListener(this);
        jPanel2.add((Component)new JScrollPane(this.textArea), "Center");
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(new ResourceIcon("/com/sshtools/sshvnc/largeclipboard.png"), jPanel2);
        iconWrapperPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)iconWrapperPanel, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateClipboard();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateClipboard();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateClipboard();
    }

    private void updateClipboard() {
        if (this.selection != null && !this.selection.equals(this.textArea.getText())) {
            this.selection = this.textArea.getText();
            this.viewer.setCutText(this.selection);
        }
    }

    public void setCutText(String string) {
        this.selection = string;
        this.textArea.setText(string);
        if (this.isVisible()) {
            this.textArea.selectAll();
        }
    }

    public JButton getDefaultButton() {
        return this.closeButton;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.clearButton) {
            this.textArea.setText("");
        } else if (actionEvent.getSource() == this.closeButton) {
            this.setVisible(false);
        }
    }
}

