/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.configuration.InvalidProfileFileException;
import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VNCAdvancedTab
extends JPanel
implements SshToolsConnectionTab,
ActionListener {
    static final ResourceIcon vncicon = new ResourceIcon(class$com$sshtools$sshvnc$VNCAdvancedTab == null ? (class$com$sshtools$sshvnc$VNCAdvancedTab = VNCAdvancedTab.class$("com.sshtools.sshvnc.VNCAdvancedTab")) : class$com$sshtools$sshvnc$VNCAdvancedTab, "largevnc.png");
    static final String[] ENCODINGS = new String[]{"Raw", "RRE", "CoRRE", "Hextile", "Zlib", "Tight"};
    static final String[] COMPRESSION_LEVEL = new String[]{"Default", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    static final String[] JPEG_QUALITY = new String[]{"JPEG off", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    static final String[] CURSOR_UPDATES = new String[]{"Enable", "Ignore", "Disable"};
    protected SshToolsConnectionProfile profile;
    protected JComboBox encoding;
    protected JComboBox compressionLevel;
    protected JComboBox jpegQuality;
    protected JComboBox cursorUpdates;
    protected JComboBox bandwidth;
    protected JCheckBox useCopyRect;
    protected JCheckBox restrictedColors;
    protected JCheckBox reverseMouseButtons2And3;
    protected JCheckBox viewOnly;
    protected JCheckBox shareDesktop;
    static /* synthetic */ Class class$com$sshtools$sshvnc$VNCAdvancedTab;

    public VNCAdvancedTab() {
        Insets insets = new Insets(2, 24, 2, 2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weighty = 1.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = new Insets(2, 16, 2, 2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Advanced Settings"));
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = insets;
        gridBagConstraints2.weightx = 0.0;
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Bandwidth Setting"), gridBagConstraints2, -1);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        this.bandwidth = new JComboBox();
        this.loadOptimizedProfiles();
        this.bandwidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SshToolsConnectionProfile sshToolsConnectionProfile = new SshToolsConnectionProfile();
                try {
                    sshToolsConnectionProfile.open(ConfigurationLoader.getConfigurationDirectory() + VNCAdvancedTab.this.bandwidth.getSelectedItem().toString() + ".opt");
                    VNCAdvancedTab.this.profile.setApplicationProperty("PREFERRED_ENCODING", sshToolsConnectionProfile.getApplicationProperty("PREFERRED_ENCODING", null));
                    VNCAdvancedTab.this.encoding.setSelectedIndex(sshToolsConnectionProfile.getApplicationPropertyInt("PREFERRED_ENCODING", 1));
                    VNCAdvancedTab.this.profile.setApplicationProperty("COMPRESS_LEVEL", sshToolsConnectionProfile.getApplicationProperty("COMPRESS_LEVEL", null));
                    VNCAdvancedTab.this.compressionLevel.setSelectedIndex(sshToolsConnectionProfile.getApplicationPropertyInt("COMPRESS_LEVEL", 1));
                    VNCAdvancedTab.this.profile.setApplicationProperty("JPEG_QUALITY", sshToolsConnectionProfile.getApplicationProperty("JPEG_QUALITY", null));
                    VNCAdvancedTab.this.jpegQuality.setSelectedIndex(sshToolsConnectionProfile.getApplicationPropertyInt("JPEG_QUALITY", 1) + 1);
                    VNCAdvancedTab.this.profile.setApplicationProperty("EIGHT_BIT_COLORS", sshToolsConnectionProfile.getApplicationProperty("EIGHT_BIT_COLORS", null));
                    VNCAdvancedTab.this.restrictedColors.setSelected(sshToolsConnectionProfile.getApplicationPropertyBoolean("EIGHT_BIT_COLORS", false));
                    VNCAdvancedTab.this.profile.setApplicationProperty("USE_COPY_RECT", sshToolsConnectionProfile.getApplicationProperty("USE_COPY_RECT", null));
                    VNCAdvancedTab.this.useCopyRect.setSelected(sshToolsConnectionProfile.getApplicationPropertyBoolean("USE_COPY_RECT", false));
                    VNCAdvancedTab.this.setAvailableActions();
                }
                catch (InvalidProfileFileException invalidProfileFileException) {
                    // empty catch block
                }
            }
        });
        UIUtil.jGridBagAdd(jPanel2, this.bandwidth, gridBagConstraints2, 0);
        gridBagConstraints2.insets = new Insets(2, 24, 2, 2);
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Encodings "), gridBagConstraints2, -1);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        this.encoding = new JComboBox<String>(ENCODINGS);
        this.encoding.addActionListener(this);
        UIUtil.jGridBagAdd(jPanel2, this.encoding, gridBagConstraints2, 0);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(2, 24, 2, 2);
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Compression "), gridBagConstraints2, -1);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        this.compressionLevel = new JComboBox<String>(COMPRESSION_LEVEL);
        this.compressionLevel.addActionListener(this);
        UIUtil.jGridBagAdd(jPanel2, this.compressionLevel, gridBagConstraints2, 0);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(2, 24, 2, 2);
        UIUtil.jGridBagAdd(jPanel2, new JLabel("JPEG Quality "), gridBagConstraints2, -1);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        this.jpegQuality = new JComboBox<String>(JPEG_QUALITY);
        this.jpegQuality.addActionListener(this);
        UIUtil.jGridBagAdd(jPanel2, this.jpegQuality, gridBagConstraints2, 0);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(2, 24, 2, 2);
        UIUtil.jGridBagAdd(jPanel2, new JLabel("Cursor shape updates "), gridBagConstraints2, -1);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        this.cursorUpdates = new JComboBox<String>(CURSOR_UPDATES);
        this.cursorUpdates.addActionListener(this);
        UIUtil.jGridBagAdd(jPanel2, this.cursorUpdates, gridBagConstraints2, 0);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(2, 24, 2, 2);
        gridBagConstraints2.weightx = 2.0;
        gridBagConstraints2.insets = new Insets(8, 24, 2, 2);
        this.useCopyRect = new JCheckBox("Use CopyRect");
        this.useCopyRect.addActionListener(this);
        UIUtil.jGridBagAdd(jPanel2, this.useCopyRect, gridBagConstraints2, -1);
        gridBagConstraints2.insets = new Insets(8, 10, 2, 2);
        this.restrictedColors = new JCheckBox("Restricted Colors");
        this.restrictedColors.addActionListener(this);
        UIUtil.jGridBagAdd(jPanel2, this.restrictedColors, gridBagConstraints2, 0);
        gridBagConstraints2.insets = new Insets(4, 24, 2, 2);
        this.reverseMouseButtons2And3 = new JCheckBox("Reverse mouse buttons");
        this.reverseMouseButtons2And3.addActionListener(this);
        UIUtil.jGridBagAdd(jPanel2, this.reverseMouseButtons2And3, gridBagConstraints2, -1);
        gridBagConstraints2.insets = new Insets(4, 10, 2, 2);
        this.viewOnly = new JCheckBox("View only");
        this.viewOnly.addActionListener(this);
        UIUtil.jGridBagAdd(jPanel2, this.viewOnly, gridBagConstraints2, 0);
        gridBagConstraints2.insets = new Insets(4, 24, 2, 2);
        this.shareDesktop = new JCheckBox("Share desktop");
        this.shareDesktop.addActionListener(this);
        UIUtil.jGridBagAdd(jPanel2, this.shareDesktop, gridBagConstraints2, 0);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(vncicon, jPanel3);
        this.setLayout(new BorderLayout());
        this.add((Component)iconWrapperPanel, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setConnectionProfile(null);
    }

    public void setConnectionProfile(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.profile = sshToolsConnectionProfile;
        if (sshToolsConnectionProfile != null) {
            int n = sshToolsConnectionProfile == null ? 7 : sshToolsConnectionProfile.getApplicationPropertyInt("PREFERRED_ENCODING", 7);
            switch (n) {
                case 2: {
                    this.encoding.setSelectedIndex(1);
                    break;
                }
                case 4: {
                    this.encoding.setSelectedIndex(2);
                    break;
                }
                case 5: {
                    this.encoding.setSelectedIndex(3);
                    break;
                }
                case 6: {
                    this.encoding.setSelectedIndex(4);
                    break;
                }
                case 7: {
                    this.encoding.setSelectedIndex(5);
                    break;
                }
                default: {
                    this.encoding.setSelectedIndex(0);
                }
            }
            this.useCopyRect.setSelected(sshToolsConnectionProfile == null ? true : sshToolsConnectionProfile.getApplicationPropertyBoolean("USE_COPY_RECT", true));
            this.compressionLevel.setSelectedIndex(sshToolsConnectionProfile == null ? 0 : sshToolsConnectionProfile.getApplicationPropertyInt("COMPRESS_LEVEL", 0));
            this.jpegQuality.setSelectedIndex(sshToolsConnectionProfile == null ? 7 : sshToolsConnectionProfile.getApplicationPropertyInt("JPEG_QUALITY", 7));
            this.cursorUpdates.setSelectedIndex(sshToolsConnectionProfile == null ? 0 : sshToolsConnectionProfile.getApplicationPropertyInt("CURSOR_UPDATES", 0));
            this.restrictedColors.setSelected(sshToolsConnectionProfile == null ? false : sshToolsConnectionProfile.getApplicationPropertyBoolean("EIGHT_BIT_COLORS", false));
            this.reverseMouseButtons2And3.setSelected(sshToolsConnectionProfile == null ? false : sshToolsConnectionProfile.getApplicationPropertyBoolean("REVERSE_MOUSE_BUTTONS_2_AND_3", false));
            this.viewOnly.setSelected(sshToolsConnectionProfile == null ? false : sshToolsConnectionProfile.getApplicationPropertyBoolean("VIEW_ONLY", false));
            this.shareDesktop.setSelected(sshToolsConnectionProfile == null ? false : sshToolsConnectionProfile.getApplicationPropertyBoolean("SHARE_DESKTOP", false));
        }
        this.setAvailableActions();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setAvailableActions();
    }

    private void setAvailableActions() {
        this.compressionLevel.setEnabled(this.encoding.getSelectedIndex() == 4 || this.encoding.getSelectedIndex() == 5);
        this.jpegQuality.setEnabled(this.encoding.getSelectedIndex() == 5 && !this.restrictedColors.isSelected());
    }

    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    public String getTabContext() {
        return "Connection";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "VNC Advanced";
    }

    public String getTabToolTipText() {
        return "Here you may select advanced VNC settings such as the encoding method, bandwidth settings and other miscellaneous options";
    }

    public int getTabMnemonic() {
        return 97;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        int n = 0;
        switch (this.encoding.getSelectedIndex()) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            case 5: {
                n = 7;
            }
        }
        this.profile.setApplicationProperty("PREFERRED_ENCODING", n);
        this.profile.setApplicationProperty("USE_COPY_RECT", this.useCopyRect.isSelected());
        this.profile.setApplicationProperty("COMPRESS_LEVEL", this.compressionLevel.getSelectedIndex());
        this.profile.setApplicationProperty("JPEG_QUALITY", this.jpegQuality.getSelectedIndex());
        this.profile.setApplicationProperty("CURSOR_UPDATES", this.cursorUpdates.getSelectedIndex());
        this.profile.setApplicationProperty("EIGHT_BIT_COLORS", this.restrictedColors.isSelected());
        this.profile.setApplicationProperty("REVERSE_MOUSE_BUTTONS_2_AND_3", this.reverseMouseButtons2And3.isSelected());
        this.profile.setApplicationProperty("VIEW_ONLY", this.viewOnly.isSelected());
        this.profile.setApplicationProperty("SHARE_DESKTOP", this.shareDesktop.isSelected());
    }

    public void tabSelected() {
    }

    private void loadOptimizedProfiles() {
        File[] fileArray = this.recurseDir(new File(ConfigurationLoader.getConfigurationDirectory()));
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                try {
                    SshToolsConnectionProfile sshToolsConnectionProfile = new SshToolsConnectionProfile();
                    sshToolsConnectionProfile.open(fileArray[n].getAbsolutePath());
                    if (sshToolsConnectionProfile != null) {
                        this.bandwidth.addItem(sshToolsConnectionProfile.getApplicationProperty("PROFILE_NAME", null));
                    }
                }
                catch (InvalidProfileFileException invalidProfileFileException) {
                    // empty catch block
                }
                ++n;
            }
        }
        if (this.bandwidth.getModel().getSize() == 0) {
            this.bandwidth.addItem("None found");
            this.bandwidth.setSelectedIndex(0);
            this.bandwidth.setEnabled(false);
        }
    }

    private File[] recurseDir(File file) {
        return file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".opt");
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

