/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static boolean closeStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean closeStream(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean delTree(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (IOUtil.delTree(fileArray[i])) continue;
            return false;
        }
        return true;
    }

    public static void recurseDeleteDirectory(File file) {
        int n;
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray == null) {
            return;
        }
        for (n = 0; n < fileArray.length; ++n) {
            IOUtil.recurseDeleteDirectory(fileArray[n]);
            fileArray[n].delete();
        }
        fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory();
            }
        });
        for (n = 0; n < fileArray.length; ++n) {
            fileArray[n].delete();
        }
        file.delete();
    }

    public static void copyFile(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].getName().equals(".") || fileArray[i].getName().equals("..")) continue;
                if (fileArray[i].isDirectory()) {
                    File file3 = new File(file2, fileArray[i].getName());
                    IOUtil.copyFile(fileArray[i], file3);
                    continue;
                }
                IOUtil.copyFile(fileArray[i], file2);
            }
        } else if (file.isFile() && (file2.isDirectory() || file2.isFile())) {
            int n;
            if (file2.isDirectory()) {
                file2 = new File(file2, file.getName());
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[32678];
            while ((n = fileInputStream.read(byArray)) > -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            IOUtil.closeStream(fileInputStream);
            IOUtil.closeStream(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n;
            long l = 0L;
            byte[] byArray = new byte[65535];
            while ((n = inputStream.read(byArray)) > -1) {
                if (n <= 0) continue;
                outputStream.write(byArray, 0, n);
                l += (long)n;
            }
        }
        finally {
            IOUtil.closeStream(inputStream);
            IOUtil.closeStream(outputStream);
        }
    }
}

