/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.openssh.PEM;
import com.sshtools.j2ssh.util.Base64;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class PEMWriter
extends PEM {
    private String type;
    private Map header = new HashMap();
    private byte[] payload;

    public void write(Writer writer) throws IOException {
        PrintWriter printWriter = new PrintWriter(writer, true);
        printWriter.println("-----BEGIN " + this.type + "-----");
        if (!this.header.isEmpty()) {
            Iterator iterator = this.header.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this.header.get(string);
                printWriter.print(string + ": ");
                if (string.length() + string2.length() + 2 > 75) {
                    int n;
                    printWriter.println(string2.substring(0, n) + "\\");
                    for (n = Math.max(75 - string.length() - 2, 0); n < string2.length(); n += 75) {
                        if (n + 75 >= string2.length()) {
                            printWriter.println(string2.substring(n));
                            continue;
                        }
                        printWriter.println(string2.substring(n, n + 75) + "\\");
                    }
                    continue;
                }
                printWriter.println(string2);
            }
            printWriter.println();
        }
        printWriter.println(Base64.encodeBytes(this.payload, false));
        printWriter.println("-----END " + this.type + "-----");
    }

    public void encryptPayload(byte[] byArray, String string) throws GeneralSecurityException {
        if (string == null || string.length() == 0) {
            this.setPayload(byArray);
            return;
        }
        SecureRandom secureRandom = ConfigurationLoader.getRND();
        byte[] byArray2 = new byte[8];
        secureRandom.nextBytes(byArray2);
        StringBuffer stringBuffer = new StringBuffer(16);
        for (int i = 0; i < byArray2.length; ++i) {
            stringBuffer.append(HEX_CHARS[(byArray2[i] & 0xFF) >> 4]);
            stringBuffer.append(HEX_CHARS[byArray2[i] & 0xF]);
        }
        this.header.put("DEK-Info", "DES-EDE3-CBC," + stringBuffer);
        this.header.put("Proc-Type", "4,ENCRYPTED");
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        SecretKey secretKey = PEMWriter.getKeyFromPassphrase(string, byArray2, 24);
        cipher.init(1, (Key)secretKey, new IvParameterSpec(byArray2));
        byte[] byArray3 = new byte[byArray.length];
        cipher.update(byArray, 0, byArray.length, byArray3, 0);
        this.setPayload(byArray3);
    }

    public Map getHeader() {
        return this.header;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getType() {
        return this.type;
    }

    public void setPayload(byte[] byArray) {
        this.payload = byArray;
    }

    public void setType(String string) {
        this.type = string;
    }
}

